/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.number.complex;

import dev.nm.algebra.structure.Field;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;
import dev.nm.number.NumberUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Complex
extends Number
implements Field<Complex>,
NumberUtils.Comparable<Complex> {
    private final double if;
    public static final Complex ONE;
    private final double new;
    public static final Complex ZERO;
    public static final Complex I;
    public static final Complex NEGATIVE_INFINITY;
    public static final Complex POSITIVE_INFINITY;
    private static final long serialVersionUID = 1L;
    public static final Complex NaN;

    public double real() {
        return this.if;
    }

    @Override
    @Deprecated
    public long longValue() {
        throw new UnsupportedOperationException("Complex number cannot be converted to long.");
    }

    public static boolean isNaN(Complex z) {
        return Double.isNaN(z.if) || Double.isNaN(z.new);
    }

    @Override
    public double doubleValue() {
        if (!Complex.isReal(this)) {
            throw new IllegalArgumentException(String.format("this complex number %s is not real", this.toString()));
        }
        return this.if;
    }

    public double modulus() {
        if (DoubleUtils.isZero(this.new, 0.0)) {
            return Math.abs(this.if);
        }
        if (DoubleUtils.isZero(this.if, 0.0)) {
            return Math.abs(this.new);
        }
        return Math.hypot(this.if, this.new);
    }

    @Override
    public Complex inverse() throws Field.InverseNonExistent {
        if (DoubleUtils.isZero(this.if, 0.0) && DoubleUtils.isZero(this.new, 0.0)) {
            throw new Field.InverseNonExistent();
        }
        double a2 = this.modulus();
        return new Complex(this.if / a2, -this.new / a2);
    }

    @Override
    public Complex ONE() {
        return ONE;
    }

    @Override
    public Complex add(Complex that) {
        return new Complex(this.if + that.if, this.new + that.new);
    }

    @Override
    public int compare(Number that, double epsilon) {
        Complex a2 = that instanceof Complex ? (Complex)that : new Complex(that.doubleValue(), 0.0);
        int a3 = DoubleUtils.compare(this.if, a2.if, epsilon);
        if (a3 != 0) {
            return a3;
        }
        return DoubleUtils.compare(this.new, a2.new, epsilon);
    }

    @Override
    public Complex multiply(Complex that) {
        double a2 = this.if * that.if;
        double a3 = this.new * that.new;
        return new Complex(a2 - a3, (this.if + this.new) * (that.if + that.new) - a2 - a3);
    }

    static {
        Package.validate("NMDEV_BASIC");
        I = new Complex(0.0, 1.0);
        ZERO = new Complex(0.0, 0.0);
        ONE = new Complex(1.0, 0.0);
        POSITIVE_INFINITY = new Complex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        NEGATIVE_INFINITY = new Complex(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        NaN = new Complex(Double.NaN, Double.NaN);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Complex a2 = (Complex)obj;
        if (Complex.isNaN(a2)) {
            return Complex.isNaN(this);
        }
        if (DoubleUtils.compare(this.if, a2.if, 0.0) != 0) {
            return false;
        }
        return DoubleUtils.compare(this.new, a2.new, 0.0) == 0;
    }

    public Double toDouble() {
        if (!Complex.isReal(this)) {
            throw new IllegalArgumentException(String.format("this complex number %s is not real", this.toString()));
        }
        return new Double(this.if);
    }

    public static Complex fromPolar(double r, double theta) {
        return new Complex(r * Math.cos(theta), r * Math.sin(theta));
    }

    public double arg() {
        return Math.atan2(this.new, this.if);
    }

    @Override
    public Complex divide(Complex that) {
        Complex a2;
        if (Complex.isNaN(this) || Complex.isNaN(that)) {
            return NaN;
        }
        if (Complex.isInfinite(that) && !Complex.isInfinite(this)) {
            return that.ZERO();
        }
        double a3 = this.if;
        double a4 = this.new;
        double a5 = that.if;
        double a6 = that.new;
        if (Math.abs(a5) < Math.abs(a6)) {
            if (DoubleUtils.isZero(a6, 0.0)) {
                throw new ArithmeticException("division by zero");
            }
            double a7 = a5 / a6;
            double a8 = a5 * a7 + a6;
            a2 = new Complex((a3 * a7 + a4) / a8, (a4 * a7 - a3) / a8);
        } else {
            if (DoubleUtils.isZero(a5, 0.0)) {
                throw new ArithmeticException("division by zero");
            }
            double a9 = a6 / a5;
            double a10 = a6 * a9 + a5;
            a2 = new Complex((a4 * a9 + a3) / a10, (a4 - a3 * a9) / a10);
        }
        return a2;
    }

    @Override
    public Complex ZERO() {
        return ZERO;
    }

    public int hashCode() {
        int a2 = 7;
        a2 = 53 * a2 + (int)(Double.doubleToLongBits(this.if) ^ Double.doubleToLongBits(this.if) >>> 32);
        a2 = 53 * a2 + (int)(Double.doubleToLongBits(this.new) ^ Double.doubleToLongBits(this.new) >>> 32);
        return a2;
    }

    public double imaginary() {
        return this.new;
    }

    public Complex(double a2, double b2) {
        if (Double.isNaN(a2) || Double.isNaN(b2)) {
            this.if = Double.NaN;
            this.new = Double.NaN;
        } else {
            this.if = a2;
            this.new = b2;
        }
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    public Complex(double a2) {
        this(a2, 0.0);
    }

    public static boolean isReal(Complex z) {
        return DoubleUtils.isZero(z.new, 0.0);
    }

    public String toString() {
        String a2 = String.format("%f%s%fi", this.if, this.new >= 0.0 ? "+" : "", this.new);
        return a2;
    }

    @Override
    public Complex minus(Complex that) {
        return new Complex(this.if - that.if, this.new - that.new);
    }

    public Complex conjugate() {
        return new Complex(this.if, -this.new);
    }

    public static boolean isInfinite(Complex z) {
        return !Complex.isNaN(z) && (Double.isInfinite(z.if) || Double.isInfinite(z.new));
    }

    @Override
    @Deprecated
    public int intValue() {
        throw new UnsupportedOperationException("Complex number cannot be converted to int.");
    }

    @Override
    public Complex opposite() {
        return new Complex(-this.if, -this.new);
    }
}

