/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.graph.algorithm.traversal;

import dev.nm.graph.Arc;
import dev.nm.graph.Edge;
import dev.nm.graph.Graph;
import dev.nm.graph.algorithm.traversal.GraphTraversal;
import dev.nm.graph.algorithm.traversal.TraversalFromRoots;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;

public class BFS<V>
extends TraversalFromRoots<V>
implements GraphTraversal<V> {
    @Override
    public List<? extends Node<V>> track(V root, int time) {
        return BFS.BFS(this.g, root, time);
    }

    public BFS(Graph<V, ? extends Edge<V>> g2) {
        super(g2);
    }

    public static <V, W extends V> List<Node<V>> BFS(Graph<W, ? extends Edge<V>> g2, V root, int time) {
        IdentityHashMap a3 = new IdentityHashMap();
        a3.put(root, new Node<V>(root));
        ConcurrentLinkedQueue<Object> a4 = new ConcurrentLinkedQueue<Object>();
        a4.add(a3.get(root));
        while (!a4.isEmpty()) {
            Node a2 = (Node)a4.poll();
            a2.setVisitTime(time++);
            ArrayList a5 = new ArrayList();
            for (Edge edge : g2.edges(a2.vertex())) {
                Object a7 = edge.neighbor(a2.vertex());
                if (a7 == null || a7 == a2.vertex() || !(edge instanceof Arc) && a2.parent() == a7) continue;
                Node a8 = (Node)a3.get(a7);
                if (a8 == null) {
                    a8 = new Node(a7);
                    a3.put(a7, a8);
                }
                if (a8.parent() != null) continue;
                a5.add(a8);
            }
            for (Node node : a5) {
                node.setParent(a2);
                a4.add(node);
            }
        }
        ArrayList<Node<V>> a2 = new ArrayList<Node<V>>(a3.values());
        Collections.sort(a2);
        return a2;
    }

    @Override
    public List<Node<V>> getOrderedNodes() {
        List a2 = super.getOrderedNodes();
        ArrayList<Node<V>> a3 = new ArrayList<Node<V>>();
        for (GraphTraversal.Node a4 : a2) {
            a3.add((Node)a4);
        }
        return a3;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Node<V>
    extends GraphTraversal.Node<V> {
        private int new = 0;

        @Override
        protected void setParent(Node<V> parent) {
            super.setParent(parent.vertex());
            if (this.new == 0) {
                this.new = parent.new + 1;
            }
            this.final(parent.new + 1);
        }

        private void final(int a2) {
            Node a3;
            if (a3.new > a2) {
                a3.new = a2;
            }
        }

        public int depth() {
            return this.new;
        }

        protected Node(V vertex) {
            super(vertex);
        }

        @Override
        public String toString() {
            StringBuilder a2 = new StringBuilder();
            a2.append(String.format("[(%s->)%s, ", this.parent() != null ? this.parent() : "", this.vertex()));
            a2.append(String.format("%d, %d]", this.depth(), this.visitTime()));
            return a2.toString();
        }
    }
}

