/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.geometry;

import dev.nm.analysis.function.tuple.Pair;
import dev.nm.misc.license.Package;

public final class TrigMath {
    public static double vers(double a2) {
        double a3 = Math.sin(a2 / 2.0);
        return 2.0 * a3 * a3;
    }

    public static double exsec(double a2) {
        return TrigMath.vers(a2) / Math.cos(a2);
    }

    private TrigMath() {
        TrigMath a2;
    }

    public static double ahav(double a2) {
        if (a2 < 0.0 || a2 > 1.0) {
            return Double.NaN;
        }
        return Math.acos(1.0 - 2.0 * a2);
    }

    public static double sec(double a2) {
        return 1.0 / Math.cos(a2);
    }

    public static double hav(double a2) {
        return TrigMath.vers(a2) / 2.0;
    }

    static {
        Package.validate("NMDEV_BASIC");
    }

    public static double csch(double a2) {
        return 1.0 / Math.sinh(a2);
    }

    public static double asech(double a2) {
        return TrigMath.acosh(1.0 / a2);
    }

    public static double sech(double a2) {
        return 1.0 / Math.cosh(a2);
    }

    public static double cosec(double a2) {
        return 1.0 / Math.sin(a2);
    }

    public static double sinc(double a2) {
        double a3 = Math.sin(a2) / a2;
        if (a2 == 0.0) {
            a3 = 1.0;
        }
        return a3 > 1.0 ? 1.0 : a3;
    }

    public static double asinh(double a2) {
        if (a2 == Double.NEGATIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        return Math.log(a2 + Math.sqrt(a2 * a2 + 1.0));
    }

    public static double angle(double a2, double b2, double c2) {
        return Math.acos((b2 * b2 + c2 * c2 - a2 * a2) / (2.0 * b2 * c2));
    }

    public static double asec(double a2) {
        return Math.acos(1.0 / a2);
    }

    public static double acot(double a2) {
        if (a2 == 0.0) {
            return Double.NaN;
        }
        return Math.atan(1.0 / a2);
    }

    public static double acsch(double a2) {
        return TrigMath.asinh(1.0 / a2);
    }

    public static double atanh(double a2) {
        return 0.5 * Math.log((1.0 + a2) / (1.0 - a2));
    }

    public static double acosh(double a2) {
        return Math.log(a2 + Math.sqrt(a2 * a2 - 1.0));
    }

    public static double coth(double a2) {
        return 1.0 / Math.tanh(a2);
    }

    public static double acsc(double a2) {
        return Math.asin(1.0 / a2);
    }

    public static double cot(double a2) {
        return 1.0 / Math.tan(a2);
    }

    public static double aexsec(double a2) {
        return TrigMath.asec(a2 + 1.0);
    }

    public static double angle(Pair A2, Pair B2, Pair C3) {
        double a2 = Math.hypot(B2.x() - C3.x(), B2.y() - C3.y());
        double a3 = Math.hypot(A2.x() - C3.x(), A2.y() - C3.y());
        double a4 = Math.hypot(A2.x() - B2.x(), A2.y() - B2.y());
        return TrigMath.angle(a2, a3, a4);
    }

    public static double acot2(double x, double y) {
        return Math.atan2(y, x);
    }

    public static double avers(double a2) {
        if (a2 < 0.0 || a2 > 2.0) {
            return Double.NaN;
        }
        return 2.0 * Math.asin(Math.sqrt(a2 / 2.0));
    }

    public static double acovers(double a2) {
        if (a2 < 0.0 || a2 > 2.0) {
            return Double.NaN;
        }
        return Math.asin(1.0 - a2);
    }

    public static double covers(double a2) {
        return 1.0 - Math.sin(a2);
    }

    public static double acoth(double a2) {
        return TrigMath.atanh(1.0 / a2);
    }
}

