/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.geometry;

import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.geometry.Point;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LineSegment {
    private final Point if;
    private final Point new;

    public Point getEndPoint2() {
        return this.new;
    }

    public int dimension() {
        return this.if.dimension();
    }

    private void final(Point a2) {
        LineSegment a3;
        ArgumentAssertion.assertTrue(a2.dimension() == a3.dimension(), "dimensions of the point(%d) and the line segment(%d) must match", a2.dimension(), a3.dimension());
    }

    public Point getEndPoint1() {
        return this.if;
    }

    public double perpendicularDistance(Point p) {
        this.final(p);
        if (this.length() == 0.0) {
            return p.distance(this.if);
        }
        Vector a2 = this.if.getCoordinates().minus(p.getCoordinates());
        Vector a3 = this.new.getCoordinates().minus(this.if.getCoordinates());
        a3 = a3.scaled(1.0 / a3.norm());
        Vector a4 = a3.scaled(a2.innerProduct(a3));
        Vector a5 = a2.minus(a4);
        return a5.norm();
    }

    static {
        Package.validate("NMDEV_BASIC");
    }

    public double length() {
        return this.if.distance(this.new);
    }

    public double distance(Point p) {
        this.final(p);
        double a2 = this.length();
        if (a2 == 0.0) {
            return p.distance(this.if);
        }
        ImmutableVector a3 = this.if.getCoordinates();
        ImmutableVector a4 = this.new.getCoordinates();
        ImmutableVector a5 = p.getCoordinates();
        Vector a6 = a4.minus(a3);
        double a7 = a5.minus(a3).innerProduct(a6) / (a2 * a2);
        if (a7 < 0.0) {
            return p.distance(this.if);
        }
        if (a7 > 1.0) {
            return p.distance(this.new);
        }
        Point a8 = new Point(a3.add(a6.scaled(a7)));
        return p.distance(a8);
    }

    public LineSegment(Point p1, Point p2) {
        ArgumentAssertion.assertTrue(p1.dimension() == p2.dimension(), "dimensions of p1(%d) and p2(%d) must match", p1.dimension(), p2.dimension());
        this.if = p1;
        this.new = p2;
    }
}

