/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.integration.univariate.riemann.gaussian.rule;

import dev.nm.analysis.integration.univariate.riemann.gaussian.rule.GaussianQuadratureRule;
import dev.nm.number.DoubleUtils;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ChebyshevRule
implements GaussianQuadratureRule {
    private final int new;

    public ChebyshevRule(int n) {
        this.new = n;
    }

    @Override
    public double getWeighting(double x) {
        return 1.0 / Math.sqrt(1.0 - x * x);
    }

    @Override
    public double[] getCoefficients() {
        double[] a2 = DoubleUtils.rep(Math.PI / (double)this.new, this.new);
        return a2;
    }

    @Override
    public boolean supportsInterval(double a2, double b2) {
        return a2 == -1.0 && b2 == 1.0;
    }

    @Override
    public double[] getEvaluationPoints() {
        double[] a2 = new double[this.new];
        for (int a3 = 1; a3 <= this.new; ++a3) {
            a2[a3 - 1] = Math.cos((2.0 * (double)a3 - 1.0) * Math.PI / (2.0 * (double)this.new));
        }
        Arrays.sort(a2);
        return a2;
    }
}

