/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.function.special.gamma;

import dev.nm.analysis.function.polynomial.Polynomial;
import dev.nm.analysis.function.rn2r1.AbstractBivariateRealFunction;
import dev.nm.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import dev.nm.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import dev.nm.analysis.function.special.gamma.Gamma;
import dev.nm.analysis.function.special.gamma.GammaLanczosQuick;
import dev.nm.analysis.function.special.gamma.GammaRegularizedP;
import dev.nm.analysis.function.special.gamma.LogGamma;
import dev.nm.analysis.function.special.gaussian.ErfInverse;
import dev.nm.analysis.root.univariate.HalleyRoot;
import dev.nm.analysis.root.univariate.NoRootFoundException;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.Constants;
import dev.nm.number.DoubleUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GammaRegularizedPInverse
extends AbstractBivariateRealFunction {
    private static final Polynomial try;
    private static final LogGamma float;
    private static final Gamma short;
    private static final GammaRegularizedP enum;
    private static final Polynomial false;
    private static final Polynomial void;
    private static final Polynomial if;
    private static final Polynomial new;

    double evaluateByAsymptoticInversion(double a2, double a3) throws NoRootFoundException {
        double a4;
        double a5;
        double a6;
        double a7;
        double a8;
        double a9;
        double a10;
        double a11;
        ErfInverse a12 = new ErfInverse();
        double a13 = a12.evaluate(1.0 - 2.0 * a3) / Math.sqrt(a2 / 2.0);
        if ((a11 = false.evaluate(a10 = (a13 *= -1.0) + (a9 = ((a8 = if.evaluate(a13)) + ((a7 = void.evaluate(a13)) + ((a6 = new.evaluate(a13)) + (a5 = try.evaluate(a13)) / a2) / a2) / a2) / a2))) < 0.0) {
            GammaRegularizedPInverse a14;
            a4 = 0.5 * a13 * a13;
            HalleyRoot a15 = new HalleyRoot(Constants.EPSILON, 50);
            a11 = a15.solve((UnivariateRealFunction)new AbstractUnivariateRealFunction(){
                {
                    4 a3;
                }

                @Override
                public double evaluate(double x) {
                    double a2 = x - 1.0 - Math.log(x) - a4;
                    return a2;
                }
            }, new AbstractUnivariateRealFunction(){
                {
                    5 a3;
                }

                @Override
                public double evaluate(double x) {
                    double a2 = 1.0 - 1.0 / x;
                    return a2;
                }
            }, new AbstractUnivariateRealFunction(){

                @Override
                public double evaluate(double x) {
                    double a2 = 1.0 - 1.0 / x / x;
                    return a2;
                }
                {
                    6 a3;
                }
            }, a4);
        }
        a4 = a2 * a11;
        return a4;
    }

    double evaluateByApproximation(double a2, double a3) {
        double a4 = a3 * short.evaluate(a2 + 1.0);
        double a5 = Math.pow(a4, 1.0 / a2);
        double a6 = enum.evaluate(a2, a5) - a3;
        double a7 = -Math.pow(a5, 1.0 - a2);
        a7 *= Math.exp(a5);
        double a8 = (a7 *= short.evaluate(a2)) * a7;
        a8 *= a5 + 1.0 - a2;
        a8 /= 2.0 * a5;
        double a9 = a2 * a2;
        double a10 = a7 * a7 * a7;
        a10 *= 2.0 * a5 * a5 + 4.0 * a5 * (1.0 - a2) + 2.0 * a9 - 3.0 * a2 + 1.0;
        double a11 = a5 * a5 * a5;
        double a12 = a7 * a7 * a7 * a7;
        a12 *= 6.0 * a11 + 18.0 * a5 * a5 * (1.0 - a2) + a5 * (18.0 * a9 - 29.0 * a2 + 11.0) - 6.0 * a2 * a9 + 11.0 * a9 - 6.0 * a2 + 1.0;
        double a13 = (a7 + (a8 + ((a10 /= 6.0 * a5 * a5) + (a12 /= 24.0 * a11) * a6) * a6) * a6) * a6;
        return a5 + a13;
    }

    @Override
    public double evaluate(final double s, final double u) {
        ArgumentAssertion.assertPositive(s, "s");
        try {
            double a2 = 0.0;
            if (DoubleUtils.isZero(u, 0.0)) {
                return 0.0;
            }
            if (DoubleUtils.compare(u, 1.0, 0.0) == 0) {
                return Double.POSITIVE_INFINITY;
            }
            a2 = DoubleUtils.compare(s, 1.0, 0.0) <= 0 ? this.evaluateByApproximation(s, u) : this.evaluateByAsymptoticInversion(s, u);
            AbstractUnivariateRealFunction a3 = new AbstractUnivariateRealFunction(){
                {
                    1 a3;
                }

                @Override
                public double evaluate(double x) {
                    return enum.evaluate(s, x) - u;
                }
            };
            AbstractUnivariateRealFunction a4 = new AbstractUnivariateRealFunction(){

                @Override
                public double evaluate(double x) {
                    double a2 = -x;
                    a2 += (s - 1.0) * Math.log(x);
                    a2 -= float.evaluate(s);
                    a2 = Math.exp(a2);
                    return a2;
                }
                {
                    2 a3;
                }
            };
            AbstractUnivariateRealFunction a5 = new AbstractUnivariateRealFunction(){

                @Override
                public double evaluate(double x) {
                    double a2 = -x;
                    a2 += (s - 2.0) * Math.log(x);
                    a2 -= float.evaluate(s);
                    a2 = Math.exp(a2);
                    return a2 *= -x + s - 1.0;
                }
                {
                    3 a3;
                }
            };
            HalleyRoot a6 = new HalleyRoot(1.0E-16, 50);
            double a7 = a6.solve((UnivariateRealFunction)a3, a4, a5, a2);
            return a7;
        }
        catch (Exception a8) {
            throw new RuntimeException(a8);
        }
    }

    static {
        short = new GammaLanczosQuick();
        float = new LogGamma();
        enum = new GammaRegularizedP();
        if = new Polynomial(-2.8741263309164543E-5, 2.755731922398589E-4, -0.0010802469135802468, 6.172839506172839E-4, 0.027777777777777776, -0.3333333333333333);
        void = new Polynomial(6.229995427526292E-5, -7.520766651425087E-4, 0.002611209092690574, -0.002700617283950617, -0.01728395061728395);
        new = new Polynomial(6.554653913335898E-5, 7.956376423454613E-4, -0.003007782731290962, 0.004399372917891437);
        try = new Polynomial(2.9719735544227286E-4, -4.5808052481112146E-4, -6.36443186258144E-5, 0.0017364513249286911);
        false = new Polynomial(2.314814814814815E-4, -0.003703703703703704, 0.027777777777777776, 0.3333333333333333, 1.0, 1.0);
    }
}

