/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.differentialequation.ode.ivp.solver.rungekutta;

import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.analysis.differentialequation.ode.ivp.problem.ODE1stOrder;
import dev.nm.analysis.differentialequation.ode.ivp.solver.ODESolution;
import dev.nm.analysis.differentialequation.ode.ivp.solver.ODESolver;
import dev.nm.analysis.differentialequation.ode.ivp.solver.rungekutta.RungeKuttaIntegrator;
import dev.nm.analysis.differentialequation.ode.ivp.solver.rungekutta.RungeKuttaStepper;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RungeKutta
implements ODESolver {
    private final RungeKuttaStepper if;
    private final Step new;

    public RungeKutta(RungeKuttaStepper stepper, final double h2) {
        this.if = stepper;
        this.new = new Step(){
            {
                1 a3;
            }

            @Override
            public double size(double x0, double x1) {
                return h2;
            }
        };
    }

    @Override
    public ODESolution solve(ODE1stOrder ode) {
        double[] a2 = DoubleUtils.seq(ode.x0(), ode.x1(), this.new.size(ode.x0(), ode.x1()));
        a2[a2.length - 1] = ode.x1();
        RungeKuttaIntegrator a3 = new RungeKuttaIntegrator(this.if);
        Vector[] a4 = a3.integrate(ode, a2);
        return new ODESolution(a2, a4);
    }

    public RungeKutta(RungeKuttaStepper stepper, final int N) {
        ArgumentAssertion.assertNotLessThan(N, 2, "N");
        this.if = stepper;
        this.new = new Step(){
            {
                2 a3;
            }

            @Override
            public double size(double x0, double x1) {
                return (x1 - x0) / (double)(N - 1);
            }
        };
    }

    static {
        Package.validate("NMDEV_OPDE");
    }

    private static interface Step {
        public double size(double var1, double var3);
    }
}

