/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.curvefit.interpolation.univariate;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.linearsystem.LSProblem;
import dev.nm.algebra.linear.matrix.doubles.linearsystem.LUSolver;
import dev.nm.algebra.linear.matrix.doubles.linearsystem.ThomasAlgorithm;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.TridiagonalMatrix;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.analysis.curvefit.interpolation.univariate.Interpolation;
import dev.nm.analysis.curvefit.interpolation.univariate.PairLookup;
import dev.nm.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import dev.nm.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import dev.nm.analysis.function.tuple.OrderedPairs;
import dev.nm.analysis.function.tuple.SortedOrderedPairs;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;
import dev.nm.number.doublearray.SimpleDoubleArrayOperation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CubicSpline
implements Interpolation {
    private final EndConditions new;

    static {
        Package.validate("NMDEV_BASIC");
    }

    public static CubicSpline clamped(double df1, double dfn) {
        return new CubicSpline(new Clamped(df1, dfn));
    }

    public static CubicSpline notAKnot() {
        return new CubicSpline(new NotAKnot());
    }

    public CubicSpline() {
        this(new Natural());
    }

    public static CubicSpline clamped() {
        return CubicSpline.clamped(0.0, 0.0);
    }

    public static CubicSpline natural() {
        return new CubicSpline(new Natural());
    }

    @Override
    public UnivariateRealFunction fit(OrderedPairs pairs) {
        int a2 = pairs.size();
        ArgumentAssertion.assertNotLessThan(a2, 3, "number of points");
        final SortedOrderedPairs a3 = new SortedOrderedPairs(pairs);
        double[] a4 = a3.x();
        double[] a5 = a3.y();
        double[] a6 = DoubleUtils.diff(a4);
        double[] a7 = new SimpleDoubleArrayOperation().divide(DoubleUtils.diff(a5), a6);
        final double[] a8 = this.new.solveForC(new DenseVector(a6), new DenseVector(a7)).toArray();
        final double[] a9 = new double[a2 - 1];
        final double[] a10 = new double[a2 - 1];
        final double[] a11 = new double[a2 - 1];
        for (int a12 = 0; a12 < a9.length; ++a12) {
            a9[a12] = a5[a12];
            a10[a12] = (a5[a12 + 1] - a5[a12]) / a6[a12] - a6[a12] / 3.0 * (2.0 * a8[a12] + a8[a12 + 1]);
            a11[a12] = (a8[a12 + 1] - a8[a12]) / (3.0 * a6[a12]);
        }
        return new AbstractUnivariateRealFunction(){
            private final PairLookup new;

            @Override
            public double evaluate(double x) {
                if (x < this.new.first().x()) {
                    double a2 = this.new.first().x();
                    double a32 = this.new.first().y();
                    double a4 = a10[0];
                    return this.final(a4, a2, a32, x);
                }
                if (x > this.new.last().x()) {
                    int a5 = this.new.size() - 1;
                    double a6 = this.new.last().x();
                    double a7 = this.new.last().y();
                    double a82 = this.final(a5 - 1, a6);
                    return this.final(a82, a6, a7, x);
                }
                ArgumentAssertion.assertRange(x, this.new.first().x(), this.new.last().x(), "x");
                int a92 = this.new.getFloorIndex(x);
                if (a92 == this.new.size() - 1) {
                    return this.new.last().y();
                }
                return this.char(a92, x);
            }
            {
                1 a32;
                a32.new = new PairLookup(a32.a3);
            }

            private double final(double a2, double a32, double a4, double a5) {
                return a2 * (a5 - a32) + a4;
            }

            private double char(int a2, double a32) {
                1 a4;
                double a5 = a4.new.get(a2).x();
                double a6 = a32 - a5;
                double a7 = a6 * a6;
                double a82 = a7 * a6;
                double a92 = a4.a9[a2] + a4.a10[a2] * a6 + a4.a8[a2] * a7 + a4.a11[a2] * a82;
                return a92;
            }

            private double final(int a2, double a32) {
                1 a4;
                double a5 = a4.new.get(a2).x();
                double a6 = a32 - a5;
                double a7 = a4.a10[a2] + 2.0 * a4.a8[a2] * a6 + 3.0 * a4.a11[a2] * a6 * a6;
                return a7;
            }
        };
    }

    private CubicSpline(EndConditions a2) {
        CubicSpline a3;
        a3.new = a2;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     * Duplicate member names - consider using --renamedupmembers true
     */
    private static class NotAKnot
    implements EndConditions {
        private Matrix final(Vector a2) {
            int a3 = a2.size() + 1;
            DenseMatrix a4 = new DenseMatrix(a3, a3);
            a4.set(1, 1, a2.get(2));
            a4.set(1, 2, -(a2.get(1) + a2.get(2)));
            a4.set(1, 3, a2.get(1));
            for (int a5 = 2; a5 <= a3 - 1; ++a5) {
                a4.set(a5, a5 - 1, a2.get(a5 - 1));
                a4.set(a5, a5, 2.0 * (a2.get(a5 - 1) + a2.get(a5)));
                a4.set(a5, a5 + 1, a2.get(a5));
            }
            a4.set(a3, a3 - 2, a2.get(a3 - 1));
            a4.set(a3, a3 - 1, -(a2.get(a3 - 2) + a2.get(a3 - 1)));
            a4.set(a3, a3, a2.get(a3 - 2));
            return a4;
        }

        private NotAKnot() {
            NotAKnot a2;
        }

        @Override
        public Vector solveForC(Vector h2, Vector w) {
            Matrix a2 = this.final(h2);
            Vector a3 = this.final(w);
            Vector a4 = new LUSolver().solve(new LSProblem(a2, a3));
            return a4;
        }

        private Vector final(Vector a2) {
            int a3 = a2.size() + 1;
            DenseVector a4 = new DenseVector(a3);
            for (int a5 = 2; a5 <= a3 - 1; ++a5) {
                a4.set(a5, 3.0 * (a2.get(a5) - a2.get(a5 - 1)));
            }
            return a4;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     * Duplicate member names - consider using --renamedupmembers true
     */
    private static class Clamped
    implements EndConditions {
        private final double if;
        private final double new;

        @Override
        public Vector solveForC(Vector h2, Vector w) {
            TridiagonalMatrix a2 = this.final(h2);
            Vector a3 = this.final(w);
            Vector a4 = new ThomasAlgorithm().solve(a2, a3);
            return a4;
        }

        private Vector final(Vector a2) {
            Clamped a3;
            int a4 = a2.size() + 1;
            DenseVector a5 = new DenseVector(a4);
            a5.set(1, 3.0 * (a2.get(1) - a3.new));
            for (int a6 = 2; a6 <= a4 - 1; ++a6) {
                a5.set(a6, 3.0 * (a2.get(a6) - a2.get(a6 - 1)));
            }
            a5.set(a4, 3.0 * (a3.if - a2.get(a4 - 1)));
            return a5;
        }

        private TridiagonalMatrix final(Vector a2) {
            int a3 = a2.size() + 1;
            double[] a4 = a2.toArray();
            double[] a5 = new double[a3];
            a5[0] = 2.0 * a2.get(1);
            for (int a6 = 1; a6 < a3 - 1; ++a6) {
                a5[a6] = 2.0 * (a2.get(a6) + a2.get(a6 + 1));
            }
            a5[a3 - 1] = 2.0 * a2.get(a3 - 1);
            double[] a7 = a2.toArray();
            return new TridiagonalMatrix(new double[][]{a4, a5, a7});
        }

        private Clamped(double a2, double a3) {
            Clamped a4;
            a4.new = a2;
            a4.if = a3;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     * Duplicate member names - consider using --renamedupmembers true
     */
    private static class Natural
    implements EndConditions {
        @Override
        public Vector solveForC(Vector h2, Vector w) {
            TridiagonalMatrix a2 = this.final(h2);
            Vector a3 = this.final(w);
            Vector a4 = new ThomasAlgorithm().solve(a2, a3);
            return a4;
        }

        private Natural() {
            Natural a2;
        }

        private Vector final(Vector a2) {
            int a3 = a2.size() + 1;
            DenseVector a4 = new DenseVector(a3);
            for (int a5 = 2; a5 <= a3 - 1; ++a5) {
                a4.set(a5, 3.0 * (a2.get(a5) - a2.get(a5 - 1)));
            }
            return a4;
        }

        private TridiagonalMatrix final(Vector a2) {
            double[] a3 = a2.toArray();
            a3[0] = 0.0;
            double[] a4 = new double[a2.size() + 1];
            a4[0] = 1.0;
            for (int a5 = 1; a5 < a4.length - 1; ++a5) {
                a4[a5] = 2.0 * (a2.get(a5) + a2.get(a5 + 1));
            }
            a4[a4.length - 1] = 1.0;
            double[] a6 = a2.toArray();
            a6[a6.length - 1] = 0.0;
            return new TridiagonalMatrix(new double[][]{a3, a4, a6});
        }
    }

    private static interface EndConditions {
        public Vector solveForC(Vector var1, Vector var2);
    }
}

