/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.vector.doubles.dense;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.VectorMathOperation;
import dev.nm.analysis.function.FunctionOps;
import dev.nm.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;
import dev.nm.number.Real;
import dev.nm.number.doublearray.DoubleArrayMath;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DenseVector
implements Vector {
    private double[] void;
    private static final VectorMathOperation if;
    private final int new;

    @Override
    public DenseVector add(DenseVector that) {
        MatrixPropertyUtils.throwIfNotEqualSize(this, that);
        DenseVector a2 = new DenseVector(this.new);
        for (int a3 = 0; a3 < this.new; ++a3) {
            a2.void[a3] = this.void[a3] + that.void[a3];
        }
        return a2;
    }

    @Override
    public DenseVector add(final double scalar) {
        double[] a2 = DoubleUtils.foreach(this.void, new AbstractUnivariateRealFunction(){
            {
                1 a3;
            }

            @Override
            public double evaluate(double x) {
                return x + scalar;
            }
        });
        return new DenseVector(a2);
    }

    @Override
    public Vector multiply(Vector that) {
        if (that instanceof DenseVector) {
            return this.multiply((DenseVector)that);
        }
        return if.multiply(this, that);
    }

    public DenseVector(DenseVector vector) {
        this.new = vector.new;
        this.void = Arrays.copyOf(vector.void, this.new);
    }

    public DenseVector multiply(DenseVector that) {
        MatrixPropertyUtils.throwIfNotEqualSize(this, that);
        double[] a2 = new double[this.new];
        for (int a3 = 0; a3 < this.new; ++a3) {
            a2[a3] = this.get(a3 + 1) * that.get(a3 + 1);
        }
        return new DenseVector(a2);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Vector)) {
            return false;
        }
        Vector a2 = (Vector)obj;
        return MatrixPropertyUtils.areEqual(this, a2, 0.0);
    }

    @Override
    public DenseVector pow(final double scalar) {
        double[] a2 = DoubleUtils.foreach(this.void, new AbstractUnivariateRealFunction(){
            {
                3 a3;
            }

            @Override
            public double evaluate(double x) {
                return Math.pow(x, scalar);
            }
        });
        return new DenseVector(a2);
    }

    @Override
    public double[] toArray() {
        double[] a2 = Arrays.copyOf(this.void, this.void.length);
        return a2;
    }

    public DenseVector(Vector v) {
        this.new = v.size();
        this.void = v.toArray();
    }

    public DenseVector(Collection<? extends Number> data) {
        this.new = data.size();
        this.void = new double[this.new];
        Iterator<? extends Number> a2 = data.iterator();
        for (int a3 = 0; a3 < this.new; ++a3) {
            this.void[a3] = a2.next().doubleValue();
        }
    }

    public DenseVector(int length, double value) {
        this.new = length;
        this.void = new double[this.new];
        for (int a2 = 0; a2 < this.void.length; ++a2) {
            this.void[a2] = value;
        }
    }

    @Override
    public double get(int i2) {
        MatrixPropertyUtils.throwIfInvalidIndex(this, i2);
        return this.void[i2 - 1];
    }

    @Override
    public double angle(Vector that) {
        return if.angle(this, that);
    }

    @Override
    public DenseVector deepCopy() {
        return new DenseVector(this);
    }

    public void set(int from, DenseVector replacement) {
        if (from + replacement.new - 1 > this.new) {
            throw new IllegalArgumentException("the replacement vector length starting from 'from' exceeds the original vector length");
        }
        int a2 = from;
        for (int a3 = 1; a3 <= replacement.new; ++a3) {
            this.set(a2, replacement.get(a3));
            ++a2;
        }
    }

    public DenseVector(Matrix A2) {
        if (A2.nCols() == 1) {
            this.void = A2.getColumn(1).toArray();
            this.new = this.void.length;
            return;
        }
        if (A2.nRows() == 1) {
            this.void = A2.getRow(1).toArray();
            this.new = this.void.length;
            return;
        }
        throw new IllegalArgumentException("A must be a column or row matrix");
    }

    @Override
    public int size() {
        return this.new;
    }

    @Override
    public DenseVector scaled(double c2) {
        DenseVector a2 = new DenseVector(this.new);
        for (int a3 = 0; a3 < this.new; ++a3) {
            a2.void[a3] = this.void[a3] * c2;
        }
        return a2;
    }

    @Override
    public double norm(double p) {
        if (p == Double.POSITIVE_INFINITY) {
            return DoubleArrayMath.max(DoubleArrayMath.abs(this.toArray()));
        }
        if (p == Double.NEGATIVE_INFINITY) {
            return DoubleArrayMath.min(DoubleArrayMath.abs(this.toArray()));
        }
        ArgumentAssertion.assertNotLessThan(p, 1.0, "p");
        double a2 = 0.0;
        for (int a3 = 0; a3 < this.new; ++a3) {
            a2 += Math.pow(Math.abs(this.void[a3]), p);
        }
        a2 = Math.pow(a2, 1.0 / p);
        return a2;
    }

    @Override
    public DenseVector ZERO() {
        return new DenseVector(this.new);
    }

    @Override
    public DenseVector minus(final double scalar) {
        double[] a2 = DoubleUtils.foreach(this.void, new AbstractUnivariateRealFunction(){

            @Override
            public double evaluate(double x) {
                return x - scalar;
            }
            {
                2 a3;
            }
        });
        return new DenseVector(a2);
    }

    @Override
    public Vector add(Vector that) {
        if (that instanceof DenseVector) {
            return this.add((DenseVector)that);
        }
        return if.add((Vector)this, that);
    }

    @Override
    public double innerProduct(DenseVector that) {
        MatrixPropertyUtils.throwIfNotEqualSize(this, that);
        double a2 = FunctionOps.dotProduct(this.void, that.void);
        return a2;
    }

    @Override
    public DenseVector scaled(Real c2) {
        return this.scaled(c2.doubleValue());
    }

    public String toString() {
        StringBuilder a2 = new StringBuilder();
        a2.append("[");
        for (int a3 = 0; a3 < this.new; ++a3) {
            a2.append(String.format("%f, ", this.void[a3]));
        }
        a2.setCharAt(a2.length() - 2, ']');
        return a2.toString();
    }

    public DenseVector(Double[] data) {
        this.new = data.length;
        this.void = new double[data.length];
        for (int a2 = 0; a2 < this.void.length; ++a2) {
            this.void[a2] = data[a2];
        }
    }

    public int hashCode() {
        int a2 = 3;
        a2 = 19 * a2 + this.new;
        a2 = 19 * a2 + Arrays.hashCode(this.void);
        return a2;
    }

    public DenseVector(double ... data) {
        this.new = data.length;
        this.void = data;
    }

    @Override
    public DenseVector minus(DenseVector that) {
        MatrixPropertyUtils.throwIfNotEqualSize(this, that);
        DenseVector a2 = new DenseVector(this.new);
        for (int a3 = 0; a3 < this.new; ++a3) {
            a2.void[a3] = this.void[a3] - that.void[a3];
        }
        return a2;
    }

    @Override
    public double innerProduct(Vector that) {
        if (that instanceof DenseVector) {
            return this.innerProduct((DenseVector)that);
        }
        return if.innerProduct(this, that);
    }

    @Override
    public Vector minus(Vector that) {
        if (that instanceof DenseVector) {
            return this.minus((DenseVector)that);
        }
        return if.minus((Vector)this, that);
    }

    public DenseVector divide(DenseVector that) {
        MatrixPropertyUtils.throwIfNotEqualSize(this, that);
        double[] a2 = new double[this.new];
        for (int a3 = 0; a3 < this.new; ++a3) {
            a2[a3] = this.get(a3 + 1) / that.get(a3 + 1);
        }
        return new DenseVector(a2);
    }

    public DenseVector(List<Double> data) {
        this.new = data.size();
        this.void = new double[data.size()];
        for (int a2 = 0; a2 < this.void.length; ++a2) {
            this.void[a2] = data.get(a2);
        }
    }

    @Override
    public DenseVector opposite() {
        return this.scaled(-1.0);
    }

    @Override
    public void set(int i2, double value) {
        MatrixPropertyUtils.throwIfInvalidIndex(this, i2);
        this.void[i2 - 1] = value;
    }

    @Override
    public double norm() {
        return this.norm(2.0);
    }

    @Override
    public Vector divide(Vector that) {
        if (that instanceof DenseVector) {
            return this.divide((DenseVector)that);
        }
        return if.divide(this, that);
    }

    static {
        Package.validate("NMDEV_BASIC");
        if = new VectorMathOperation();
    }

    public DenseVector(int length) {
        this.new = length;
        this.void = new double[this.new];
    }

    public DenseVector(int[] data) {
        this.new = data.length;
        this.void = new double[data.length];
        for (int a2 = 0; a2 < data.length; ++a2) {
            this.void[a2] = data[a2];
        }
    }
}

