/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.operation;

import dev.nm.algebra.linear.matrix.MatrixAccessException;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixAccess;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.mathoperation.AutoParallelMatrixMathOperation;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.mathoperation.MatrixMathOperation;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.datastructure.DimensionCheck;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FastKroneckerProduct
implements Matrix {
    private static final MatrixMathOperation void = new AutoParallelMatrixMathOperation();
    private final Matrix if;
    private final Matrix new;

    @Override
    public Matrix scaled(double scalar) {
        return void.scaled(this, scalar);
    }

    @Override
    public double get(int i2, int j2) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, i2);
        DimensionCheck.throwIfInvalidColumn(this, j2);
        int a2 = i2 - 1;
        int a3 = j2 - 1;
        int a4 = this.new.nRows();
        int a5 = this.new.nCols();
        return this.if.get(a2 / a4 + 1, a3 / a5 + 1) * this.new.get(a2 % a4 + 1, a3 % a5 + 1);
    }

    public FastKroneckerProduct(Matrix A2, Matrix B2) {
        this.if = A2.deepCopy();
        this.new = B2.deepCopy();
    }

    @Override
    public Matrix opposite() {
        return this.scaled(-1.0);
    }

    @Override
    public DenseVector getRow(int i2) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, i2);
        double[] a2 = new double[this.nCols()];
        for (int a3 = 0; a3 < a2.length; ++a3) {
            a2[a3] = this.get(i2, a3 + 1);
        }
        return new DenseVector(a2);
    }

    @Override
    public void set(int i2, int j2, double value) throws MatrixAccessException {
        throw new MatrixAccessException("this matrix is immutable");
    }

    @Override
    public DenseMatrix ONE() {
        return new DenseMatrix(this.nRows(), this.nCols()).ONE();
    }

    @Override
    public Matrix minus(Matrix that) {
        return void.minus(this, that);
    }

    @Override
    public Matrix add(Matrix that) {
        return void.add(this, that);
    }

    @Override
    public int nRows() {
        return this.if.nRows() * this.new.nRows();
    }

    @Override
    public FastKroneckerProduct deepCopy() {
        return this;
    }

    @Override
    public Matrix t() {
        return void.transpose(this);
    }

    @Override
    public int nCols() {
        return this.if.nCols() * this.new.nCols();
    }

    @Override
    public Vector multiply(Vector v) {
        return void.multiply((MatrixAccess)this, v);
    }

    @Override
    public DenseVector getColumn(int j2) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidColumn(this, j2);
        double[] a2 = new double[this.nRows()];
        for (int a3 = 0; a3 < a2.length; ++a3) {
            a2[a3] = this.get(a3 + 1, j2);
        }
        return new DenseVector(a2);
    }

    @Override
    public DenseMatrix ZERO() {
        return new DenseMatrix(this.nRows(), this.nCols()).ZERO();
    }

    @Override
    public Matrix multiply(Matrix that) {
        return void.multiply((MatrixAccess)this, that);
    }
}

