/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse;

import dev.nm.algebra.linear.matrix.MatrixAccessException;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixAccess;
import dev.nm.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.mathoperation.AutoParallelMatrixMathOperation;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.mathoperation.MatrixMathOperation;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.MatrixCoordinate;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseMatrixUtils;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.datastructure.DimensionCheck;
import dev.nm.misc.datastructure.Table;
import dev.nm.misc.parallel.IterationBody;
import dev.nm.misc.parallel.LoopBody;
import dev.nm.misc.parallel.MultipleExecutionException;
import dev.nm.misc.parallel.ParallelExecutor;
import dev.nm.number.DoubleUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * Duplicate member names - consider using --renamedupmembers true
 */
public class CSRSparseMatrix
implements SparseMatrix {
    private final int this;
    private final int else;
    private double[] goto = null;
    private int[] try = null;
    private static final ParallelExecutor float;
    private static final MatrixMathOperation short;
    private int enum = 0;
    private static final int false = 5000;
    private static final int void = 10000;
    private static final int if = 100;
    private int[] new = null;

    public CSRSparseMatrix(int nRows, int nCols) {
        this.else = nRows;
        this.this = nCols;
        this.enum = 0;
        this.goto = new double[0];
        this.new = new int[0];
        this.try = new int[nRows + 1];
    }

    @Override
    public SparseMatrix.ValueArray getValueArray() {
        int a2 = this.nNonZeros();
        int[] a3 = new int[a2];
        int[] a4 = new int[a2];
        double[] a5 = new double[a2];
        int a6 = 0;
        for (int a7 = 1; a7 <= this.else; ++a7) {
            for (int a8 = this.try[a7 - 1]; a8 < this.try[a7]; ++a8) {
                a3[a6] = a7;
                a4[a6] = this.new[a8];
                a5[a6] = this.goto[a8];
                ++a6;
            }
        }
        return new SparseMatrix.ValueArray(a3, a4, a5);
    }

    public CSRSparseMatrix(int nRows, int nCols, List<SparseMatrix.Entry> entries) {
        this(nRows, nCols, entries, false);
    }

    private void char() {
        CSRSparseMatrix a2;
        a2.final(new CheckForKeptValue(){
            {
                6 a3;
            }

            @Override
            public boolean toKeep(double value) {
                return Double.compare(0.0, value) != 0;
            }
        });
    }

    @Override
    public SparseVector getColumn(int j2) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidColumn(this, j2);
        SparseVector a2 = new SparseVector(this.else);
        block0: for (int a3 = 1; a3 <= this.else; ++a3) {
            int a4 = this.try[a3 - 1];
            int a5 = this.try[a3];
            for (int a6 = a4; a6 < a5; ++a6) {
                if (this.new[a6] != j2) continue;
                a2.set(a3, this.goto[a6]);
                continue block0;
            }
        }
        return a2;
    }

    private Matrix final(final Matrix a2) {
        CSRSparseMatrix a3;
        DimensionCheck.throwIfIncompatible4Multiplication((Table)a3, a2);
        int a4 = a3.nRows();
        final int a5 = a2.nCols();
        final double[][] a6 = new double[a4][a5];
        ArrayList<Integer> a7 = new ArrayList<Integer>(a4);
        for (int a8 = 1; a8 <= a4; ++a8) {
            a7.add(a8);
        }
        try {
            float.conditionalForEach(a4 >= 100, a7, new IterationBody<Integer>(){
                {
                    4 a3;
                }

                @Override
                public void run(Integer i2) {
                    for (int a22 = CSRSparseMatrix.this.try[i2 - 1]; a22 < CSRSparseMatrix.this.try[i2]; ++a22) {
                        int a3 = CSRSparseMatrix.this.new[a22];
                        double a4 = CSRSparseMatrix.this.goto[a22];
                        for (int a52 = 1; a52 <= a5; ++a52) {
                            double[] dArray = a6[i2 - 1];
                            int n = a52 - 1;
                            dArray[n] = dArray[n] + a4 * a2.get(a3, a52);
                        }
                    }
                }
            });
        }
        catch (MultipleExecutionException a9) {
            throw new RuntimeException(a9);
        }
        return new DenseMatrix(a6);
    }

    private void final(CheckForKeptValue a2) {
        CSRSparseMatrix a3;
        int a4 = 0;
        for (int a5 = 0; a5 < a3.else; ++a5) {
            a3.try[a5] = a4;
            for (int a6 = a3.try[a5]; a6 < a3.try[a5 + 1]; ++a6) {
                if (!a2.toKeep(a3.goto[a6])) continue;
                a3.goto[a4] = a3.goto[a6];
                a3.new[a4] = a3.new[a6];
                ++a4;
            }
        }
        a3.try[a3.else] = a4;
        a3.goto = Arrays.copyOf(a3.goto, a4);
        a3.new = Arrays.copyOf(a3.new, a4);
        a3.enum = a4;
    }

    @Override
    public CSRSparseMatrix t() {
        return this.final();
    }

    @Override
    public Matrix add(Matrix that) {
        if (that instanceof CSRSparseMatrix) {
            return this.final((CSRSparseMatrix)that, 1.0);
        }
        return short.add(this, that);
    }

    @Override
    public int nRows() {
        return this.else;
    }

    @Override
    public CSRSparseMatrix ONE() {
        int a2 = Math.min(this.else, this.this);
        double[] a3 = DoubleUtils.rep(1.0, a2);
        int[] a4 = DoubleUtils.seq(1, a2);
        int[] a5 = DoubleUtils.seq(1, a2);
        return new CSRSparseMatrix(this.else, this.this, a4, a5, a3);
    }

    @Override
    public CSRSparseMatrix opposite() {
        return this.scaled(-1.0);
    }

    public String toString() {
        return SparseMatrixUtils.toString(this);
    }

    static {
        short = new AutoParallelMatrixMathOperation();
        float = new ParallelExecutor(CSRSparseMatrix.class.getSimpleName());
    }

    private static List<SparseMatrix.Entry> final(int[] a2, int[] a3, double[] a4) {
        ArgumentAssertion.assertTrue(a3.length == a4.length && a2.length == a4.length, "input arrays size mismatch", new Object[0]);
        int a5 = a4.length;
        ArrayList<SparseMatrix.Entry> a6 = new ArrayList<SparseMatrix.Entry>(a5);
        for (int a7 = 0; a7 < a5; ++a7) {
            a6.add(new SparseMatrix.Entry(new MatrixCoordinate(a2[a7], a3[a7]), a4[a7]));
        }
        return a6;
    }

    private CSRSparseMatrix final(SparseMatrix a2) {
        CSRSparseMatrix a3;
        return a3.final(new CSRSparseMatrix(a2.nRows(), a2.nCols(), a2.getEntryList()));
    }

    private CSRSparseMatrix final(final CSRSparseMatrix a2) {
        int a3;
        int a4;
        CSRSparseMatrix a5;
        DimensionCheck.throwIfIncompatible4Multiplication((Table)a5, a2);
        final int a6 = a2.this;
        final Row[] a7 = new Row[a5.else];
        LoopBody a8 = new LoopBody(){

            @Override
            public void run(int i2) throws Exception {
                Scatter a22 = new Scatter(a6);
                for (int a3 = CSRSparseMatrix.this.try[i2 - 1]; a3 < CSRSparseMatrix.this.try[i2]; ++a3) {
                    a22.final(a2, CSRSparseMatrix.this.new[a3], CSRSparseMatrix.this.goto[a3]);
                }
                a7[i2 - 1] = a22.final();
            }
            {
                3 a3;
            }
        };
        try {
            float.conditionalForLoop(a5.final(a2), 1, a5.else + 1, a8);
        }
        catch (MultipleExecutionException a9) {
            try {
                for (a4 = 1; a4 <= a5.else; ++a4) {
                    a8.run(a4);
                }
            }
            catch (Exception a10) {
                throw new RuntimeException("CSRSparseMatrix multiply failed", a10);
            }
        }
        CSRSparseMatrix a11 = new CSRSparseMatrix(a5.else, a2.this);
        a4 = 0;
        for (a3 = 0; a3 < a5.else; ++a3) {
            a11.try[a3] = a4;
            a4 += a7[a3].void;
        }
        a11.try[a5.else] = a4;
        a11.enum = a4;
        a11.goto = new double[a4];
        a11.new = new int[a4];
        int a12 = 0;
        for (a3 = 0; a3 < a5.else; ++a3) {
            a12 += a7[a3].final(a11.new, a11.goto, a12);
        }
        return a11;
    }

    @Override
    public Matrix multiply(Matrix that) {
        if (that instanceof CSRSparseMatrix) {
            return this.final((CSRSparseMatrix)that);
        }
        if (that instanceof SparseMatrix) {
            return this.final((SparseMatrix)that);
        }
        return this.final(that);
    }

    @Override
    public CSRSparseMatrix deepCopy() {
        return new CSRSparseMatrix(this);
    }

    private void final() {
        CSRSparseMatrix a2;
        if (a2.enum == 0) {
            return;
        }
        try {
            float.conditionalForLoop(a2.enum >= 5000, 1, a2.else + 1, new LoopBody(){
                {
                    2 a3;
                }

                @Override
                public void run(int i2) throws Exception {
                    int a2 = CSRSparseMatrix.this.try[i2 - 1];
                    int a3 = CSRSparseMatrix.this.try[i2];
                    CSRSparseMatrix.final(CSRSparseMatrix.this.new, CSRSparseMatrix.this.goto, a2, a3);
                }
            });
        }
        catch (MultipleExecutionException a3) {
            throw new RuntimeException(a3);
        }
    }

    private static int final(int[] a2, double[] a3) {
        int a4 = 0;
        for (int a5 = 0; a5 < a3.length; ++a5) {
            if (Double.compare(0.0, a3[a5]) == 0) continue;
            if (a4 != a5) {
                a3[a4] = a3[a5];
                a2[a4] = a2[a5];
            }
            ++a4;
        }
        return a4;
    }

    public CSRSparseMatrix(Matrix A2) {
        this(A2.nRows(), A2.nCols(), CSRSparseMatrix.final(A2));
    }

    public int hashCode() {
        int a2 = 5;
        a2 = 47 * a2 + Arrays.hashCode(this.try);
        a2 = 47 * a2 + Arrays.hashCode(this.new);
        a2 = 47 * a2 + Arrays.hashCode(this.goto);
        a2 = 47 * a2 + this.else;
        a2 = 47 * a2 + this.this;
        return a2;
    }

    public CSRSparseMatrix(CSRSparseMatrix that) {
        this.else = that.nRows();
        this.this = that.nCols();
        this.enum = that.enum;
        this.goto = (double[])that.goto.clone();
        this.new = (int[])that.new.clone();
        this.try = (int[])that.try.clone();
    }

    private static List<SparseMatrix.Entry> final(Matrix a2) {
        if (a2 instanceof SparseMatrix) {
            return ((SparseMatrix)a2).getEntryList();
        }
        ArrayList<SparseMatrix.Entry> a3 = new ArrayList<SparseMatrix.Entry>();
        for (int a4 = 1; a4 <= a2.nRows(); ++a4) {
            for (int a5 = 1; a5 <= a2.nCols(); ++a5) {
                double a6 = a2.get(a4, a5);
                if (a6 == 0.0) continue;
                a3.add(new SparseMatrix.Entry(new MatrixCoordinate(a4, a5), a6));
            }
        }
        return a3;
    }

    private CSRSparseMatrix final(final CSRSparseMatrix a2, final double a3) {
        int a4;
        int a5;
        CSRSparseMatrix a6;
        DimensionCheck.throwIfDifferentDimension(a6, a2);
        final Row[] a7 = new Row[a6.else];
        LoopBody a8 = new LoopBody(){
            {
                1 a32;
            }

            @Override
            public void run(int i2) throws Exception {
                Scatter a22 = new Scatter(CSRSparseMatrix.this.this);
                a22.final(CSRSparseMatrix.this, i2, 1.0);
                a22.final(a2, i2, a3);
                a7[i2 - 1] = a22.final();
            }
        };
        try {
            float.conditionalForLoop(a6.final(a2), 1, a6.else + 1, a8);
        }
        catch (MultipleExecutionException a9) {
            for (a5 = 1; a5 <= a6.else; ++a5) {
                try {
                    a8.run(a5);
                    continue;
                }
                catch (Exception a10) {
                    throw new RuntimeException("CSRSparseMatrix add failed", a10);
                }
            }
        }
        CSRSparseMatrix a11 = new CSRSparseMatrix(a6.else, a6.this);
        a5 = 0;
        for (a4 = 0; a4 < a6.else; ++a4) {
            a11.try[a4] = a5;
            a5 += a7[a4].void;
        }
        a11.try[a6.else] = a5;
        a11.enum = a5;
        a11.goto = new double[a5];
        a11.new = new int[a5];
        for (a4 = 0; a4 < a6.else; ++a4) {
            a7[a4].final(a11.new, a11.goto, a11.try[a4]);
        }
        return a11;
    }

    private boolean final(CSRSparseMatrix a2) {
        CSRSparseMatrix a3;
        return a3.enum + a2.enum > 10000;
    }

    public CSRSparseMatrix(int nRows, int nCols, int[] rowIndices, int[] columnIndices, double[] values) {
        ArgumentAssertion.assertTrue(columnIndices.length == values.length && rowIndices.length == values.length, "input arrays size mismatch", new Object[0]);
        this.else = nRows;
        this.this = nCols;
        this.try = new int[nRows + 1];
        for (int a2 = 0; a2 < rowIndices.length; ++a2) {
            int n = rowIndices[a2];
            this.try[n] = this.try[n] + 1;
        }
        this.try = DoubleUtils.cumsum(this.try);
        this.enum = values.length;
        this.new = new int[this.enum];
        this.goto = new double[this.enum];
        int[] a3 = (int[])this.try.clone();
        for (int a4 = 0; a4 < this.enum; ++a4) {
            int a5 = rowIndices[a4];
            int a6 = a3[a5 - 1];
            this.new[a6] = columnIndices[a4];
            this.goto[a6] = values[a4];
            int n = a5 - 1;
            a3[n] = a3[n] + 1;
        }
        this.final();
    }

    public CSRSparseMatrix(int nRows, int nCols, List<SparseMatrix.Entry> entries, boolean areEntriesSorted) {
        this(nRows, nCols);
        this.try = !areEntriesSorted ? SparseMatrixUtils.sortInRowColumnOrder(entries, nRows, nCols, true, true) : DoubleUtils.cumsum(SparseMatrixUtils.countEntriesInEachRow(entries, nRows));
        this.enum = entries.size();
        this.goto = new double[this.enum];
        this.new = new int[this.enum];
        int a2 = 0;
        for (SparseMatrix.Entry a3 : entries) {
            this.goto[a2] = a3.value;
            this.new[a2] = a3.coordinates.j;
            ++a2;
        }
    }

    @Override
    public double get(int i2, int j2) {
        DimensionCheck.throwIfInvalidRow(this, i2);
        DimensionCheck.throwIfInvalidColumn(this, j2);
        int a2 = this.try[i2 - 1];
        int a3 = this.try[i2];
        int a4 = 0;
        for (a4 = a2; a4 < a3 && this.new[a4] != j2; ++a4) {
        }
        return a4 == a3 ? 0.0 : this.goto[a4];
    }

    @Override
    public DenseMatrix toDense() {
        DenseMatrix a2 = new DenseMatrix(this.else, this.this);
        for (int a3 = 1; a3 <= this.else; ++a3) {
            for (int a4 = this.try[a3 - 1]; a4 < this.try[a3]; ++a4) {
                a2.set(a3, this.new[a4], this.goto[a4]);
            }
        }
        return a2;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!MatrixAccess.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        if (!SparseMatrix.class.isAssignableFrom(obj.getClass())) {
            return MatrixPropertyUtils.areEqual(this, (Matrix)obj, 0.0);
        }
        CSRSparseMatrix a2 = (CSRSparseMatrix)obj;
        if (this.else != a2.else) {
            return false;
        }
        if (this.this != a2.this) {
            return false;
        }
        return SparseMatrixUtils.equals(this, a2);
    }

    @Override
    public int nNonZeros() {
        return this.enum;
    }

    @Override
    public void set(int row, int col, double value) {
        DimensionCheck.throwIfInvalidRow(this, row);
        DimensionCheck.throwIfInvalidColumn(this, col);
        int a2 = this.try[row - 1];
        int a3 = this.try[row];
        int a4 = 0;
        for (a4 = a2; a4 < a3 && this.new[a4] < col; ++a4) {
        }
        if (a4 != a3 && this.new[a4] == col) {
            if (value != 0.0) {
                this.goto[a4] = value;
            } else {
                double[] a5 = this.goto;
                this.goto = new double[a5.length - 1];
                System.arraycopy(a5, 0, this.goto, 0, a4);
                System.arraycopy(a5, a4 + 1, this.goto, a4, this.goto.length - a4);
                int[] a6 = this.new;
                this.new = new int[a6.length - 1];
                System.arraycopy(a6, 0, this.new, 0, a4);
                System.arraycopy(a6, a4 + 1, this.new, a4, this.new.length - a4);
                int a7 = row;
                while (a7 < this.try.length) {
                    int n = a7++;
                    this.try[n] = this.try[n] - 1;
                }
                --this.enum;
            }
        } else {
            if (value == 0.0) {
                return;
            }
            double[] a8 = this.goto;
            this.goto = new double[a8.length + 1];
            System.arraycopy(a8, 0, this.goto, 0, a4);
            System.arraycopy(a8, a4, this.goto, a4 + 1, a8.length - a4);
            this.goto[a4] = value;
            int[] a9 = this.new;
            this.new = new int[a9.length + 1];
            System.arraycopy(a9, 0, this.new, 0, a4);
            System.arraycopy(a9, a4, this.new, a4 + 1, a9.length - a4);
            this.new[a4] = col;
            int a10 = row;
            while (a10 < this.try.length) {
                int n = a10++;
                this.try[n] = this.try[n] + 1;
            }
            ++this.enum;
        }
    }

    @Override
    public Vector multiply(final Vector v) {
        DimensionCheck.throwIfIncompatible4Multiplication((Table)this, v);
        if (v instanceof SparseVector) {
            return ((SparseVector)v).leftMultiply(this);
        }
        final double[] a2 = new double[this.else];
        try {
            float.conditionalForLoop(this.else >= 100, 1, this.else + 1, new LoopBody(){

                @Override
                public void run(int i2) throws Exception {
                    a2[i2 - 1] = ((SparseVector)CSRSparseMatrix.this.getRow(i2)).innerProduct(v);
                }
                {
                    5 a3;
                }
            });
        }
        catch (MultipleExecutionException a3) {
            for (int a4 = 1; a4 <= this.else; ++a4) {
                a2[a4 - 1] = ((SparseVector)this.getRow(a4)).innerProduct(v);
            }
        }
        Vector a5 = v instanceof SparseVector ? new SparseVector(a2) : new DenseVector(a2);
        return a5;
    }

    @Override
    public List<SparseMatrix.Entry> getEntryList() {
        ArrayList<SparseMatrix.Entry> a2 = new ArrayList<SparseMatrix.Entry>(this.nNonZeros());
        for (int a3 = 1; a3 <= this.else; ++a3) {
            for (int a4 = this.try[a3 - 1]; a4 < this.try[a3]; ++a4) {
                a2.add(new SparseMatrix.Entry(new MatrixCoordinate(a3, this.new[a4]), this.goto[a4]));
            }
        }
        return a2;
    }

    @Override
    public int nCols() {
        return this.this;
    }

    @Override
    public SparseVector getRow(int i2) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, i2);
        int a2 = this.try[i2 - 1];
        int a3 = this.try[i2];
        LinkedList<SparseVector.Entry> a4 = new LinkedList<SparseVector.Entry>();
        for (int a5 = a2; a5 < a3; ++a5) {
            SparseVector.Entry a6 = new SparseVector.Entry(this.new[a5], this.goto[a5]);
            a4.add(a6);
        }
        SparseVector a7 = new SparseVector(this.this, a4, true);
        return a7;
    }

    @Override
    public CSRSparseMatrix scaled(double c2) {
        if (Double.compare(0.0, c2) == 0) {
            return new CSRSparseMatrix(this.else, this.this);
        }
        CSRSparseMatrix a2 = new CSRSparseMatrix(this);
        int a3 = 0;
        while (a3 < a2.goto.length) {
            int n = a3++;
            a2.goto[n] = a2.goto[n] * c2;
        }
        return a2;
    }

    @Override
    public CSRSparseMatrix ZERO() {
        return new CSRSparseMatrix(this.else, this.this);
    }

    private CSRSparseMatrix final() {
        int a2;
        CSRSparseMatrix a3;
        CSRSparseMatrix a4 = new CSRSparseMatrix(a3.this, a3.else);
        double[] a5 = new double[a3.goto.length];
        int[] a6 = new int[a3.new.length];
        int[] a7 = new int[a3.this + 1];
        for (a2 = 0; a2 < a3.new.length; ++a2) {
            int n = a3.new[a2];
            a7[n] = a7[n] + 1;
        }
        a7 = DoubleUtils.cumsum(a7);
        a4.try = (int[])a7.clone();
        for (a2 = 1; a2 <= a3.else; ++a2) {
            for (int a8 = a3.try[a2 - 1]; a8 < a3.try[a2]; ++a8) {
                int n = a3.new[a8] - 1;
                a7[n] = a7[n] + 1;
                a6[a] = a2;
                a5[a] = a3.goto[a8];
            }
        }
        a4.goto = a5;
        a4.new = a6;
        a4.enum = a3.enum;
        return a4;
    }

    private static void final(int[] a2, double[] a3, int a4, int a5) {
        Object[] a6 = new IndexedValue[a5 - a4];
        int a7 = a4;
        int a8 = 0;
        while (a7 < a5) {
            a6[a8] = new IndexedValue(a2[a7], a3[a7]);
            ++a7;
            ++a8;
        }
        Arrays.sort(a6);
        a7 = a4;
        a8 = 0;
        while (a7 < a5) {
            a2[a7] = ((IndexedValue)a6[a8]).if;
            a3[a7] = ((IndexedValue)a6[a8]).new;
            ++a7;
            ++a8;
        }
    }

    @Override
    public Matrix minus(Matrix that) {
        if (that instanceof CSRSparseMatrix) {
            return this.final((CSRSparseMatrix)that, -1.0);
        }
        return short.minus(this, that);
    }

    private static interface CheckForKeptValue {
        public boolean toKeep(double var1);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class Row {
        private final int void;
        private final int[] if;
        private final double[] new;

        private int final(int[] a2, double[] a3, int a4) {
            Row a5;
            System.arraycopy(a5.if, 0, a2, a4, a5.void);
            System.arraycopy(a5.new, 0, a3, a4, a5.void);
            return a5.void;
        }

        private Row(int[] a2, double[] a3, int a4) {
            Row a5;
            a5.if = a2;
            a5.new = a3;
            a5.void = a4;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class Scatter {
        private final int[] false;
        private final double[] void;
        private int if;
        private final boolean[] new;

        private Scatter(int a2) {
            Scatter a3;
            a3.new = new boolean[a2 + 1];
            a3.void = new double[a2 + 1];
            a3.false = new int[a2];
            a3.if = 0;
        }

        private void final(CSRSparseMatrix a2, int a3, double a4) {
            int a5 = a2.try[a3 - 1];
            int a6 = a2.try[a3];
            for (int a7 = a5; a7 < a6; ++a7) {
                Scatter a8;
                int a9 = a2.new[a7];
                if (!a8.new[a9]) {
                    a8.new[a9] = true;
                    a8.false[a8.if++] = a9;
                }
                int n = a9;
                a8.void[n] = a8.void[n] + a4 * a2.goto[a7];
            }
        }

        private Row final() {
            int a2;
            Scatter a3;
            int[] a4 = Arrays.copyOf(a3.false, a3.if);
            double[] a5 = new double[a3.if];
            for (a2 = 0; a2 < a3.if; ++a2) {
                a5[a2] = a3.void[a3.false[a2]];
            }
            a2 = CSRSparseMatrix.final(a4, a5);
            if (a3.if != a2) {
                a4 = Arrays.copyOf(a4, a2);
                a5 = Arrays.copyOf(a5, a2);
            }
            CSRSparseMatrix.final(a4, a5, 0, a2);
            return new Row(a4, a5, a2);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class IndexedValue
    implements Comparable<IndexedValue> {
        private final int if;
        private final double new;

        @Override
        public int compareTo(IndexedValue o) {
            return this.if - o.if;
        }

        private IndexedValue(int a2, double a3) {
            IndexedValue a4;
            a4.if = a2;
            a4.new = a3;
        }
    }
}

