/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.matrixtype;

import dev.nm.algebra.linear.matrix.MatrixAccessException;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixAccess;
import dev.nm.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixFactory;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.datastructure.DimensionCheck;
import dev.nm.misc.datastructure.Table;
import dev.nm.misc.license.Package;
import dev.nm.misc.parallel.LoopBody;
import dev.nm.misc.parallel.MultipleExecutionException;
import dev.nm.misc.parallel.ParallelExecutor;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PermutationMatrix
implements Matrix {
    private static final int false = 1000;
    private int void = 1;
    private int[] if;
    private final int new;

    public double sign() {
        return Math.signum(this.void);
    }

    @Override
    public int nCols() {
        return this.new;
    }

    public void moveRow2End(int i2) {
        DimensionCheck.throwIfInvalidRow(this, i2);
        int a2 = this.if[i2];
        for (int a3 = i2; a3 < this.nRows(); ++a3) {
            this.if[a3] = this.if[a3 + 1];
        }
        this.if[this.nRows()] = a2;
    }

    public String toString() {
        return new DenseMatrix(this).toString();
    }

    @Override
    public Vector getRow(int i2) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, i2);
        DenseVector a2 = new DenseVector(this.new);
        a2.set(this.if[i2], 1.0);
        return a2;
    }

    @Override
    public Vector multiply(Vector v) {
        double[] a2 = new double[v.size()];
        for (int a3 = 0; a3 < a2.length; ++a3) {
            a2[a3] = v.get(this.if[a3 + 1]);
        }
        DenseVector a4 = new DenseVector(a2);
        return a4;
    }

    @Override
    public Matrix add(Matrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        DenseMatrix a2 = new DenseMatrix(that);
        for (int a3 = 1; a3 < this.if.length; ++a3) {
            a2.set(a3, this.if[a3], 1.0 + a2.get(a3, this.if[a3]));
        }
        return a2;
    }

    @Override
    public PermutationMatrix deepCopy() {
        return new PermutationMatrix(this);
    }

    @Override
    public PermutationMatrix ONE() {
        return new PermutationMatrix(this.new);
    }

    public PermutationMatrix(PermutationMatrix P) {
        this.new = P.new;
        this.if = Arrays.copyOf(P.if, P.if.length);
        this.void = P.void;
    }

    @Override
    public double get(int i2, int j2) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, i2);
        DimensionCheck.throwIfInvalidColumn(this, i2);
        double a2 = 0.0;
        if (this.if[i2] == j2) {
            a2 = 1.0;
        }
        return a2;
    }

    @Override
    public Vector getColumn(int j2) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidColumn(this, j2);
        DenseVector a2 = new DenseVector(this.new);
        for (int a3 = 1; a3 <= this.new; ++a3) {
            if (this.if[a3] != j2) continue;
            a2.set(a3, 1.0);
            break;
        }
        return a2;
    }

    public PermutationMatrix(int dim) {
        this.new = dim;
        this.if = new int[dim + 1];
        for (int a2 = 0; a2 <= dim; ++a2) {
            this.if[a2] = a2;
        }
    }

    @Override
    public Matrix scaled(double scalar) {
        DenseMatrix a2 = new DenseMatrix(this.new, this.new);
        for (int a3 = 1; a3 < this.if.length; ++a3) {
            a2.set(a3, this.if[a3], scalar);
        }
        return a2;
    }

    public int hashCode() {
        int a2 = 5;
        a2 = 59 * a2 + this.new;
        a2 = 59 * a2 + (this.if != null ? this.if.hashCode() : 0);
        return a2;
    }

    @Override
    public int nRows() {
        return this.new;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!MatrixAccess.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        if (!PermutationMatrix.class.isAssignableFrom(obj.getClass())) {
            return MatrixPropertyUtils.areEqual(this, (Matrix)obj, 0.0);
        }
        PermutationMatrix a2 = (PermutationMatrix)obj;
        if (this.new != a2.new) {
            return false;
        }
        return this.if == a2.if || this.if != null && Arrays.equals(this.if, a2.if);
    }

    @Override
    public PermutationMatrix t() {
        PermutationMatrix a2 = new PermutationMatrix(this.new);
        for (int a3 = 1; a3 <= this.new; ++a3) {
            a2.if[this.if[a3]] = a3;
        }
        return a2;
    }

    public PermutationMatrix(int[] data) {
        int a2;
        int a3;
        this.new = data.length;
        this.if = new int[this.new + 1];
        boolean[] a4 = new boolean[this.new + 1];
        for (a3 = 1; a3 <= this.new; ++a3) {
            this.if[a3] = a2 = data[a3 - 1];
            a4[a2] = true;
        }
        a3 = 1;
        for (a2 = 1; a2 <= this.new; ++a2) {
            a3 &= a4[a2];
        }
        if (a3 == 0) {
            throw new IllegalArgumentException("data is not a permutation matrix");
        }
    }

    static {
        Package.validate("NMDEV_BASIC");
    }

    public void swapRow(int i1, int i2) {
        DimensionCheck.throwIfInvalidRow(this, i1);
        DimensionCheck.throwIfInvalidRow(this, i2);
        int a2 = this.if[i1];
        this.if[i1] = this.if[i2];
        this.if[i2] = a2;
        this.void *= -1;
    }

    public Matrix rightMultiply(final Matrix A2) {
        DimensionCheck.throwIfIncompatible4Multiplication((Table)A2, this);
        int a2 = A2.nCols();
        final Vector[] a3 = new Vector[a2];
        try {
            ParallelExecutor.getSharedInstance().conditionalForLoop(a2 >= 1000, 1, a2 + 1, new LoopBody(){

                @Override
                public void run(int i2) throws Exception {
                    a3[((PermutationMatrix)PermutationMatrix.this).if[i2] - 1] = A2.getColumn(i2);
                }
                {
                    1 a32;
                }
            });
        }
        catch (MultipleExecutionException a4) {
            for (int a5 = 1; a5 <= a2; ++a5) {
                a3[this.if[a5] - 1] = A2.getColumn(a5);
            }
        }
        Matrix a6 = MatrixFactory.cbind(a3);
        return a6;
    }

    public void moveColumn2End(int j2) {
        DimensionCheck.throwIfInvalidColumn(this, j2);
        for (int a2 = 1; a2 <= this.nRows(); ++a2) {
            if (this.if[a2] == j2) {
                this.if[a2] = this.nCols();
                continue;
            }
            if (this.if[a2] <= j2) continue;
            int n = a2;
            this.if[n] = this.if[n] - 1;
        }
    }

    @Override
    public Matrix multiply(final Matrix A2) {
        DimensionCheck.throwIfIncompatible4Multiplication((Table)this, A2);
        int a2 = A2.nRows();
        final Vector[] a3 = new Vector[a2];
        try {
            ParallelExecutor.getSharedInstance().conditionalForLoop(a2 >= 1000, 1, a2 + 1, new LoopBody(){
                {
                    2 a32;
                }

                @Override
                public void run(int i2) throws Exception {
                    a3[i2 - 1] = A2.getRow(PermutationMatrix.this.if[i2]);
                }
            });
        }
        catch (MultipleExecutionException a4) {
            for (int a5 = 1; a5 <= a2; ++a5) {
                a3[a5 - 1] = A2.getRow(this.if[a5]);
            }
        }
        Matrix a6 = MatrixFactory.rbind(a3);
        return a6;
    }

    @Override
    public Matrix opposite() {
        return this.scaled(-1.0);
    }

    @Override
    public Matrix minus(Matrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        DenseMatrix a2 = new DenseMatrix(that);
        for (int a3 = 1; a3 < this.if.length; ++a3) {
            a2.set(a3, this.if[a3], 1.0 - a2.get(a3, this.if[a3]));
        }
        return a2;
    }

    @Override
    @Deprecated
    public void set(int i2, int j2, double value) throws MatrixAccessException {
        throw new UnsupportedOperationException("Please use swapRow or swapColumn instead.");
    }

    @Override
    public Matrix ZERO() {
        throw new UnsupportedOperationException("permutation matrix cannot be zero");
    }

    public void swapColumn(int j1, int j2) {
        DimensionCheck.throwIfInvalidColumn(this, j1);
        DimensionCheck.throwIfInvalidColumn(this, j2);
        for (int a2 = 1; a2 <= this.new; ++a2) {
            if (this.if[a2] == j1) {
                this.if[a2] = j2;
                continue;
            }
            if (this.if[a2] != j2) continue;
            this.if[a2] = j1;
        }
        this.void *= -1;
    }
}

