/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.factorization.svd;

import dev.nm.algebra.linear.matrix.doubles.ImmutableMatrix;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.qr.SymmetricQRAlgorithm;
import dev.nm.algebra.linear.matrix.doubles.factorization.svd.SVDDecomposition;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixFactory;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.PrecisionUtils;
import dev.nm.misc.datastructure.DimensionCheck;
import dev.nm.number.DoubleUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SymmetricSVD
implements SVDDecomposition {
    private final double[] false;
    private final ImmutableMatrix void;
    private final DiagonalMatrix if;
    private final ImmutableMatrix new;

    private static SortedUV final(Matrix a2, Matrix a3, double[] a4) {
        Object a5;
        int a6 = a2.nCols();
        ArrayList<UVEigen> a7 = new ArrayList<UVEigen>(a6);
        for (int a8 = 1; a8 <= a6; ++a8) {
            a7.add(new UVEigen(a2.getColumn(a8), a3.getColumn(a8), Math.abs(a4[a8 - 1])));
        }
        Collections.sort(a7);
        ArrayList<Vector> a9 = new ArrayList<Vector>(a6);
        ArrayList<Vector> a10 = new ArrayList<Vector>(a6);
        double[] a11 = new double[a6];
        for (int a12 = 0; a12 < a6; ++a12) {
            a5 = (UVEigen)a7.get(a12);
            a9.add(((UVEigen)a5).new);
            a10.add(((UVEigen)a5).void);
            a11[a12] = ((UVEigen)a5).if;
        }
        Matrix a13 = MatrixFactory.cbind(a9);
        a5 = MatrixFactory.cbind(a10);
        return new SortedUV(a13, (Matrix)a5, a11);
    }

    @Override
    public double[] getSingularValues() {
        return (double[])this.false.clone();
    }

    @Override
    public ImmutableMatrix Ut() {
        return new ImmutableMatrix(this.void.t());
    }

    public SymmetricSVD(Matrix A2) {
        this(A2, PrecisionUtils.autoEpsilon(A2));
    }

    public SymmetricSVD(Matrix A2, double epsilon) {
        ArgumentAssertion.assertTrue(DimensionCheck.isSquare(A2), "symmetric SVD algorithm applies only to square matrix", new Object[0]);
        ArgumentAssertion.assertTrue(MatrixPropertyUtils.isSymmetric(A2, epsilon), "symmetric SVD algorithm applies only to symmetric matrix", new Object[0]);
        SymmetricQRAlgorithm a2 = new SymmetricQRAlgorithm(A2, epsilon);
        List<Double> a3 = a2.getEigenvalues();
        double[] a4 = DoubleUtils.collection2DoubleArray(a3);
        Matrix a5 = a2.Q();
        Matrix a6 = a5.deepCopy();
        for (int a7 = 0; a7 < a4.length; ++a7) {
            if (!(a4[a7] < 0.0)) continue;
            int n = a7;
            a4[n] = a4[n] * -1.0;
            SymmetricSVD.final(a6, a7 + 1);
        }
        SortedUV a8 = SymmetricSVD.final(a5, a6, a4);
        this.void = new ImmutableMatrix(a8.getU());
        this.new = new ImmutableMatrix(a8.getV());
        this.false = a8.getEigen();
        this.if = new DiagonalMatrix(this.false);
    }

    private static void final(Matrix a2, int a3) {
        for (int a4 = 1; a4 <= a2.nRows(); ++a4) {
            a2.set(a4, a3, -a2.get(a4, a3));
        }
    }

    @Override
    public ImmutableMatrix U() {
        return this.void;
    }

    @Override
    public DiagonalMatrix D() {
        return this.if;
    }

    @Override
    public ImmutableMatrix V() {
        return this.new;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class UVEigen
    implements Comparable<UVEigen> {
        private final Vector void;
        private final double if;
        private final Vector new;

        @Override
        public int compareTo(UVEigen that) {
            return -DoubleUtils.compare(this.if, that.if, 0.0);
        }

        private UVEigen(Vector a2, Vector a3, double a4) {
            UVEigen a5;
            a5.new = a2;
            a5.void = a3;
            a5.if = a4;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class SortedUV {
        private final Matrix void;
        private final double[] if;
        private final Matrix new;

        public double[] getEigen() {
            return this.if;
        }

        private SortedUV(Matrix a2, Matrix a3, double[] a4) {
            SortedUV a5;
            a5.new = a2;
            a5.void = a3;
            a5.if = a4;
        }

        public Matrix getV() {
            return this.void;
        }

        public Matrix getU() {
            return this.new;
        }
    }
}

