/*
 * Decompiled with CFR 0.152.
 */
package tech.nmfin.portfoliooptimization.markowitz;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.vector.doubles.Vector;
import tech.nmfin.portfoliooptimization.clm.MCLNiedermayer;
import tech.nmfin.portfoliooptimization.clm.MarkowitzCriticalLine;
import tech.nmfin.portfoliooptimization.markowitz.MarkowitzByQP;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MarkowitzByCLM
extends MarkowitzByQP {
    private final MarkowitzCriticalLine new;

    public MarkowitzByCLM(Vector r, Matrix V, Vector w_lower, Vector w_upper, double benchmarkRate) {
        super(r, V, w_lower, w_upper, benchmarkRate);
        this.new = new MCLNiedermayer(r, V, w_lower, w_upper);
    }

    public MarkowitzByCLM(Vector r, Matrix V, Vector w_lower, Vector w_upper) {
        this(r, V, w_lower, w_upper, 0.0);
    }

    @Override
    protected Vector getOptimalW(double q) throws Exception {
        try {
            double a2 = 1.0 / (2.0 * q);
            return this.new.getOptimalWeightForSetLambda(a2);
        }
        catch (Exception a3) {
            return super.getOptimalW(q);
        }
    }

    public MarkowitzByCLM(Vector r, Matrix V) {
        super(r, V);
        this.new = new MCLNiedermayer(r, V);
    }
}

