/*
 * Decompiled with CFR 0.152.
 */
package tech.nmfin.meanreversion.cointegration;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.triangle.SymmetricMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixFactory;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.PrecisionUtils;
import dev.nm.stat.descriptive.covariance.SampleCovariance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tech.nmfin.meanreversion.daspremont2008.CovarianceEstimation;
import tech.nmfin.meanreversion.daspremont2008.IndependentCoVAR;

public class PairingModelUtils {
    public static List<List<Integer>> findClusters(Matrix R, double covPenalty) {
        SampleCovariance a2 = new SampleCovariance(R);
        CovarianceEstimation a3 = new CovarianceEstimation(a2, covPenalty);
        SymmetricMatrix a4 = a3.inverseCovariance();
        double a5 = PrecisionUtils.autoEpsilon(a4);
        IndependentCoVAR a6 = new IndependentCoVAR(a4, a5);
        return a6.groups();
    }

    public static List<Integer[]> getPossiblePairs(int N) {
        ArrayList<Integer[]> a2 = new ArrayList<Integer[]>();
        for (int a3 = 0; a3 < N; ++a3) {
            for (int a4 = a3 + 1; a4 < N; ++a4) {
                a2.add(new Integer[]{a3, a4});
            }
        }
        return a2;
    }

    public static List<Integer[]> getPossiblePairs(List<String> allSymbols, List<String> tradableSymbols) {
        ArrayList<Integer> a4 = new ArrayList<Integer>();
        for (String string : tradableSymbols) {
            int a2 = allSymbols.indexOf(string);
            if (a2 <= -1) continue;
            a4.add(a2);
        }
        int a5 = a4.size();
        ArrayList<Integer[]> arrayList = new ArrayList<Integer[]>();
        for (int a2 = 0; a2 < a5; ++a2) {
            for (int a6 = a2 + 1; a6 < a5; ++a6) {
                int a7 = (Integer)a4.get(a2);
                int a8 = (Integer)a4.get(a6);
                arrayList.add(new Integer[]{a7, a8});
            }
        }
        return arrayList;
    }

    public static Map<Integer, Integer> mapClusterIndices(List<List<Integer>> clusters) {
        HashMap<Integer, Integer> a2 = new HashMap<Integer, Integer>();
        for (int a3 = 0; a3 < clusters.size(); ++a3) {
            List<Integer> a4 = clusters.get(a3);
            for (int a5 = 0; a5 < a4.size(); ++a5) {
                a2.put(a4.get(a5), a3);
            }
        }
        return a2;
    }

    public static Matrix getPriceMatrix(Vector p1, Vector p2) {
        Matrix a2 = MatrixFactory.cbind(p1, p2);
        return a2;
    }

    public static Matrix getTailedMatrix(Matrix A2, double tailed) {
        int a2 = A2.nRows();
        Matrix a3 = MatrixFactory.rows(A2, Math.max(1, (int)((double)a2 * (1.0 - tailed))), a2);
        return a3;
    }

    public static Map<Integer, Integer> getClusters(Matrix returns, double covPenalty) {
        return PairingModelUtils.mapClusterIndices(PairingModelUtils.findClusters(returns, covPenalty));
    }
}

