/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import java.io.Serializable;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DurationField;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.field.FieldUtils;

public abstract class AbstractReadableInstantFieldProperty
implements Serializable {
    private static final long serialVersionUID = 1971226328211649661L;

    public String getAsShortText() {
        return this.getAsShortText(null);
    }

    public long getDifferenceAsLong(ReadableInstant arg0) {
        if (arg0 == null) {
            return this.getField().getDifferenceAsLong(this.getMillis(), DateTimeUtils.currentTimeMillis());
        }
        return this.getField().getDifferenceAsLong(this.getMillis(), arg0.getMillis());
    }

    public int getMinimumValue() {
        return this.getField().getMinimumValue(this.getMillis());
    }

    public DateTimeFieldType getFieldType() {
        return this.getField().getType();
    }

    protected Chronology getChronology() {
        throw new UnsupportedOperationException("The method getChronology() was added in v1.4 and needs to be implemented by subclasses of AbstractReadableInstantFieldProperty");
    }

    public String getAsText() {
        return this.getAsText(null);
    }

    public int compareTo(ReadablePartial arg0) {
        int n;
        if (arg0 == null) {
            throw new IllegalArgumentException("The partial must not be null");
        }
        int n2 = this.get();
        if (n2 < (n = arg0.get(this.getFieldType()))) {
            return -1;
        }
        if (n2 > n) {
            return 1;
        }
        return 0;
    }

    public Interval toInterval() {
        DateTimeField dateTimeField = this.getField();
        long l2 = dateTimeField.roundFloor(this.getMillis());
        long l3 = dateTimeField.add(l2, 1);
        Interval interval = new Interval(l2, l3, this.getChronology());
        return interval;
    }

    public int getMaximumTextLength(Locale arg0) {
        return this.getField().getMaximumTextLength(arg0);
    }

    public int compareTo(ReadableInstant arg0) {
        int n;
        if (arg0 == null) {
            throw new IllegalArgumentException("The instant must not be null");
        }
        int n2 = this.get();
        if (n2 < (n = arg0.get(this.getFieldType()))) {
            return -1;
        }
        if (n2 > n) {
            return 1;
        }
        return 0;
    }

    public int getMaximumValue() {
        return this.getField().getMaximumValue(this.getMillis());
    }

    public DurationField getLeapDurationField() {
        return this.getField().getLeapDurationField();
    }

    public abstract DateTimeField getField();

    public DurationField getRangeDurationField() {
        return this.getField().getRangeDurationField();
    }

    public int get() {
        return this.getField().get(this.getMillis());
    }

    public String toString() {
        return "Property[" + this.getName() + "]";
    }

    public int getDifference(ReadableInstant arg0) {
        if (arg0 == null) {
            return this.getField().getDifference(this.getMillis(), DateTimeUtils.currentTimeMillis());
        }
        return this.getField().getDifference(this.getMillis(), arg0.getMillis());
    }

    public String getAsString() {
        return Integer.toString(this.get());
    }

    public int getMaximumShortTextLength(Locale arg0) {
        return this.getField().getMaximumShortTextLength(arg0);
    }

    public DurationField getDurationField() {
        return this.getField().getDurationField();
    }

    public String getName() {
        return this.getField().getName();
    }

    public int hashCode() {
        return this.get() * 17 + this.getFieldType().hashCode() + this.getChronology().hashCode();
    }

    public boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (!(arg0 instanceof AbstractReadableInstantFieldProperty)) {
            return false;
        }
        AbstractReadableInstantFieldProperty abstractReadableInstantFieldProperty = (AbstractReadableInstantFieldProperty)arg0;
        return this.get() == abstractReadableInstantFieldProperty.get() && this.getFieldType().equals(abstractReadableInstantFieldProperty.getFieldType()) && FieldUtils.equals(this.getChronology(), abstractReadableInstantFieldProperty.getChronology());
    }

    protected abstract long getMillis();

    public String getAsText(Locale arg0) {
        return this.getField().getAsText(this.getMillis(), arg0);
    }

    public int getLeapAmount() {
        return this.getField().getLeapAmount(this.getMillis());
    }

    public String getAsShortText(Locale arg0) {
        return this.getField().getAsShortText(this.getMillis(), arg0);
    }

    public boolean isLeap() {
        return this.getField().isLeap(this.getMillis());
    }

    public int getMinimumValueOverall() {
        return this.getField().getMinimumValue();
    }

    public long remainder() {
        return this.getField().remainder(this.getMillis());
    }

    public int getMaximumValueOverall() {
        return this.getField().getMaximumValue();
    }
}

