/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.convert;

import org.joda.time.convert.Converter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConverterSet {
    private final Converter[] iConverters;
    private Entry[] iSelectEntries;

    private static Converter selectSlow(ConverterSet a2, Class<?> a3) {
        Class<?> clazz;
        Converter converter;
        int n;
        Converter[] converterArray = a2.iConverters;
        int n2 = n = converterArray.length;
        while (--n2 >= 0) {
            converter = converterArray[n2];
            clazz = converter.getSupportedType();
            if (clazz == a3) {
                return converter;
            }
            if (clazz != null && (a3 == null || clazz.isAssignableFrom(a3))) continue;
            a2 = a2.remove(n2, null);
            converterArray = a2.iConverters;
            n = converterArray.length;
        }
        if (a3 == null || n == 0) {
            return null;
        }
        if (n == 1) {
            return converterArray[0];
        }
        n2 = n;
        while (--n2 >= 0) {
            converter = converterArray[n2];
            clazz = converter.getSupportedType();
            int n3 = n;
            while (--n3 >= 0) {
                if (n3 == n2 || !converterArray[n3].getSupportedType().isAssignableFrom(clazz)) continue;
                a2 = a2.remove(n3, null);
                converterArray = a2.iConverters;
                n = converterArray.length;
                n2 = n - 1;
            }
        }
        if (n == 1) {
            return converterArray[0];
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Unable to find best converter for type \"");
        stringBuilder.append(a3.getName());
        stringBuilder.append("\" from remaining set: ");
        for (int i2 = 0; i2 < n; ++i2) {
            converter = converterArray[i2];
            Class<?> clazz2 = converter.getSupportedType();
            stringBuilder.append(converter.getClass().getName());
            stringBuilder.append('[');
            stringBuilder.append(clazz2 == null ? null : clazz2.getName());
            stringBuilder.append("], ");
        }
        throw new IllegalStateException(stringBuilder.toString());
    }

    ConverterSet remove(int a2, Converter[] a3) {
        ConverterSet a4;
        Converter[] converterArray = a4.iConverters;
        int n = converterArray.length;
        if (a2 >= n) {
            throw new IndexOutOfBoundsException();
        }
        if (a3 != null) {
            a3[0] = converterArray[a2];
        }
        Converter[] converterArray2 = new Converter[n - 1];
        int n2 = 0;
        for (int i2 = 0; i2 < n; ++i2) {
            if (i2 == a2) continue;
            converterArray2[n2++] = converterArray[i2];
        }
        return new ConverterSet(converterArray2);
    }

    ConverterSet(Converter[] a2) {
        ConverterSet a3;
        a3.iConverters = a2;
        a3.iSelectEntries = new Entry[16];
    }

    ConverterSet remove(Converter a2, Converter[] a3) {
        ConverterSet a4;
        Converter[] converterArray = a4.iConverters;
        int n = converterArray.length;
        for (int i2 = 0; i2 < n; ++i2) {
            if (!a2.equals(converterArray[i2])) continue;
            return a4.remove(i2, a3);
        }
        if (a3 != null) {
            a3[0] = null;
        }
        return a4;
    }

    ConverterSet add(Converter a2, Converter[] a3) {
        ConverterSet a4;
        Converter[] converterArray = a4.iConverters;
        int n = converterArray.length;
        for (int i2 = 0; i2 < n; ++i2) {
            Converter converter = converterArray[i2];
            if (a2.equals(converter)) {
                if (a3 != null) {
                    a3[0] = null;
                }
                return a4;
            }
            if (a2.getSupportedType() != converter.getSupportedType()) continue;
            Converter[] converterArray2 = new Converter[n];
            for (int i3 = 0; i3 < n; ++i3) {
                converterArray2[i3] = i3 != i2 ? converterArray[i3] : a2;
            }
            if (a3 != null) {
                a3[0] = converter;
            }
            return new ConverterSet(converterArray2);
        }
        Converter[] converterArray3 = new Converter[n + 1];
        System.arraycopy(converterArray, 0, converterArray3, 0, n);
        converterArray3[n] = a2;
        if (a3 != null) {
            a3[0] = null;
        }
        return new ConverterSet(converterArray3);
    }

    int size() {
        ConverterSet a2;
        return a2.iConverters.length;
    }

    Converter select(Class<?> a2) throws IllegalStateException {
        int n;
        Entry entry;
        int n2;
        ConverterSet a3;
        Entry[] entryArray = a3.iSelectEntries;
        int n3 = entryArray.length;
        int n4 = n2 = a2 == null ? 0 : a2.hashCode() & n3 - 1;
        while ((entry = entryArray[n2]) != null) {
            if (entry.iType == a2) {
                return entry.iConverter;
            }
            if (++n2 < n3) continue;
            n2 = 0;
        }
        Converter converter = ConverterSet.selectSlow(a3, a2);
        entry = new Entry(a2, converter);
        entryArray = (Entry[])entryArray.clone();
        entryArray[n2] = entry;
        for (n = 0; n < n3; ++n) {
            if (entryArray[n] != null) continue;
            a3.iSelectEntries = entryArray;
            return converter;
        }
        n = n3 << 1;
        Entry[] entryArray2 = new Entry[n];
        for (int i2 = 0; i2 < n3; ++i2) {
            entry = entryArray[i2];
            a2 = entry.iType;
            int n5 = n2 = a2 == null ? 0 : a2.hashCode() & n - 1;
            while (entryArray2[n2] != null) {
                if (++n2 < n) continue;
                n2 = 0;
            }
            entryArray2[n2] = entry;
        }
        a3.iSelectEntries = entryArray2;
        return converter;
    }

    void copyInto(Converter[] a2) {
        ConverterSet a3;
        System.arraycopy(a3.iConverters, 0, a2, 0, a3.iConverters.length);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Entry {
        final Converter iConverter;
        final Class<?> iType;

        Entry(Class<?> a2, Converter a3) {
            Entry a4;
            a4.iType = a2;
            a4.iConverter = a3;
        }
    }
}

