/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.io.Serializable;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.field.FieldUtils;
import org.joda.time.field.UnsupportedDateTimeField;
import org.joda.time.field.UnsupportedDurationField;

public abstract class BaseChronology
extends Chronology
implements Serializable {
    private static final long serialVersionUID = -7310865996721419676L;

    public DateTimeField year() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.year(), this.years());
    }

    public DurationField seconds() {
        return UnsupportedDurationField.getInstance(DurationFieldType.seconds());
    }

    public DateTimeField minuteOfHour() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.minuteOfHour(), this.minutes());
    }

    public DateTimeField hourOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.hourOfDay(), this.hours());
    }

    public DateTimeField monthOfYear() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.monthOfYear(), this.months());
    }

    public long add(ReadablePeriod arg0, long arg1, int arg2) {
        if (arg2 != 0 && arg0 != null) {
            int n = arg0.size();
            for (int i2 = 0; i2 < n; ++i2) {
                long l2 = arg0.getValue(i2);
                if (l2 == 0L) continue;
                arg1 = arg0.getFieldType(i2).getField(this).add(arg1, l2 * (long)arg2);
            }
        }
        return arg1;
    }

    public DurationField millis() {
        return UnsupportedDurationField.getInstance(DurationFieldType.millis());
    }

    public DurationField eras() {
        return UnsupportedDurationField.getInstance(DurationFieldType.eras());
    }

    public DurationField days() {
        return UnsupportedDurationField.getInstance(DurationFieldType.days());
    }

    public DurationField hours() {
        return UnsupportedDurationField.getInstance(DurationFieldType.hours());
    }

    public DurationField halfdays() {
        return UnsupportedDurationField.getInstance(DurationFieldType.halfdays());
    }

    public DateTimeField centuryOfEra() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.centuryOfEra(), this.centuries());
    }

    public DateTimeField weekOfWeekyear() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.weekOfWeekyear(), this.weeks());
    }

    public DateTimeField yearOfCentury() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.yearOfCentury(), this.years());
    }

    public DurationField minutes() {
        return UnsupportedDurationField.getInstance(DurationFieldType.minutes());
    }

    public DateTimeField minuteOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.minuteOfDay(), this.minutes());
    }

    public DateTimeField hourOfHalfday() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.hourOfHalfday(), this.hours());
    }

    public DateTimeField millisOfSecond() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.millisOfSecond(), this.millis());
    }

    public DateTimeField era() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.era(), this.eras());
    }

    public long set(ReadablePartial arg0, long arg1) {
        int n = arg0.size();
        for (int i2 = 0; i2 < n; ++i2) {
            arg1 = arg0.getFieldType(i2).getField(this).set(arg1, arg0.getValue(i2));
        }
        return arg1;
    }

    public DurationField centuries() {
        return UnsupportedDurationField.getInstance(DurationFieldType.centuries());
    }

    public long add(long arg0, long arg1, int arg2) {
        if (arg1 == 0L || arg2 == 0) {
            return arg0;
        }
        long l2 = FieldUtils.safeMultiply(arg1, arg2);
        return FieldUtils.safeAdd(arg0, l2);
    }

    public abstract DateTimeZone getZone();

    public DateTimeField weekyearOfCentury() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.weekyearOfCentury(), this.weekyears());
    }

    public DateTimeField halfdayOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.halfdayOfDay(), this.halfdays());
    }

    public DateTimeField dayOfYear() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.dayOfYear(), this.days());
    }

    public long getDateTimeMillis(int arg0, int arg1, int arg2, int arg3) throws IllegalArgumentException {
        long l2 = this.year().set(0L, arg0);
        l2 = this.monthOfYear().set(l2, arg1);
        l2 = this.dayOfMonth().set(l2, arg2);
        return this.millisOfDay().set(l2, arg3);
    }

    public DateTimeField weekyear() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.weekyear(), this.weekyears());
    }

    public DateTimeField clockhourOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.clockhourOfDay(), this.hours());
    }

    public long getDateTimeMillis(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6) throws IllegalArgumentException {
        long l2 = this.year().set(0L, arg0);
        l2 = this.monthOfYear().set(l2, arg1);
        l2 = this.dayOfMonth().set(l2, arg2);
        l2 = this.hourOfDay().set(l2, arg3);
        l2 = this.minuteOfHour().set(l2, arg4);
        l2 = this.secondOfMinute().set(l2, arg5);
        return this.millisOfSecond().set(l2, arg6);
    }

    public long getDateTimeMillis(long arg0, int arg1, int arg2, int arg3, int arg4) throws IllegalArgumentException {
        arg0 = this.hourOfDay().set(arg0, arg1);
        arg0 = this.minuteOfHour().set(arg0, arg2);
        arg0 = this.secondOfMinute().set(arg0, arg3);
        return this.millisOfSecond().set(arg0, arg4);
    }

    public DurationField months() {
        return UnsupportedDurationField.getInstance(DurationFieldType.months());
    }

    public int[] get(ReadablePeriod arg0, long arg1) {
        int n = arg0.size();
        int[] nArray = new int[n];
        if (arg1 != 0L) {
            long l2 = 0L;
            for (int i2 = 0; i2 < n; ++i2) {
                DurationField durationField = arg0.getFieldType(i2).getField(this);
                if (!durationField.isPrecise()) continue;
                int n2 = durationField.getDifference(arg1, l2);
                l2 = durationField.add(l2, n2);
                nArray[i2] = n2;
            }
        }
        return nArray;
    }

    public abstract Chronology withUTC();

    public DateTimeField dayOfMonth() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.dayOfMonth(), this.days());
    }

    public DateTimeField millisOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.millisOfDay(), this.millis());
    }

    public int[] get(ReadablePartial arg0, long arg1) {
        int n = arg0.size();
        int[] nArray = new int[n];
        for (int i2 = 0; i2 < n; ++i2) {
            nArray[i2] = arg0.getFieldType(i2).getField(this).get(arg1);
        }
        return nArray;
    }

    public void validate(ReadablePartial arg0, int[] arg1) {
        DateTimeField dateTimeField;
        int n;
        int n2;
        int n3 = arg0.size();
        for (n2 = 0; n2 < n3; ++n2) {
            n = arg1[n2];
            dateTimeField = arg0.getField(n2);
            if (n < dateTimeField.getMinimumValue()) {
                throw new IllegalFieldValueException(dateTimeField.getType(), (Number)n, (Number)dateTimeField.getMinimumValue(), null);
            }
            if (n <= dateTimeField.getMaximumValue()) continue;
            throw new IllegalFieldValueException(dateTimeField.getType(), (Number)n, null, (Number)dateTimeField.getMaximumValue());
        }
        for (n2 = 0; n2 < n3; ++n2) {
            n = arg1[n2];
            dateTimeField = arg0.getField(n2);
            if (n < dateTimeField.getMinimumValue(arg0, arg1)) {
                throw new IllegalFieldValueException(dateTimeField.getType(), (Number)n, (Number)dateTimeField.getMinimumValue(arg0, arg1), null);
            }
            if (n <= dateTimeField.getMaximumValue(arg0, arg1)) continue;
            throw new IllegalFieldValueException(dateTimeField.getType(), (Number)n, null, (Number)dateTimeField.getMaximumValue(arg0, arg1));
        }
    }

    public DateTimeField secondOfMinute() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.secondOfMinute(), this.seconds());
    }

    public DateTimeField dayOfWeek() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.dayOfWeek(), this.days());
    }

    public DurationField weekyears() {
        return UnsupportedDurationField.getInstance(DurationFieldType.weekyears());
    }

    public abstract String toString();

    public DateTimeField clockhourOfHalfday() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.clockhourOfHalfday(), this.hours());
    }

    public DurationField weeks() {
        return UnsupportedDurationField.getInstance(DurationFieldType.weeks());
    }

    protected BaseChronology() {
    }

    public DateTimeField yearOfEra() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.yearOfEra(), this.years());
    }

    public abstract Chronology withZone(DateTimeZone var1);

    public int[] get(ReadablePeriod arg0, long arg1, long arg2) {
        int n = arg0.size();
        int[] nArray = new int[n];
        if (arg1 != arg2) {
            for (int i2 = 0; i2 < n; ++i2) {
                DurationField durationField = arg0.getFieldType(i2).getField(this);
                int n2 = durationField.getDifference(arg2, arg1);
                if (n2 != 0) {
                    arg1 = durationField.add(arg1, n2);
                }
                nArray[i2] = n2;
            }
        }
        return nArray;
    }

    public DateTimeField secondOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.secondOfDay(), this.seconds());
    }

    public DurationField years() {
        return UnsupportedDurationField.getInstance(DurationFieldType.years());
    }
}

