/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.timeseries.linear.multivariate.arima;

import dev.nm.algebra.linear.matrix.doubles.ImmutableMatrix;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;
import dev.nm.stat.timeseries.linear.multivariate.stationaryprocess.arma.VARMAXModel;
import dev.nm.stat.timeseries.linear.univariate.arima.ARIMAXModel;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class VARIMAXModel {
    private final ImmutableVector short;
    private final ImmutableMatrix enum;
    private final ImmutableMatrix false;
    private final ImmutableMatrix[] void;
    private final int if;
    private final ImmutableMatrix[] new;

    public ImmutableMatrix psi() {
        return this.false != null ? this.false : null;
    }

    public ImmutableVector mu() {
        return this.short;
    }

    public int d() {
        return this.if;
    }

    public ImmutableMatrix MA(int i2) {
        return i2 <= this.q() ? this.new[i2] : new ImmutableMatrix((Matrix)this.new[0].ZERO());
    }

    public VARIMAXModel(Matrix[] phi, int d2, Matrix[] theta, Matrix psi, Matrix sigma) {
        this(new DenseVector(DoubleUtils.rep(0.0, sigma.nRows())), phi, d2, theta, psi, sigma);
    }

    public ImmutableMatrix[] theta() {
        return this.new;
    }

    static {
        Package.validate("NMDEV_STAT");
    }

    public int dimension() {
        return this.short.size();
    }

    public VARIMAXModel(Vector mu, Matrix[] phi, int d2, Matrix[] theta, Matrix psi, Matrix sigma) {
        int a2;
        ArgumentAssertion.assertNonNegative(d2, "d");
        this.if = d2;
        this.short = new ImmutableVector(mu);
        int a3 = mu.size();
        this.void = new ImmutableMatrix[phi != null ? phi.length + 1 : 1];
        this.void[0] = new ImmutableMatrix(new DenseMatrix(a3, a3).ONE());
        if (phi != null) {
            for (a2 = 0; a2 < phi.length; ++a2) {
                ArgumentAssertion.assertTrue(phi[a2].nRows() == a3 && phi[a2].nCols() == a3, "each AR coefficient should be a square matrix of the correct dimension", new Object[0]);
                this.void[a2 + 1] = new ImmutableMatrix(phi[a2]);
            }
        }
        this.new = new ImmutableMatrix[theta != null ? theta.length + 1 : 1];
        this.new[0] = new ImmutableMatrix(new DenseMatrix(a3, a3).ONE());
        if (theta != null) {
            for (a2 = 0; a2 < theta.length; ++a2) {
                ArgumentAssertion.assertTrue(theta[a2].nRows() == a3 && theta[a2].nCols() == a3, "each MA coefficient should be a square matrix of the correct dimension", new Object[0]);
                this.new[a2 + 1] = new ImmutableMatrix(theta[a2]);
            }
        }
        if (psi != null) {
            ArgumentAssertion.assertTrue(psi.nRows() == a3, "number of rows of psi should be the same as the dimension of the multivariate ARIMA model", new Object[0]);
            this.false = new ImmutableMatrix(psi);
        } else {
            this.false = null;
        }
        ArgumentAssertion.assertTrue(sigma.nRows() == a3 && sigma.nCols() == a3, "sigma should be a square matrix of the correct dimension", new Object[0]);
        this.enum = new ImmutableMatrix(sigma);
    }

    public ImmutableMatrix[] phi() {
        return this.void;
    }

    public VARIMAXModel(ARIMAXModel model) {
        int a2;
        this.short = new ImmutableVector(new DenseVector(DoubleUtils.rep(model.mu(), 1)));
        this.if = model.d();
        this.enum = new ImmutableMatrix(new DenseMatrix(new double[]{model.sigma()}, 1, 1));
        int a3 = model.p();
        int a4 = model.q();
        this.void = new ImmutableMatrix[a3 + 1];
        for (a2 = 0; a2 <= a3; ++a2) {
            this.void[a2] = new ImmutableMatrix(new DenseMatrix(new double[]{model.AR(a2)}, 1, 1));
        }
        this.new = new ImmutableMatrix[a4 + 1];
        for (a2 = 0; a2 <= a4; ++a2) {
            this.new[a2] = new ImmutableMatrix(new DenseMatrix(new double[]{model.MA(a2)}, 1, 1));
        }
        this.false = model.psi() != null ? new ImmutableMatrix(new DenseMatrix(model.psi(), 1, model.psi().length)) : null;
    }

    public int maxPQ() {
        return Math.max(this.p(), this.q());
    }

    public ImmutableMatrix sigma() {
        return this.enum;
    }

    public VARMAXModel getVARMAX() {
        return new VARMAXModel((Vector)this.short, (Matrix[])Arrays.copyOfRange(this.void, 1, this.void.length), (Matrix[])Arrays.copyOfRange(this.new, 1, this.new.length), (Matrix)this.false, (Matrix)this.enum);
    }

    public int p() {
        return this.void.length - 1;
    }

    public VARIMAXModel(VARIMAXModel that) {
        this.short = new ImmutableVector(new DenseVector(that.short));
        this.void = Arrays.copyOf(that.void, that.void.length);
        this.new = Arrays.copyOf(that.new, that.new.length);
        this.false = that.false != null ? new ImmutableMatrix(new DenseMatrix(that.false)) : null;
        this.if = that.if;
        this.enum = new ImmutableMatrix(new DenseMatrix(that.enum));
    }

    public ImmutableMatrix AR(int i2) {
        return i2 <= this.p() ? this.void[i2] : new ImmutableMatrix((Matrix)this.void[0].ZERO());
    }

    public VARIMAXModel(Vector mu, Matrix[] phi, int d2, Matrix[] theta, Matrix psi) {
        this(mu, phi, d2, theta, psi, new DenseMatrix(mu.size(), mu.size()).ONE());
    }

    public VARIMAXModel(Matrix[] phi, int d2, Matrix[] theta, Matrix psi) {
        this(phi, d2, theta, psi, (Matrix)new DenseMatrix(phi != null ? phi[0].nRows() : theta[0].nRows(), phi != null ? phi[0].nRows() : theta[0].nRows()).ONE());
    }

    public int q() {
        return this.new.length - 1;
    }
}

