/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.test.distribution.normality;

import dev.nm.analysis.function.FunctionOps;
import dev.nm.analysis.function.polynomial.Polynomial;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.stat.descriptive.moment.Mean;
import dev.nm.stat.distribution.univariate.NormalDistribution;
import dev.nm.stat.distribution.univariate.ProbabilityDistribution;
import dev.nm.stat.test.HypothesisTest;
import dev.nm.stat.test.distribution.normality.ShapiroWilkDistribution;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ShapiroWilk
extends HypothesisTest {
    private double false;
    private final ProbabilityDistribution void = new NormalDistribution();
    private final Polynomial if = new Polynomial(-2.706056, 4.434685, -2.07119, -0.147981, 0.221157, 0.0);
    private final Polynomial new = new Polynomial(-3.582633, 5.682633, -1.752461, -0.293762, 0.042981, 0.0);

    @Override
    public String getAlternativeHypothesis() {
        return "the samples do not come from a normally distributed population";
    }

    public ShapiroWilk(double[] sample) {
        super(new double[][]{sample});
        int a2 = this.nObs();
        ArgumentAssertion.assertRange(a2, 3, 5000, "sample size");
        double[] a3 = Arrays.copyOf(sample, sample.length);
        Arrays.sort(a3);
        double[] a4 = new double[a2];
        double a5 = 0.0;
        for (int a6 = 0; a6 < a2; ++a6) {
            a4[a6] = this.void.quantile(((double)(a6 + 1) - 0.375) / ((double)a2 + 0.25));
            a5 += a4[a6] * a4[a6];
        }
        double a7 = Math.sqrt(a5);
        double[] a8 = new double[a2];
        for (int a9 = 0; a9 < a2; ++a9) {
            a8[a9] = a4[a9] / a7;
        }
        double a10 = 1.0 / Math.sqrt(a2);
        double[] a11 = new double[a2];
        if (a2 == 3) {
            a11[0] = 0.707106781;
            a11[a2 - 1] = -a11[0];
        } else {
            a11[a2 - 1] = this.if.evaluate(a10) + a8[a2 - 1];
            a11[0] = -a11[a2 - 1];
            int a12 = 0;
            double a13 = 0.0;
            if (a2 <= 5) {
                a12 = 2;
                a13 = a5 - 2.0 * a4[a2 - 1] * a4[a2 - 1];
                a13 /= 1.0 - 2.0 * a11[a2 - 1] * a11[a2 - 1];
            } else {
                a12 = 3;
                a11[a2 - 2] = this.new.evaluate(a10) + a8[a2 - 2];
                a11[1] = -a11[a2 - 2];
                a13 = a5 - 2.0 * a4[a2 - 1] * a4[a2 - 1] - 2.0 * a4[a2 - 2] * a4[a2 - 2];
                a13 /= 1.0 - 2.0 * a11[a2 - 1] * a11[a2 - 1] - 2.0 * a11[a2 - 2] * a11[a2 - 2];
            }
            double a14 = Math.sqrt(a13);
            for (int a15 = a12 - 1; a15 < a2 - a12 + 1; ++a15) {
                a11[a15] = a4[a15] / a14;
            }
        }
        double a16 = new Mean(a3).value();
        double a17 = 0.0;
        for (int a18 = 0; a18 < a2; ++a18) {
            double a19 = a3[a18] - a16;
            a17 += a19 * a19;
        }
        this.false = FunctionOps.dotProduct(a11, a3);
        this.false *= this.false;
        this.false /= a17;
    }

    @Override
    public double pValue() {
        int a2 = this.nObs();
        double a3 = ShapiroWilk.oneSidedPvalue(new ShapiroWilkDistribution(a2), this.false);
        return a3;
    }

    @Override
    public double statistics() {
        return this.false;
    }

    @Override
    public String getNullHypothesis() {
        return "the samples come from a normally distributed population";
    }
}

