/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.distribution.univariate;

import dev.nm.analysis.function.special.beta.BetaRegularized;
import dev.nm.analysis.function.special.beta.BetaRegularizedInverse;
import dev.nm.analysis.function.special.beta.LogBeta;
import dev.nm.analysis.function.special.gamma.Digamma;
import dev.nm.analysis.function.special.gamma.LogGamma;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.ExceptionUtils;
import dev.nm.number.DoubleUtils;
import dev.nm.stat.distribution.univariate.ProbabilityDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TDistribution
implements ProbabilityDistribution {
    private static final Digamma short;
    private final BetaRegularized enum;
    private final BetaRegularizedInverse false;
    private static final LogGamma void;
    private final double if;
    private static final LogBeta new;

    @Override
    public double kurtosis() {
        ExceptionUtils.throwIfNotNull(this.if > 4.0 ? null : new UnsupportedOperationException("only for v > 4"));
        return 6.0 / (this.if - 4.0);
    }

    @Override
    public double variance() {
        ExceptionUtils.throwIfNotNull(this.if >= 2.0 ? null : new UnsupportedOperationException("only for v >= 2"));
        if (this.if == 2.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.if / (this.if - 2.0);
    }

    static {
        new = new LogBeta();
        void = new LogGamma();
        short = new Digamma();
    }

    public TDistribution(double v) {
        ArgumentAssertion.assertTrue(v > 0.0, "only for v > 0", new Object[0]);
        this.if = v;
        this.enum = new BetaRegularized(v / 2.0, v / 2.0);
        this.false = new BetaRegularizedInverse(v / 2.0, v / 2.0);
    }

    @Override
    public double mean() {
        ExceptionUtils.throwIfNotNull(this.if > 1.0 ? null : new UnsupportedOperationException("only for v > 1"));
        return 0.0;
    }

    @Override
    public double median() {
        return 0.0;
    }

    @Override
    public double cdf(double x) {
        double a2 = x;
        a2 /= 2.0 * Math.sqrt(x * x + this.if);
        return this.enum.evaluate(a2 += 0.5);
    }

    @Override
    public double quantile(double u) {
        double a2 = this.false.evaluate(u);
        double a3 = 0.25 / (a2 - 0.5) / (a2 - 0.5) / this.if - 1.0 / this.if;
        a3 = 1.0 / a3;
        a3 = Math.sqrt(a3);
        a3 = a2 - 0.5 > 0.0 ? a3 : -a3;
        return a3;
    }

    @Override
    public double moment(double x) {
        throw new UnsupportedOperationException("not defined.");
    }

    @Override
    public double skew() {
        ExceptionUtils.throwIfNotNull(this.if > 3.0 ? null : new UnsupportedOperationException("only for v > 3"));
        return 0.0;
    }

    @Override
    public double density(double x) {
        if (DoubleUtils.isZero(x, 0.0)) {
            return 0.0;
        }
        double a2 = void.evaluate((this.if + 1.0) / 2.0);
        a2 -= Math.log(Math.sqrt(this.if * Math.PI)) + void.evaluate(this.if / 2.0);
        a2 += -(this.if + 1.0) / 2.0 * Math.log(1.0 + x * x / this.if);
        a2 = Math.exp(a2);
        return a2;
    }

    @Override
    public double entropy() {
        double a2 = (this.if + 1.0) / 2.0;
        a2 *= short.evaluate((1.0 + this.if) / 2.0) - short.evaluate(this.if / 2.0);
        return a2 += Math.log(Math.sqrt(this.if)) + new.evaluate(this.if / 2.0, 0.5);
    }
}

