/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.distribution.multivariate;

import dev.nm.algebra.linear.matrix.doubles.ImmutableMatrix;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.Inverse;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixMeasure;
import dev.nm.algebra.linear.matrix.doubles.operation.VariancebtX;
import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.stat.distribution.multivariate.MultivariateProbabilityDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MultivariateNormalDistribution
implements MultivariateProbabilityDistribution {
    private final ImmutableVector false;
    private final ImmutableMatrix void;
    private final double if;
    private final Matrix new;

    @Override
    public Vector mean() {
        return this.false;
    }

    @Override
    public double density(Vector x) {
        Vector a2 = x.minus(this.false);
        return this.if * Math.exp(-0.5 * a2.innerProduct(this.new.multiply(a2)));
    }

    @Override
    public Matrix covariance() {
        return new ImmutableMatrix(this.void);
    }

    private double final() {
        MultivariateNormalDistribution a2;
        double a3 = MatrixMeasure.det(a2.void);
        int a4 = a2.false.size();
        double a5 = 1.0 / Math.sqrt(Math.pow(Math.PI * 2, a4) * a3);
        return a5;
    }

    public MultivariateNormalDistribution(Vector mu, Matrix Sigma) {
        ArgumentAssertion.assertTrue(mu.size() == Sigma.nCols() && Sigma.nCols() == Sigma.nRows(), "the size of the mean vector must match the size of the covariance matrix", new Object[0]);
        ArgumentAssertion.assertTrue(MatrixPropertyUtils.isSymmetric(Sigma, 0.0), "the covariance matrix must be symmetric", new Object[0]);
        this.false = new ImmutableVector(mu);
        this.void = new ImmutableMatrix(Sigma);
        this.new = new Inverse(Sigma);
        this.if = this.final();
    }

    @Override
    public double cdf(Vector x) {
        throw new UnsupportedOperationException("not yet supported");
    }

    public MultivariateNormalDistribution(int dim) {
        this(new DenseVector(dim), new DenseMatrix(dim, dim).ONE());
    }

    @Override
    public double moment(Vector t) {
        double a2 = this.false.innerProduct(t);
        return a2 += new VariancebtX(t, this.new).doubleValue();
    }

    @Override
    public double entropy() {
        int a2 = this.false.size();
        double a3 = (double)a2 / 2.0 * (1.0 + Math.log(Math.PI * 2));
        return a3 += Math.log(MatrixMeasure.det(this.new)) / 2.0;
    }

    @Override
    public Vector mode() {
        return this.false;
    }
}

