/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.descriptive.correlation;

import dev.nm.analysis.function.tuple.Pair;
import dev.nm.combinatorics.Ties;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.stat.descriptive.Statistic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class KendallRankCorrelation
implements Statistic {
    private final List<Double> if = new ArrayList<Double>();
    private final List<Double> new = new ArrayList<Double>();

    @Override
    public long N() {
        return this.if.size();
    }

    private List<Pair> final() {
        KendallRankCorrelation a2;
        int a3 = (int)a2.N();
        ArrayList<Pair> a4 = new ArrayList<Pair>(a3);
        for (int a5 = 0; a5 < a3; ++a5) {
            a4.add(new Pair(a2.if.get(a5), a2.new.get(a5)));
        }
        return a4;
    }

    private long final(List<Double> a2, List<Double> a3) {
        int a4 = a2.size();
        int a5 = a3.size();
        int a6 = a4 - 1;
        int a7 = a5 - 1;
        int a8 = 0;
        while (a6 >= 0 && a7 >= 0) {
            if (a2.get(a6) > a3.get(a7)) {
                a8 += a7 + 1;
                --a6;
                continue;
            }
            --a7;
        }
        return a8;
    }

    public KendallRankCorrelation(double[] data1, double[] data2) {
        this.addData(data1, data2);
    }

    private List<Double> final(List<Pair> a2) {
        ArrayList<Double> a3 = new ArrayList<Double>(a2.size());
        for (Pair a4 : a2) {
            a3.add(a4.y());
        }
        return a3;
    }

    @Override
    public void addData(double ... data) {
        ArgumentAssertion.assertTrue(data.length % 2 == 0, "there must be an even number of data points", new Object[0]);
        int a2 = data.length / 2;
        double[] a3 = Arrays.copyOfRange(data, 0, a2);
        double[] a4 = Arrays.copyOfRange(data, a2, data.length);
        this.addData(a3, a4);
    }

    private long char(List<Double> a2) {
        KendallRankCorrelation a3;
        if (a2.size() <= 1) {
            return 0L;
        }
        int a4 = a2.size() / 2;
        List<Double> a5 = a2.subList(0, a4);
        List<Double> a6 = a2.subList(a4, a2.size());
        long a7 = a3.char(a5);
        long a8 = a3.char(a6);
        Collections.sort(a5);
        Collections.sort(a6);
        long a9 = a3.final(a5, a6);
        return a7 + a8 + a9;
    }

    public void addData(double[] data1, double[] data2) {
        ArgumentAssertion.assertEqual(data1.length, data2.length, "data1's length", "data2's length");
        for (int a2 = 0; a2 < data1.length; ++a2) {
            this.if.add(data1[a2]);
            this.new.add(data2[a2]);
        }
    }

    @Override
    public double value() {
        long a2 = this.N();
        long a3 = a2 * (a2 - 1L) / 2L;
        long a4 = this.final((List)this.if);
        long a5 = this.final((List)this.new);
        List<Pair> a6 = this.final();
        long a7 = this.final((List)a6);
        Collections.sort(a6);
        long a8 = this.char(this.final(a6));
        long a9 = a3 - a4 - a5 + a7 - 2L * a8;
        double a10 = Math.sqrt((a3 - a4) * (a3 - a5));
        return (double)a9 / a10;
    }

    private <T> long final(List<T> a2) {
        Ties<T> a3 = new Ties<T>(a2);
        long a4 = 0L;
        for (Long a5 : a3.values()) {
            a4 += a5 * (a5 - 1L) / 2L;
        }
        return a4;
    }
}

