/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.solver.multivariate.unconstrained.c2.quasinewton;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.solver.multivariate.unconstrained.c2.linesearch.FletcherLineSearch;
import dev.nm.solver.multivariate.unconstrained.c2.steepestdescent.SteepestDescentMinimizer;
import dev.nm.solver.problem.C2OptimProblem;

public abstract class QuasiNewtonMinimizer
extends SteepestDescentMinimizer {
    public QuasiNewtonMinimizer(double epsilon, int maxIterations) {
        super(new FletcherLineSearch(0.1, 0.7, 0.1, 0.75, 1.0E-10, 600), epsilon, maxIterations);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected abstract class QuasiNewtonImpl
    extends SteepestDescentMinimizer.SteepestDescentImpl {
        private double new;
        protected Vector dk;
        protected double ak;
        protected Vector gk;
        protected Matrix Sk;

        @Override
        public Vector getDirection(Vector xk) {
            Vector a2 = this.gk;
            this.gk = (Vector)this.problem.g().evaluate(xk);
            if (this.dk != null) {
                Vector a3 = this.gk.minus(a2);
                this.new = a3.norm();
                if (this.new <= QuasiNewtonMinimizer.this.epsilon) {
                    return this.dk;
                }
                this.updateSk(a3);
            }
            this.dk = this.Sk.multiply(this.gk).scaled(-1.0);
            return this.dk;
        }

        QuasiNewtonImpl(C2OptimProblem a3) throws Exception {
            QuasiNewtonImpl a4;
            super(a4.QuasiNewtonMinimizer.this, a3);
            a4.gk = null;
            a4.dk = null;
            a4.new = Double.POSITIVE_INFINITY;
            int a5 = a3.f().dimensionOfDomain();
            a4.Sk = new DenseMatrix(a5, a5).ONE();
        }

        abstract void updateSk(Vector var1);

        @Override
        public double getIncrement(Vector xk, Vector dk) {
            if (this.new <= QuasiNewtonMinimizer.this.epsilon) {
                return 1.0E-5;
            }
            this.ak = super.getIncrement(xk, dk);
            return this.ak;
        }
    }
}

