/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.solver.multivariate.constrained.general.sqp.activeset;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.Inverse;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixFactory;
import dev.nm.algebra.linear.matrix.doubles.operation.SubMatrixRef;
import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.algebra.linear.vector.doubles.operation.VectorFactory;
import dev.nm.analysis.differentiation.multivariate.Gradient;
import dev.nm.analysis.differentiation.multivariate.Jacobian;
import dev.nm.analysis.function.rn2r1.QuadraticFunction;
import dev.nm.analysis.function.rn2r1.RealScalarFunction;
import dev.nm.analysis.function.rn2rm.RealVectorFunction;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.Constants;
import dev.nm.number.DoubleUtils;
import dev.nm.number.doublearray.DoubleArrayMath;
import dev.nm.solver.IterativeSolution;
import dev.nm.solver.multivariate.constrained.ConstrainedMinimizer;
import dev.nm.solver.multivariate.constrained.constraint.EqualityConstraints;
import dev.nm.solver.multivariate.constrained.constraint.GreaterThanConstraints;
import dev.nm.solver.multivariate.constrained.constraint.linear.LinearEqualityConstraints;
import dev.nm.solver.multivariate.constrained.constraint.linear.LinearGreaterThanConstraints;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.qp.QPInfeasible;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.qp.QPSolution;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.qp.problem.QPProblem;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.qp.solver.activeset.QPPrimalActiveSetMinimizer;
import dev.nm.solver.multivariate.constrained.general.sqp.activeset.SQPASVariation;
import dev.nm.solver.multivariate.constrained.general.sqp.activeset.SQPASVariation1;
import dev.nm.solver.multivariate.constrained.problem.ConstrainedOptimProblem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SQPActiveSetMinimizer
implements ConstrainedMinimizer<ConstrainedOptimProblem, IterativeSolution<Vector>> {
    protected final int maxIterations;
    protected final double epsilon1;
    protected final double epsilon2;
    private final VariationFactory new;

    public SQPActiveSetMinimizer(double epsilon1, double epsilon2, int maxIterations) {
        this(new VariationFactory(){
            {
                1 a2;
            }

            @Override
            public SQPASVariation newVariation(RealScalarFunction f2, RealVectorFunction g2, EqualityConstraints equal, GreaterThanConstraints greater) {
                SQPASVariation1 a2 = new SQPASVariation1(Math.sqrt(Constants.EPSILON));
                a2.set(f2, g2, equal, greater);
                return a2;
            }
        }, epsilon1, epsilon2, maxIterations);
    }

    public SQPActiveSetMinimizer(VariationFactory variant, double epsilon1, double epsilon2, int maxIterations) {
        this.new = variant;
        this.epsilon1 = epsilon1;
        this.epsilon2 = epsilon2;
        this.maxIterations = maxIterations;
    }

    @Override
    public Solution solve(ConstrainedOptimProblem problem) throws Exception {
        return new Solution(problem.f(), null, problem.getEqualityConstraints(), problem.getLessThanConstraints().toGreaterThanConstraints());
    }

    public SQPActiveSetMinimizer(double epsilon1, int maxIterations) {
        this(epsilon1, epsilon1, maxIterations);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class Solution
    implements IterativeSolution<Vector> {
        private Vector super;
        private final RealScalarFunction null;
        private Matrix class;
        private Vector true;
        private Matrix break;
        private Vector const;
        private Vector this;
        private final GreaterThanConstraints else;
        private Matrix goto;
        private final int try;
        private final SQPASVariation float;
        private final EqualityConstraints short;
        private final RealVectorFunction enum;
        private final List<RealScalarFunction> false;
        private final List<RealScalarFunction> void;
        private Vector if;
        private final int new;

        @Override
        public double minimum() {
            return (Double)this.null.evaluate(this.true);
        }

        protected Solution(RealScalarFunction f2, RealVectorFunction g2, EqualityConstraints equal, GreaterThanConstraints greater) {
            this.null = f2;
            this.enum = g2;
            this.short = equal;
            this.false = equal != null ? equal.getConstraints() : new ArrayList(0);
            this.new = this.false.size();
            this.else = greater;
            this.void = greater.getConstraints();
            this.try = this.void.size();
            this.float = SQPActiveSetMinimizer.this.new.newVariation(f2, g2, equal, greater);
        }

        public Vector search(Vector x0, Vector lambda0, Vector mu0) throws Exception {
            this.setInitials(x0, lambda0, mu0);
            for (int a2 = 0; a2 < SQPActiveSetMinimizer.this.maxIterations; ++a2) {
                Matrix a3;
                this.step();
                if (this.this.norm() < SQPActiveSetMinimizer.this.epsilon1) break;
                this.goto = a3 = this.float.updateHessian(this.true, this.if, this.super, this.this, this.const, this.class, this.break, this.goto);
            }
            return this.minimizer();
        }

        public Vector search(Vector x0) throws Exception {
            return this.search(x0, (Vector)(this.short != null ? new DenseVector(this.short.getConstraints().size(), -1.0) : new DenseVector(0)), (Vector)new DenseVector(this.else.getConstraints().size(), 1.0));
        }

        @Override
        public Vector minimizer() {
            return new ImmutableVector(this.true);
        }

        public void setInitials(Vector ... initials) {
            this.true = initials[0];
            this.if = initials[1];
            this.super = initials[2];
            this.goto = this.float.getInitialHessian(this.true, this.if, this.super);
            ArgumentAssertion.assertTrue(DoubleArrayMath.min(this.super.toArray()) >= 0.0, "mu[0] must be >= 0", new Object[0]);
        }

        public Vector search(Vector ... initials) throws Exception {
            switch (initials.length) {
                case 1: {
                    return this.search(initials[0]);
                }
                case 3: {
                    return this.search(initials[0], initials[1], initials[2]);
                }
            }
            throw new IllegalArgumentException("wrong number of paramters");
        }

        @Override
        public Object step() throws Exception {
            Object a2;
            Object a3;
            Object a4;
            Object a5;
            Object a6;
            Object a7;
            this.const = this.enum != null ? (Vector)this.enum.evaluate(this.true) : new Gradient(this.null, this.true);
            this.class = this.short != null ? new Jacobian(this.false, this.true) : new DenseMatrix(0, 0);
            this.break = new Jacobian(this.void, this.true);
            DenseVector a8 = new DenseVector(this.new);
            for (int a9 = 0; a9 < this.new; ++a9) {
                a8.set(a9 + 1, (Double)this.false.get(a9).evaluate(this.true));
            }
            DenseVector a10 = new DenseVector(this.try);
            for (int a11 = 0; a11 < this.try; ++a11) {
                a10.set(a11 + 1, (Double)this.void.get(a11).evaluate(this.true));
            }
            try {
                a7 = new QuadraticFunction(this.goto, this.const);
                LinearEqualityConstraints a12 = this.short != null ? new LinearEqualityConstraints(this.class, a8.scaled(-1.0)) : null;
                a6 = new LinearGreaterThanConstraints(this.break, a10.scaled(-1.0));
                a5 = new QPProblem((QuadraticFunction)a7, a12, (LinearGreaterThanConstraints)a6);
                a4 = new QPPrimalActiveSetMinimizer(SQPActiveSetMinimizer.this.epsilon2, SQPActiveSetMinimizer.this.maxIterations);
                a3 = ((QPPrimalActiveSetMinimizer)a4).solve((QPProblem)a5);
                a2 = a3.search(new QPSolution[0]);
                this.this = a2.minimizer();
            }
            catch (QPInfeasible a13) {
                throw new RuntimeException(String.format("unable to solve a sub quadratic programming problem: ", a13.getMessage()));
            }
            a7 = new ArrayList();
            for (int a14 = 1; a14 <= this.break.nRows(); ++a14) {
                a6 = this.break.getRow(a14);
                double a15 = a6.innerProduct(this.this);
                if (!(Math.abs(a15 + a10.get(a14)) < SQPActiveSetMinimizer.this.epsilon1)) continue;
                ((ArrayList)a7).add(a14);
            }
            if (!((ArrayList)a7).isEmpty()) {
                int[] a16 = DoubleUtils.collection2IntArray((Collection<Integer>)a7);
                a6 = DoubleUtils.seq(1, this.break.nCols());
                a5 = new SubMatrixRef(this.break, a16, (int[])a6);
                a4 = MatrixFactory.rbind(new Matrix[]{this.class, a5});
                a3 = a4.multiply(a4.t());
                a3 = new Inverse((Matrix)a3);
                a3 = a3.multiply((Matrix)a4);
                a2 = this.goto.multiply(this.this);
                a2 = a2.add(this.const);
                Vector a17 = a3.multiply((Vector)a2);
                Vector a18 = this.new > 0 ? VectorFactory.subVector(a17, 1, this.new) : new DenseVector(0);
                Vector a19 = VectorFactory.subVector(a17, this.new + 1, a17.size());
                DenseVector a20 = new DenseVector(this.try);
                for (int a21 = 0; a21 < a16.length; ++a21) {
                    int a22 = a16[a21];
                    a20.set(a22, a19.get(a21 + 1));
                }
                this.if = a18;
                this.super = a20;
            }
            double a23 = this.float.alpha(this.true, this.this, this.if, this.super);
            this.this = this.this.scaled(a23);
            this.true = this.true.add(this.this);
            return true;
        }
    }

    public static interface VariationFactory {
        public SQPASVariation newVariation(RealScalarFunction var1, RealVectorFunction var2, EqualityConstraints var3, GreaterThanConstraints var4);
    }
}

