/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.solver.multivariate.constrained.general.penaltymethod;

import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.solver.multivariate.constrained.general.penaltymethod.PenaltyFunction;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SumOfPenalties
extends PenaltyFunction {
    private final PenaltyFunction[] new;

    public SumOfPenalties(PenaltyFunction ... penalties) {
        int a2 = penalties[0].dimensionOfDomain();
        for (int a3 = 1; a3 < penalties.length; ++a3) {
            ArgumentAssertion.assertTrue(a2 == penalties[a3].dimensionOfDomain(), "the penalties must have the same dimension", new Object[0]);
        }
        this.new = Arrays.copyOf(penalties, penalties.length);
    }

    @Override
    public int dimensionOfDomain() {
        return this.new[0].dimensionOfDomain();
    }

    @Override
    public Double evaluate(Vector x) {
        double a2 = 0.0;
        for (int a3 = 0; a3 < this.new.length; ++a3) {
            a2 += ((Double)this.new[a3].evaluate(x)).doubleValue();
        }
        return a2;
    }
}

