/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.misc.parallel;

import dev.nm.misc.license.Package;
import dev.nm.misc.parallel.IterationBody;
import dev.nm.misc.parallel.LoopBody;
import dev.nm.misc.parallel.MultipleExecutionException;
import dev.nm.misc.parallel.PartialLoopCallable;
import dev.nm.misc.parallel.PartialLoopIncrementCallable;
import dev.nm.misc.parallel.SynchronizedIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ParallelExecutor {
    private final ThreadPoolExecutor float;
    private static final AtomicLong short;
    private static final int enum;
    private final AtomicLong false = new AtomicLong(0L);
    private static final String void = "parallel-executor";
    private final long if = short.incrementAndGet();
    private final int new;

    public void forLoop(int start, int end, LoopBody body) throws MultipleExecutionException {
        this.forLoop(start, end, 1, body);
    }

    public ParallelExecutor(String executorName, int concurrency) {
        this.new = concurrency;
        final String a2 = String.format("%s-%d-thread-", executorName, this.if);
        this.float = new ThreadPoolExecutor(concurrency, concurrency, 1L, TimeUnit.HOURS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            {
                1 a3;
            }

            @Override
            public Thread newThread(Runnable r) {
                String a22 = a2 + ParallelExecutor.this.false.incrementAndGet();
                Thread a3 = new Thread(r, a22);
                if (!a3.isDaemon()) {
                    a3.setDaemon(true);
                }
                if (a3.getPriority() != 5) {
                    a3.setPriority(5);
                }
                return a3;
            }
        });
        this.float.allowCoreThreadTimeOut(true);
    }

    public void shutdown() {
        this.float.shutdown();
    }

    public void conditionalForLoop(boolean conditionToParallelize, int start, int end, int increment, LoopBody body) throws MultipleExecutionException {
        if (conditionToParallelize) {
            this.forLoop(start, end, increment, body);
        } else {
            try {
                for (int a2 = start; a2 < end; a2 += increment) {
                    body.run(a2);
                }
            }
            catch (Exception a3) {
                throw new MultipleExecutionException(Arrays.asList(new Void[]{null}), Arrays.asList(new ExecutionException(a3)));
            }
        }
    }

    public ParallelExecutor() {
        this(void, enum);
    }

    public ParallelExecutor(String executorName) {
        this(executorName, enum);
    }

    static {
        Package.validate("NMDEV_BASIC");
        enum = Runtime.getRuntime().availableProcessors();
        short = new AtomicLong(0L);
    }

    public static ParallelExecutor getSharedInstance() {
        return SingletonHolder.new;
    }

    public int getConcurrency() {
        return this.new;
    }

    public ParallelExecutor(int concurrency) {
        this(void, concurrency);
    }

    public void conditionalForLoop(boolean conditionToParallelize, int start, int end, LoopBody body) throws MultipleExecutionException {
        this.conditionalForLoop(conditionToParallelize, start, end, 1, body);
    }

    public <T> T executeAny(List<? extends Callable<T>> tasks) throws ExecutionException {
        T a2 = null;
        try {
            a2 = this.float.invokeAny(tasks);
        }
        catch (InterruptedException a3) {
            throw new RuntimeException(a3);
        }
        return a2;
    }

    public <T> List<T> executeAll(List<? extends Callable<T>> tasks) throws MultipleExecutionException {
        ArrayList a2 = new ArrayList(tasks.size());
        try {
            List a3 = this.float.invokeAll(tasks);
            ArrayList<ExecutionException> a4 = new ArrayList<ExecutionException>(a3.size());
            boolean a5 = false;
            for (Future a6 : a3) {
                try {
                    a2.add(a6.get());
                    a4.add(null);
                }
                catch (ExecutionException a7) {
                    a2.add(null);
                    a4.add(a7);
                    a5 = true;
                }
            }
            if (a5) {
                throw new MultipleExecutionException(a2, a4);
            }
        }
        catch (InterruptedException a8) {
            throw new RuntimeException(a8);
        }
        return a2;
    }

    public <T> void conditionalForEach(boolean conditionToParallelize, Iterable<T> iterable, IterationBody<T> body) throws MultipleExecutionException {
        if (conditionToParallelize) {
            this.forEach(iterable, body);
        } else {
            for (T a2 : iterable) {
                body.run(a2);
            }
        }
    }

    public void forLoop(int start, int end, int increment, LoopBody body) throws MultipleExecutionException {
        int a2;
        ArrayList<PartialLoopCallable> a3 = new ArrayList<PartialLoopCallable>(this.new);
        int a4 = (int)Math.ceil((double)((end - start) / increment) / (double)this.new) * increment;
        a4 = Math.max(1, a4);
        for (int a5 = 0; a5 < this.new && (a2 = start + a5 * a4) < end; ++a5) {
            int a6 = Math.min(a2 + a4, end);
            a3.add((PartialLoopCallable)(increment == 1 ? new PartialLoopCallable(a2, a6, body) : new PartialLoopIncrementCallable(a2, a6, increment, body)));
        }
        this.executeAll(a3);
    }

    public <T> List<T> executeAll(Callable<T> ... tasks) throws MultipleExecutionException {
        return this.executeAll(Arrays.asList(tasks));
    }

    public <T> void forEach(Iterable<T> iterable, final IterationBody<T> body) throws MultipleExecutionException {
        ArrayList<2> a2 = new ArrayList<2>(this.new);
        final SynchronizedIterator<T> a3 = new SynchronizedIterator<T>(iterable.iterator());
        for (int a4 = 0; a4 < this.new; ++a4) {
            a2.add(new Callable<Void>(){
                {
                    2 a32;
                }

                @Override
                public Void call() throws Exception {
                    SynchronizedIterator.Element a2;
                    while ((a2 = a3.next()).exists()) {
                        body.run(a2.get());
                    }
                    return null;
                }
            });
        }
        this.executeAll(a2);
    }

    public <T> T executeAny(Callable<T> ... tasks) throws ExecutionException {
        return this.executeAny(Arrays.asList(tasks));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static final class SingletonHolder {
        private static final ParallelExecutor new = new ParallelExecutor("shared");

        private SingletonHolder() {
            SingletonHolder a2;
        }
    }
}

