/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.geometry.polyline;

import dev.nm.geometry.Point;
import dev.nm.geometry.polyline.PolygonalChain;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PolygonalChainByArray
implements PolygonalChain {
    private final int if;
    private final List<Point> new;

    static {
        Package.validate("NMDEV_BASIC");
    }

    public PolygonalChainByArray(List<? extends Point> vertices) {
        ArgumentAssertion.assertTrue(!vertices.isEmpty(), "list of points must not be empty", new Object[0]);
        this.if = vertices.get(0).dimension();
        ArrayList<Point> a2 = new ArrayList<Point>(vertices.size());
        for (Point point : vertices) {
            ArgumentAssertion.assertTrue(point.dimension() == this.if, "Vector %s has a different number of dimensions (%d expected)", point, this.if);
            a2.add(point);
        }
        this.new = Collections.unmodifiableList(a2);
    }

    @Override
    public List<Point> vertices() {
        return this.new;
    }

    @Override
    public int dimension() {
        return this.if;
    }
}

