/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.integration.univariate.riemann.gaussian.rule;

import dev.nm.algebra.linear.matrix.doubles.linearsystem.LinearSystemSolver;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.analysis.function.FunctionOps;
import dev.nm.analysis.function.polynomial.Polynomial;
import dev.nm.analysis.integration.univariate.riemann.gaussian.rule.GaussianQuadratureRule;
import dev.nm.analysis.integration.univariate.riemann.gaussian.rule.GaussianQuadratureUtils;
import dev.nm.analysis.integration.univariate.riemann.gaussian.rule.LaguerrePolynomials;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LaguerreRule
implements GaussianQuadratureRule {
    private final double[] if;
    private final double[] new;

    @Override
    public double getWeighting(double x) {
        return Math.exp(-x);
    }

    @Override
    public boolean supportsInterval(double a2, double b2) {
        return a2 == 0.0 && b2 == Double.POSITIVE_INFINITY;
    }

    public LaguerreRule(int n, double precision) {
        this.new = LaguerreRule.final(n);
        this.if = LaguerreRule.final(this.new, precision);
    }

    private static double[] final(int a2) {
        Polynomial a3 = new LaguerrePolynomials().getPolynomial(a2);
        return GaussianQuadratureUtils.solveForEvaluationPointsFromPolynomial(a3);
    }

    @Override
    public double[] getCoefficients() {
        return Arrays.copyOf(this.if, this.if.length);
    }

    private static double[] final(double[] a2, double a3) {
        int a4 = a2.length;
        DenseVector a5 = new DenseVector(a4);
        DenseMatrix a6 = new DenseMatrix(a4, a4);
        for (int a7 = 0; a7 < a4; ++a7) {
            a5.set(a7 + 1, FunctionOps.factorial(2 * a7));
            for (int a8 = 0; a8 < a4; ++a8) {
                a6.set(a7 + 1, a8 + 1, Math.pow(a2[a8], 2 * a7));
            }
        }
        Vector a9 = new LinearSystemSolver(a3).solve(a6).getParticularSolution(a5);
        return a9.toArray();
    }

    @Override
    public double[] getEvaluationPoints() {
        return Arrays.copyOf(this.new, this.new.length);
    }
}

