/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.linearsystem;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import dev.nm.algebra.linear.matrix.doubles.factorization.svd.SVD;
import dev.nm.algebra.linear.matrix.doubles.linearsystem.Kernel;
import dev.nm.algebra.linear.matrix.doubles.linearsystem.LSProblem;
import dev.nm.algebra.linear.matrix.doubles.linearsystem.LUSolver;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.PrecisionUtils;
import dev.nm.number.DoubleUtils;
import java.util.Collections;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LinearSystemSolver {
    private final double new;

    public Solution solve(final Matrix A0) {
        return new Solution(){
            Kernel nullspace;
            boolean isFullRank;
            Matrix A;
            Matrix T;
            SVD svd;
            List<Vector> basis;
            Matrix U;

            @Override
            public Vector getParticularSolution(Vector b2) {
                Vector a2;
                Vector a3 = b2;
                if (this.svd != null) {
                    a3 = this.svd.Ut().multiply(b2);
                }
                ArgumentAssertion.assertEqual(this.A.nRows(), a3.size(), "A's dimension ", "b's length (after row reduction)");
                if (this.isFullRank) {
                    LUSolver a4 = new LUSolver();
                    a2 = a4.solve(new LSProblem(this.A, a3));
                } else if (MatrixPropertyUtils.isZero(a3, LinearSystemSolver.this.new)) {
                    a2 = new DenseVector(this.A.nCols()).ZERO();
                } else {
                    a2 = this.T.multiply(a3);
                    for (int a5 = 1; a5 <= a2.size(); ++a5) {
                        if (!MatrixPropertyUtils.isZero(this.U.getRow(a5), LinearSystemSolver.this.new) || DoubleUtils.compare(a2.get(a5), 0.0, LinearSystemSolver.this.new) == 0) continue;
                        throw new NoSolution("the system of linear equation is inconsistent");
                    }
                    if (this.A.nCols() > a2.size()) {
                        Vector a6 = a2;
                        a2 = new DenseVector(this.A.nCols());
                        block1: for (int a7 = 1; a7 <= a6.size(); ++a7) {
                            Vector a8 = this.U.getRow(a7);
                            for (int a9 = a7; a9 <= this.A.nCols(); ++a9) {
                                if (!DoubleUtils.equal(a8.get(a9), 1.0, LinearSystemSolver.this.new)) continue;
                                a2.set(a9, a6.get(a7));
                                continue block1;
                            }
                        }
                    }
                }
                return a2;
            }
            {
                1 a3;
                a3.A = a3.A0;
                a3.svd = null;
                if (a3.A0.nRows() > a3.A0.nCols()) {
                    a3.svd = new SVD(a3.A, true, PrecisionUtils.autoEpsilon(a3.A), SVD.Method.GOLUB_KAHAN);
                    a3.A = a3.svd.D().multiply(a3.svd.V().t());
                }
                ArgumentAssertion.assertTrue(a3.A.nRows() <= a3.A.nCols(), "Ax = b is an over-determined system. Please consider using the OLS method", new Object[0]);
                a3.nullspace = new Kernel(a3.A, Kernel.Method.GAUSSIAN_JORDAN_ELIMINATION, a3.LinearSystemSolver.this.new);
                a3.isFullRank = a3.nullspace.isZero();
                a3.basis = a3.nullspace.basis();
                a3.T = a3.nullspace.T();
                a3.U = a3.nullspace.U();
            }

            @Override
            public List<Vector> getHomogeneousSoln() {
                return Collections.unmodifiableList(this.basis);
            }
        };
    }

    public LinearSystemSolver(double epsilon) {
        this.new = epsilon;
    }

    public static interface Solution {
        public List<Vector> getHomogeneousSoln();

        public Vector getParticularSolution(Vector var1);
    }

    public static class NoSolution
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public NoSolution(String msg) {
            super(msg);
        }
    }
}

