/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.factorization.diagonalization;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.factorization.diagonalization.BiDiagonalization;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.BidiagonalMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.householder.HouseholderInPlace;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.datastructure.DimensionCheck;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BiDiagonalizationByHouseholder
implements BiDiagonalization {
    private final int void;
    private final HouseholderInPlace if;
    private final int new;

    @Override
    public BidiagonalMatrix B() {
        BidiagonalMatrix a2 = new BidiagonalMatrix(this.new, BidiagonalMatrix.BidiagonalMatrixType.UPPER);
        for (int a3 = 1; a3 <= this.new - 1; ++a3) {
            a2.set(a3, a3, this.if.get(a3, a3));
            a2.set(a3, a3 + 1, this.if.get(a3, a3 + 1));
        }
        a2.set(this.new, this.new, this.if.get(this.new, this.new));
        return a2;
    }

    @Override
    public Matrix V() {
        return this.if.Vt().t();
    }

    @Override
    public Matrix U() {
        return this.if.U().t();
    }

    public BiDiagonalizationByHouseholder(Matrix A2) {
        ArgumentAssertion.assertTrue(DimensionCheck.isTall(A2), "Bi-diagonalization applies only to tall matrices", new Object[0]);
        this.void = A2.nRows();
        this.new = A2.nCols();
        this.if = new HouseholderInPlace(A2);
        if (this.new == 1) {
            this.if.generateAndReflectColumns(1, this.new, 1, this.void);
        } else {
            int a2 = this.new - 2;
            for (int a3 = 1; a3 <= a2; ++a3) {
                this.if.generateAndReflectColumns(a3, this.new, a3, this.void);
                this.if.generateAndReflectRows(a3, this.void, a3 + 1, this.new);
            }
            this.if.generateAndReflectColumns(this.new - 1, this.new, this.new - 1, this.void);
            if (this.void != this.new) {
                this.if.generateAndReflectColumns(this.new, this.new, this.new, this.void);
            }
        }
    }
}

