/*
 * Decompiled with CFR 0.152.
 */
package tech.nmfin.portfoliooptimization;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.CongruentMatrix;
import dev.nm.algebra.linear.vector.doubles.Vector;

public class PortfolioUtils {
    public static double getSharpeRatio(Vector weights, Vector mu, Matrix sigma, double benchmarkRate) {
        double a2 = PortfolioUtils.getPortfolioReturns(weights, mu);
        double a3 = PortfolioUtils.getPortfolioVariance(weights, sigma);
        double a4 = (a2 - benchmarkRate) / Math.sqrt(a3);
        return a4;
    }

    public static double getPortfolioVariance(Vector weights, Matrix sigma) {
        DenseMatrix a2 = new DenseMatrix(weights);
        CongruentMatrix a3 = new CongruentMatrix((Matrix)a2, sigma);
        return a3.get(1, 1);
    }

    public static double getPortfolioReturns(Vector weights, Vector mu) {
        return mu.innerProduct(weights);
    }

    private PortfolioUtils() {
        PortfolioUtils a2;
    }
}

