/*
 * Decompiled with CFR 0.152.
 */
package tech.nmfin.portfoliooptimization;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.stat.covariance.LedoitWolf2004;
import dev.nm.stat.descriptive.covariance.SampleCovariance;
import org.joda.time.Interval;
import tech.nmfin.returns.Returns;

public interface PortfolioOptimizationAlgorithm {
    public Vector getOptimalWeights(Matrix var1, Vector var2, SymbolLookup var3, Interval var4) throws Exception;

    public static interface SymbolLookup {
        public String getSymbol(int var1);

        public int getIndex(String var1);
    }

    public static class SampleCovarianceEstimator
    implements CovarianceEstimator {
        @Override
        public Matrix getCovariances(Matrix returns, SymbolLookup symbolLookup, Interval interval) {
            SampleCovariance a2 = new SampleCovariance(returns);
            return a2;
        }
    }

    public static interface CovarianceEstimator {
        default public Matrix getCovariances(Matrix returns, SymbolLookup symbolLookup, Interval interval) {
            Matrix a2 = new LedoitWolf2004().compute(returns).getCovarianceMatrix();
            return a2;
        }
    }

    public static class SampleMeanEstimator
    implements MeanEstimator {
        @Override
        public Vector getMeans(Matrix returns, SymbolLookup symbolLookup, Interval interval) {
            Vector a2 = Returns.getMeanReturns(returns);
            return a2;
        }
    }

    public static interface MeanEstimator {
        default public Vector getMeans(Matrix returns, SymbolLookup symbolLookup, Interval interval) {
            return new SampleMeanEstimator().getMeans(returns, symbolLookup, interval);
        }
    }
}

