/*
 * Decompiled with CFR 0.152.
 */
package org.teneighty.heap;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.teneighty.heap.AbstractLinkedHeap;
import org.teneighty.heap.Heap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PairingHeap<TKey, TValue>
extends AbstractLinkedHeap<TKey, TValue>
implements Heap<TKey, TValue>,
Iterable<Heap.Entry<TKey, TValue>>,
Serializable {
    private transient PairingHeapEntry<TKey, TValue> minimum;
    private static final long serialVersionUID = 2323423L;
    private Comparator<? super TKey> comp;
    private transient int size;
    private volatile transient int mod_count;
    private MergeStrategy merge_type;
    private transient AbstractLinkedHeap.HeapReference source;

    @Override
    public void clear() {
        this.minimum = null;
        this.size = 0;
        ++this.mod_count;
        this.source.clearHeap();
        this.source = new AbstractLinkedHeap.HeapReference(this);
    }

    public MergeStrategy getMergeStrategy() {
        return this.merge_type;
    }

    @Override
    public Heap.Entry<TKey, TValue> getMinimum() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.minimum;
    }

    @Override
    public Iterator<Heap.Entry<TKey, TValue>> iterator() {
        return new EntryIterator();
    }

    @Override
    public void delete(Heap.Entry<TKey, TValue> e2) throws IllegalArgumentException, NullPointerException {
        if (!this.holdsEntry(e2)) {
            throw new IllegalArgumentException();
        }
        PairingHeapEntry a2 = (PairingHeapEntry)e2;
        if (a2 == this.minimum) {
            this.extractMinimum();
            return;
        }
        a2.is_infinite = true;
        this.relink(a2);
        this.extractMinimum();
        a2.is_infinite = false;
    }

    public PairingHeap(Comparator<? super TKey> comp, MergeStrategy ms) throws NullPointerException {
        if (ms == null) {
            throw new NullPointerException();
        }
        this.comp = comp;
        this.source = new AbstractLinkedHeap.HeapReference(this);
        this.size = 0;
        this.mod_count = 0;
        this.minimum = null;
        this.merge_type = ms;
    }

    private PairingHeapEntry<TKey, TValue> merge(PairingHeapEntry<TKey, TValue> a2) {
        PairingHeap a3;
        switch (a3.merge_type) {
            case TWO: {
                return a3.twoPassMerge(a2);
            }
            case MULTI: {
                return a3.multiPassMerge(a2);
            }
        }
        throw new InternalError();
    }

    public void setMergeStrategy(MergeStrategy strat) {
        this.merge_type = strat;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    private PairingHeapEntry<TKey, TValue> join(PairingHeapEntry<TKey, TValue> a2, PairingHeapEntry<TKey, TValue> a3) {
        PairingHeap a4;
        if (a3 == null) {
            return a2;
        }
        if (a4.compare(a2, a3) >= 0) {
            a3.previous = a2.previous;
            a2.previous = a3;
            a2.next = a3.child;
            if (a2.next != null) {
                a2.next.previous = a2;
            }
            a3.child = a2;
            return a3;
        }
        a3.previous = a2;
        a2.next = a3.next;
        if (a2.next != null) {
            a2.next.previous = a2;
        }
        a3.next = a2.child;
        if (a3.next != null) {
            a3.next.previous = a3;
        }
        a2.child = a3;
        return a2;
    }

    public PairingHeap(MergeStrategy strat) throws NullPointerException {
        this(null, strat);
    }

    public PairingHeap() {
        this(null, MergeStrategy.MULTI);
    }

    private void writeObject(ObjectOutputStream a2) throws IOException {
        PairingHeap a3;
        a2.defaultWriteObject();
        a2.writeInt(a3.size);
        EntryIterator a4 = a3.new EntryIterator();
        Heap.Entry a5 = null;
        while (a4.hasNext()) {
            try {
                a5 = (Heap.Entry)a4.next();
                a2.writeObject(a5.getKey());
                a2.writeObject(a5.getValue());
            }
            catch (ConcurrentModificationException a6) {
                throw (IOException)new IOException("Heap structure changed during serialization").initCause(a6);
            }
        }
    }

    @Override
    public Comparator<? super TKey> getComparator() {
        return this.comp;
    }

    private void readObject(ObjectInputStream a2) throws IOException, ClassNotFoundException {
        PairingHeap a3;
        a2.defaultReadObject();
        int a4 = a2.readInt();
        a3.source = new AbstractLinkedHeap.HeapReference(a3);
        for (int a5 = 0; a5 < a4; ++a5) {
            Object a6 = a2.readObject();
            Object a7 = a2.readObject();
            a3.insert(a6, a7);
        }
    }

    @Override
    public void decreaseKey(Heap.Entry<TKey, TValue> e2, TKey key) throws IllegalArgumentException, ClassCastException, NullPointerException {
        if (!this.holdsEntry(e2)) {
            throw new IllegalArgumentException();
        }
        PairingHeapEntry a2 = (PairingHeapEntry)e2;
        if (this.compareKeys(a2.getKey(), key) < 0) {
            throw new IllegalArgumentException();
        }
        a2.setKey(key);
        this.relink(a2);
        ++this.mod_count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void union(Heap<TKey, TValue> other) throws ClassCastException, NullPointerException, IllegalArgumentException {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            throw new IllegalArgumentException();
        }
        if (other.getClass().equals(PairingHeap.class)) {
            try {
                PairingHeap a2 = (PairingHeap)other;
                this.minimum = this.join(this.minimum, a2.minimum);
                this.size += a2.size;
                ++this.mod_count;
                a2.source.setHeap(this);
                a2.source = new AbstractLinkedHeap.HeapReference(a2);
            }
            finally {
                other.clear();
            }
        } else {
            throw new ClassCastException();
        }
    }

    @Override
    public boolean holdsEntry(Heap.Entry<TKey, TValue> e2) throws NullPointerException {
        if (e2 == null) {
            throw new NullPointerException();
        }
        if (!e2.getClass().equals(PairingHeapEntry.class)) {
            return false;
        }
        PairingHeapEntry a2 = (PairingHeapEntry)e2;
        return a2.isContainedBy(this);
    }

    @Override
    public Heap.Entry<TKey, TValue> extractMinimum() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        PairingHeapEntry<TKey, TValue> a2 = this.minimum;
        if (this.size == 1) {
            this.minimum = null;
        } else {
            this.minimum = this.merge(this.minimum.child);
            this.minimum.previous = null;
            this.minimum.next = null;
        }
        --this.size;
        ++this.mod_count;
        a2.clearSourceReference();
        a2.child = null;
        a2.next = null;
        a2.previous = null;
        return a2;
    }

    private void relink(PairingHeapEntry<TKey, TValue> a2) {
        PairingHeap a3;
        if (a2 != a3.minimum) {
            if (a2.next != null) {
                a2.next.previous = a2.previous;
            }
            if (a2.previous.child == a2) {
                a2.previous.child = a2.next;
            } else {
                a2.previous.next = a2.next;
            }
            a2.next = null;
            a3.minimum = a3.join(a2, a3.minimum);
            a3.minimum.previous = null;
            a3.minimum.next = null;
        }
    }

    private PairingHeapEntry<TKey, TValue> multiPassMerge(PairingHeapEntry<TKey, TValue> a2) {
        LinkedList<PairingHeapEntry<TKey, TValue>> a3 = new LinkedList<PairingHeapEntry<TKey, TValue>>();
        if (a2.next == null) {
            return a2;
        }
        PairingHeapEntry<TKey, TValue> a4 = a2;
        while (a4 != null) {
            a3.addFirst(a4);
            a4.previous.next = null;
            a4 = a4.next;
        }
        PairingHeapEntry a5 = null;
        PairingHeapEntry a6 = null;
        PairingHeapEntry<TKey, TValue> a7 = null;
        while (a3.size() > 1) {
            PairingHeap a8;
            a5 = (PairingHeapEntry)a3.removeFirst();
            a6 = (PairingHeapEntry)a3.removeFirst();
            a7 = a5.next == null ? a8.join(a5, a6) : a8.join(a6, a5);
            a3.addLast(a7);
        }
        return (PairingHeapEntry)a3.removeFirst();
    }

    @Override
    public Heap.Entry<TKey, TValue> insert(TKey key, TValue value) throws ClassCastException, NullPointerException {
        PairingHeapEntry<TKey, TValue> a2 = new PairingHeapEntry<TKey, TValue>(key, value, this.source);
        if (this.isEmpty()) {
            this.minimum = a2;
        } else {
            this.minimum = this.join(this.minimum, a2);
            this.minimum.previous = null;
        }
        ++this.size;
        ++this.mod_count;
        return a2;
    }

    private PairingHeapEntry<TKey, TValue> twoPassMerge(PairingHeapEntry<TKey, TValue> a2) {
        PairingHeap a3;
        if (a2.next == null) {
            return a2;
        }
        ArrayList<PairingHeapEntry<TKey, TValue>> a4 = new ArrayList<PairingHeapEntry<TKey, TValue>>();
        PairingHeapEntry<TKey, TValue> a5 = a2;
        int a6 = 0;
        while (a5 != null) {
            a4.add(a5);
            a5.previous.next = null;
            a5 = a5.next;
            ++a6;
        }
        int a7 = 0;
        PairingHeapEntry a8 = null;
        PairingHeapEntry a9 = null;
        a7 = 0;
        while (a7 + 1 < a6) {
            a8 = (PairingHeapEntry)a4.get(a7);
            a9 = (PairingHeapEntry)a4.get(a7 + 1);
            a4.set(a7, a3.join(a8, a9));
            a7 += 2;
        }
        int a10 = a7 - 2;
        if (a10 == a6 - 3) {
            a8 = (PairingHeapEntry)a4.get(a10);
            a9 = (PairingHeapEntry)a4.get(a10 + 2);
            a4.set(a10, a3.join(a8, a9));
        }
        while (a10 >= 2) {
            a8 = (PairingHeapEntry)a4.get(a10);
            a9 = (PairingHeapEntry)a4.get(a10 - 2);
            a4.set(a10 - 2, a3.join(a9, a8));
            a10 -= 2;
        }
        return (PairingHeapEntry)a4.get(0);
    }

    public PairingHeap(Comparator<? super TKey> comp) {
        this(comp, MergeStrategy.MULTI);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MergeStrategy implements Serializable
    {
        TWO("Two pass strategy"),
        MULTI("Multi pass strategy");

        private String desc;
        private static final long serialVersionUID = 40234L;

        private MergeStrategy(String a2) {
            MergeStrategy a3;
            a3.desc = a2;
        }

        public String getDescription() {
            return this.desc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PairingHeapEntry<TKey, TValue>
    extends AbstractLinkedHeap.AbstractLinkedHeapEntry<TKey, TValue>
    implements Heap.Entry<TKey, TValue>,
    Serializable {
        transient PairingHeapEntry<TKey, TValue> previous;
        private static final long serialVersionUID = 2984L;
        transient PairingHeapEntry<TKey, TValue> next;
        transient PairingHeapEntry<TKey, TValue> child;

        PairingHeapEntry(TKey a2, TValue a3, AbstractLinkedHeap.HeapReference a4) {
            super(a2, a3, a4);
            PairingHeapEntry a5;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    implements Iterator<Heap.Entry<TKey, TValue>> {
        private int my_mod_count;
        private PairingHeapEntry<TKey, TValue> next;

        @Override
        public boolean hasNext() {
            if (this.my_mod_count != PairingHeap.this.mod_count) {
                throw new ConcurrentModificationException();
            }
            return this.next != null;
        }

        @Override
        public Heap.Entry<TKey, TValue> next() throws NoSuchElementException, ConcurrentModificationException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            PairingHeapEntry a2 = this.next;
            this.next = this.getEulerianSuccessor(a2);
            return a2;
        }

        private PairingHeapEntry<TKey, TValue> getEulerianSuccessor(PairingHeapEntry<TKey, TValue> a2) {
            if (a2.child != null) {
                return a2.child;
            }
            if (a2.next != null) {
                return a2.next;
            }
            EntryIterator a3;
            while (a2 != a3.PairingHeap.this.minimum) {
                if (a2.previous.child == a2) {
                    if (a2.previous.next != null) {
                        return a2.previous.next;
                    }
                    a2 = a2.previous;
                    continue;
                }
                a2 = a2.previous;
            }
            return null;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        EntryIterator() {
            EntryIterator a2;
            a2.my_mod_count = a2.PairingHeap.this.mod_count;
            a2.next = a2.PairingHeap.this.minimum;
        }
    }
}

