/*
 * Decompiled with CFR 0.152.
 */
package org.teneighty.heap;

import java.lang.ref.WeakReference;
import org.teneighty.heap.AbstractHeap;
import org.teneighty.heap.Heap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLinkedHeap<TKey, TValue>
extends AbstractHeap<TKey, TValue>
implements Heap<TKey, TValue>,
Iterable<Heap.Entry<TKey, TValue>> {
    protected AbstractLinkedHeap() {
    }

    @Override
    protected int compare(Heap.Entry<TKey, TValue> node1, Heap.Entry<TKey, TValue> node2) throws ClassCastException, NullPointerException {
        AbstractLinkedHeapEntry a2 = (AbstractLinkedHeapEntry)node1;
        AbstractLinkedHeapEntry a3 = (AbstractLinkedHeapEntry)node2;
        if (a2.is_infinite && a3.is_infinite) {
            return 0;
        }
        if (a2.is_infinite) {
            return -1;
        }
        if (a3.is_infinite) {
            return 1;
        }
        return super.compare(node1, node2);
    }

    protected static final class HeapReference {
        private WeakReference<AbstractLinkedHeap> heap_ref;

        protected final void clearHeap() {
            this.heap_ref.clear();
        }

        protected HeapReference(AbstractLinkedHeap fh) {
            this.heap_ref = new WeakReference<AbstractLinkedHeap>(fh);
        }

        protected final void setHeap(AbstractLinkedHeap heap) throws NullPointerException {
            if (heap == null) {
                throw new NullPointerException();
            }
            this.clearHeap();
            this.heap_ref = new WeakReference<AbstractLinkedHeap>(heap);
        }

        protected final AbstractLinkedHeap getHeap() {
            return (AbstractLinkedHeap)this.heap_ref.get();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class AbstractLinkedHeapEntry<K, V>
    extends AbstractHeap.AbstractHeapEntry<K, V> {
        protected volatile transient boolean is_infinite;
        private volatile transient HeapReference containing_ref;

        protected final boolean isContainedBy(AbstractLinkedHeap<K, V> heap) throws NullPointerException {
            if (heap == null) {
                throw new NullPointerException();
            }
            if (this.containing_ref == null) {
                return false;
            }
            return this.containing_ref.getHeap() == heap;
        }

        protected final void clearSourceReference() {
            this.containing_ref = null;
        }

        protected AbstractLinkedHeapEntry(K key, V value, HeapReference ref) {
            super(key, value);
            this.containing_ref = ref;
            this.is_infinite = false;
        }
    }
}

