/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.io.IOException;
import java.io.Writer;

public class FormatUtils {
    private static final double LOG_10 = Math.log(10.0);

    public static void appendUnpaddedInteger(StringBuffer arg0, int arg1) {
        try {
            FormatUtils.appendUnpaddedInteger((Appendable)arg0, arg1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void appendUnpaddedInteger(StringBuffer arg0, long arg1) {
        try {
            FormatUtils.appendUnpaddedInteger((Appendable)arg0, arg1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private FormatUtils() {
        FormatUtils a2;
    }

    static int parseTwoDigits(CharSequence a2, int a3) {
        int n = a2.charAt(a3) - 48;
        return (n << 3) + (n << 1) + a2.charAt(a3 + 1) - 48;
    }

    public static int calculateDigitCount(long arg0) {
        if (arg0 < 0L) {
            if (arg0 != Long.MIN_VALUE) {
                return FormatUtils.calculateDigitCount(-arg0) + 1;
            }
            return 20;
        }
        return arg0 < 10L ? 1 : (arg0 < 100L ? 2 : (arg0 < 1000L ? 3 : (arg0 < 10000L ? 4 : (int)(Math.log(arg0) / LOG_10) + 1)));
    }

    public static void appendUnpaddedInteger(Appendable arg0, int arg1) throws IOException {
        if (arg1 < 0) {
            arg0.append('-');
            if (arg1 != Integer.MIN_VALUE) {
                arg1 = -arg1;
            } else {
                arg0.append("2147483648");
                return;
            }
        }
        if (arg1 < 10) {
            arg0.append((char)(arg1 + 48));
        } else if (arg1 < 100) {
            int n = (arg1 + 1) * 0xCCCCCC >> 27;
            arg0.append((char)(n + 48));
            arg0.append((char)(arg1 - (n << 3) - (n << 1) + 48));
        } else {
            arg0.append(Integer.toString(arg1));
        }
    }

    public static void appendUnpaddedInteger(Appendable arg0, long arg1) throws IOException {
        int n = (int)arg1;
        if ((long)n == arg1) {
            FormatUtils.appendUnpaddedInteger(arg0, n);
        } else {
            arg0.append(Long.toString(arg1));
        }
    }

    static String createErrorMessage(String a2, int a3) {
        int n = a3 + 32;
        String string = a2.length() <= n + 3 ? a2 : a2.substring(0, n).concat("...");
        if (a3 <= 0) {
            return "Invalid format: \"" + string + '\"';
        }
        if (a3 >= a2.length()) {
            return "Invalid format: \"" + string + "\" is too short";
        }
        return "Invalid format: \"" + string + "\" is malformed at \"" + string.substring(a3) + '\"';
    }

    public static void appendPaddedInteger(Appendable arg0, int arg1, int arg2) throws IOException {
        if (arg1 < 0) {
            arg0.append('-');
            if (arg1 != Integer.MIN_VALUE) {
                arg1 = -arg1;
            } else {
                while (arg2 > 10) {
                    arg0.append('0');
                    --arg2;
                }
                arg0.append("2147483648");
                return;
            }
        }
        if (arg1 < 10) {
            while (arg2 > 1) {
                arg0.append('0');
                --arg2;
            }
            arg0.append((char)(arg1 + 48));
        } else if (arg1 < 100) {
            while (arg2 > 2) {
                arg0.append('0');
                --arg2;
            }
            int n = (arg1 + 1) * 0xCCCCCC >> 27;
            arg0.append((char)(n + 48));
            arg0.append((char)(arg1 - (n << 3) - (n << 1) + 48));
        } else {
            int n = arg1 < 1000 ? 3 : (arg1 < 10000 ? 4 : (int)(Math.log(arg1) / LOG_10) + 1);
            while (arg2 > n) {
                arg0.append('0');
                --arg2;
            }
            arg0.append(Integer.toString(arg1));
        }
    }

    public static void writeUnpaddedInteger(Writer arg0, long arg1) throws IOException {
        int n = (int)arg1;
        if ((long)n == arg1) {
            FormatUtils.writeUnpaddedInteger(arg0, n);
        } else {
            arg0.write(Long.toString(arg1));
        }
    }

    public static void writePaddedInteger(Writer arg0, int arg1, int arg2) throws IOException {
        if (arg1 < 0) {
            arg0.write(45);
            if (arg1 != Integer.MIN_VALUE) {
                arg1 = -arg1;
            } else {
                while (arg2 > 10) {
                    arg0.write(48);
                    --arg2;
                }
                arg0.write("2147483648");
                return;
            }
        }
        if (arg1 < 10) {
            while (arg2 > 1) {
                arg0.write(48);
                --arg2;
            }
            arg0.write(arg1 + 48);
        } else if (arg1 < 100) {
            while (arg2 > 2) {
                arg0.write(48);
                --arg2;
            }
            int n = (arg1 + 1) * 0xCCCCCC >> 27;
            arg0.write(n + 48);
            arg0.write(arg1 - (n << 3) - (n << 1) + 48);
        } else {
            int n = arg1 < 1000 ? 3 : (arg1 < 10000 ? 4 : (int)(Math.log(arg1) / LOG_10) + 1);
            while (arg2 > n) {
                arg0.write(48);
                --arg2;
            }
            arg0.write(Integer.toString(arg1));
        }
    }

    public static void appendPaddedInteger(Appendable arg0, long arg1, int arg2) throws IOException {
        int n = (int)arg1;
        if ((long)n == arg1) {
            FormatUtils.appendPaddedInteger(arg0, n, arg2);
        } else if (arg2 <= 19) {
            arg0.append(Long.toString(arg1));
        } else {
            if (arg1 < 0L) {
                arg0.append('-');
                if (arg1 != Long.MIN_VALUE) {
                    arg1 = -arg1;
                } else {
                    while (arg2 > 19) {
                        arg0.append('0');
                        --arg2;
                    }
                    arg0.append("9223372036854775808");
                    return;
                }
            }
            int n2 = (int)(Math.log(arg1) / LOG_10) + 1;
            while (arg2 > n2) {
                arg0.append('0');
                --arg2;
            }
            arg0.append(Long.toString(arg1));
        }
    }

    public static void writePaddedInteger(Writer arg0, long arg1, int arg2) throws IOException {
        int n = (int)arg1;
        if ((long)n == arg1) {
            FormatUtils.writePaddedInteger(arg0, n, arg2);
        } else if (arg2 <= 19) {
            arg0.write(Long.toString(arg1));
        } else {
            if (arg1 < 0L) {
                arg0.write(45);
                if (arg1 != Long.MIN_VALUE) {
                    arg1 = -arg1;
                } else {
                    while (arg2 > 19) {
                        arg0.write(48);
                        --arg2;
                    }
                    arg0.write("9223372036854775808");
                    return;
                }
            }
            int n2 = (int)(Math.log(arg1) / LOG_10) + 1;
            while (arg2 > n2) {
                arg0.write(48);
                --arg2;
            }
            arg0.write(Long.toString(arg1));
        }
    }

    public static void appendPaddedInteger(StringBuffer arg0, long arg1, int arg2) {
        try {
            FormatUtils.appendPaddedInteger((Appendable)arg0, arg1, arg2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void writeUnpaddedInteger(Writer arg0, int arg1) throws IOException {
        if (arg1 < 0) {
            arg0.write(45);
            if (arg1 != Integer.MIN_VALUE) {
                arg1 = -arg1;
            } else {
                arg0.write("2147483648");
                return;
            }
        }
        if (arg1 < 10) {
            arg0.write(arg1 + 48);
        } else if (arg1 < 100) {
            int n = (arg1 + 1) * 0xCCCCCC >> 27;
            arg0.write(n + 48);
            arg0.write(arg1 - (n << 3) - (n << 1) + 48);
        } else {
            arg0.write(Integer.toString(arg1));
        }
    }

    public static void appendPaddedInteger(StringBuffer arg0, int arg1, int arg2) {
        try {
            FormatUtils.appendPaddedInteger((Appendable)arg0, arg1, arg2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

