/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import java.io.Serializable;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.field.FieldUtils;

public final class MillisDurationField
extends DurationField
implements Serializable {
    public static final DurationField INSTANCE = new MillisDurationField();
    private static final long serialVersionUID = 2656707858124633367L;

    public long add(long arg0, int arg1) {
        return FieldUtils.safeAdd(arg0, (long)arg1);
    }

    public int compareTo(DurationField arg0) {
        long l2 = arg0.getUnitMillis();
        long l3 = this.getUnitMillis();
        if (l3 == l2) {
            return 0;
        }
        if (l3 < l2) {
            return -1;
        }
        return 1;
    }

    public String getName() {
        return "millis";
    }

    public long add(long arg0, long arg1) {
        return FieldUtils.safeAdd(arg0, arg1);
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public long getMillis(long arg0, long arg1) {
        return arg0;
    }

    public long getValueAsLong(long arg0) {
        return arg0;
    }

    public final long getUnitMillis() {
        return 1L;
    }

    private MillisDurationField() {
        MillisDurationField a2;
    }

    public int getValue(long arg0, long arg1) {
        return FieldUtils.safeToInt(arg0);
    }

    public long getMillis(int arg0) {
        return arg0;
    }

    public int hashCode() {
        return (int)this.getUnitMillis();
    }

    public long getMillis(int arg0, long arg1) {
        return arg0;
    }

    public long getMillis(long arg0) {
        return arg0;
    }

    public final boolean isPrecise() {
        return true;
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof MillisDurationField) {
            return this.getUnitMillis() == ((MillisDurationField)arg0).getUnitMillis();
        }
        return false;
    }

    public int getDifference(long arg0, long arg1) {
        return FieldUtils.safeToInt(FieldUtils.safeSubtract(arg0, arg1));
    }

    public long getDifferenceAsLong(long arg0, long arg1) {
        return FieldUtils.safeSubtract(arg0, arg1);
    }

    public int getValue(long arg0) {
        return FieldUtils.safeToInt(arg0);
    }

    public long getValueAsLong(long arg0, long arg1) {
        return arg0;
    }

    public boolean isSupported() {
        return true;
    }

    public DurationFieldType getType() {
        return DurationFieldType.millis();
    }

    public String toString() {
        return "DurationField[millis]";
    }
}

