/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.field.BaseDateTimeField;
import org.joda.time.field.BaseDurationField;
import org.joda.time.field.FieldUtils;

public abstract class ImpreciseDateTimeField
extends BaseDateTimeField {
    final long iUnitMillis;
    private static final long serialVersionUID = 7190739608550251860L;
    private final DurationField iDurationField;

    public abstract long add(long var1, int var3);

    public int getDifference(long arg0, long arg1) {
        return FieldUtils.safeToInt(this.getDifferenceAsLong(arg0, arg1));
    }

    public long getDifferenceAsLong(long arg0, long arg1) {
        if (arg0 < arg1) {
            return -this.getDifferenceAsLong(arg1, arg0);
        }
        long l2 = (arg0 - arg1) / this.iUnitMillis;
        if (this.add(arg1, l2) < arg0) {
            while (this.add(arg1, ++l2) <= arg0) {
            }
            --l2;
        } else if (this.add(arg1, l2) > arg0) {
            while (this.add(arg1, --l2) > arg0) {
            }
        }
        return l2;
    }

    public ImpreciseDateTimeField(DateTimeFieldType arg0, long arg1) {
        super(arg0);
        this.iUnitMillis = arg1;
        this.iDurationField = new LinkedDurationField(arg0.getDurationType());
    }

    public final DurationField getDurationField() {
        return this.iDurationField;
    }

    public abstract long add(long var1, long var3);

    public abstract int get(long var1);

    public abstract long set(long var1, int var3);

    protected final long getDurationUnitMillis() {
        return this.iUnitMillis;
    }

    public abstract long roundFloor(long var1);

    public abstract DurationField getRangeDurationField();

    private final class LinkedDurationField
    extends BaseDurationField {
        private static final long serialVersionUID = -203813474600094134L;

        public long add(long arg0, long arg1) {
            return ImpreciseDateTimeField.this.add(arg0, arg1);
        }

        public long getDifferenceAsLong(long arg0, long arg1) {
            return ImpreciseDateTimeField.this.getDifferenceAsLong(arg0, arg1);
        }

        LinkedDurationField(DurationFieldType a3) {
            LinkedDurationField a4;
            super(a3);
        }

        public long getValueAsLong(long arg0, long arg1) {
            return ImpreciseDateTimeField.this.getDifferenceAsLong(arg1 + arg0, arg1);
        }

        public long getMillis(long arg0, long arg1) {
            return ImpreciseDateTimeField.this.add(arg1, arg0) - arg1;
        }

        public long getUnitMillis() {
            return ImpreciseDateTimeField.this.iUnitMillis;
        }

        public boolean isPrecise() {
            return false;
        }

        public int getValue(long arg0, long arg1) {
            return ImpreciseDateTimeField.this.getDifference(arg1 + arg0, arg1);
        }

        public long getMillis(int arg0, long arg1) {
            return ImpreciseDateTimeField.this.add(arg1, arg0) - arg1;
        }

        public long add(long arg0, int arg1) {
            return ImpreciseDateTimeField.this.add(arg0, arg1);
        }

        public int getDifference(long arg0, long arg1) {
            return ImpreciseDateTimeField.this.getDifference(arg0, arg1);
        }
    }
}

