/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.convert;

import org.joda.time.JodaTimePermission;
import org.joda.time.convert.CalendarConverter;
import org.joda.time.convert.Converter;
import org.joda.time.convert.ConverterSet;
import org.joda.time.convert.DateConverter;
import org.joda.time.convert.DurationConverter;
import org.joda.time.convert.InstantConverter;
import org.joda.time.convert.IntervalConverter;
import org.joda.time.convert.LongConverter;
import org.joda.time.convert.NullConverter;
import org.joda.time.convert.PartialConverter;
import org.joda.time.convert.PeriodConverter;
import org.joda.time.convert.ReadableDurationConverter;
import org.joda.time.convert.ReadableInstantConverter;
import org.joda.time.convert.ReadableIntervalConverter;
import org.joda.time.convert.ReadablePartialConverter;
import org.joda.time.convert.ReadablePeriodConverter;
import org.joda.time.convert.StringConverter;

public final class ConverterManager {
    private ConverterSet iDurationConverters;
    private static ConverterManager INSTANCE;
    private ConverterSet iPartialConverters;
    private ConverterSet iPeriodConverters;
    private ConverterSet iInstantConverters = new ConverterSet(new Converter[]{ReadableInstantConverter.INSTANCE, StringConverter.INSTANCE, CalendarConverter.INSTANCE, DateConverter.INSTANCE, LongConverter.INSTANCE, NullConverter.INSTANCE});
    private ConverterSet iIntervalConverters;

    public PeriodConverter removePeriodConverter(PeriodConverter arg0) throws SecurityException {
        this.checkAlterPeriodConverters();
        if (arg0 == null) {
            return null;
        }
        Converter[] converterArray = new PeriodConverter[1];
        this.iPeriodConverters = this.iPeriodConverters.remove(arg0, converterArray);
        return converterArray[0];
    }

    public PartialConverter removePartialConverter(PartialConverter arg0) throws SecurityException {
        this.checkAlterPartialConverters();
        if (arg0 == null) {
            return null;
        }
        Converter[] converterArray = new PartialConverter[1];
        this.iPartialConverters = this.iPartialConverters.remove(arg0, converterArray);
        return converterArray[0];
    }

    private void checkAlterPartialConverters() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new JodaTimePermission("ConverterManager.alterPartialConverters"));
        }
    }

    public IntervalConverter[] getIntervalConverters() {
        ConverterSet converterSet = this.iIntervalConverters;
        Converter[] converterArray = new IntervalConverter[converterSet.size()];
        converterSet.copyInto(converterArray);
        return converterArray;
    }

    private void checkAlterIntervalConverters() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new JodaTimePermission("ConverterManager.alterIntervalConverters"));
        }
    }

    public IntervalConverter addIntervalConverter(IntervalConverter arg0) throws SecurityException {
        this.checkAlterIntervalConverters();
        if (arg0 == null) {
            return null;
        }
        Converter[] converterArray = new IntervalConverter[1];
        this.iIntervalConverters = this.iIntervalConverters.add(arg0, converterArray);
        return converterArray[0];
    }

    protected ConverterManager() {
        this.iPartialConverters = new ConverterSet(new Converter[]{ReadablePartialConverter.INSTANCE, ReadableInstantConverter.INSTANCE, StringConverter.INSTANCE, CalendarConverter.INSTANCE, DateConverter.INSTANCE, LongConverter.INSTANCE, NullConverter.INSTANCE});
        this.iDurationConverters = new ConverterSet(new Converter[]{ReadableDurationConverter.INSTANCE, ReadableIntervalConverter.INSTANCE, StringConverter.INSTANCE, LongConverter.INSTANCE, NullConverter.INSTANCE});
        this.iPeriodConverters = new ConverterSet(new Converter[]{ReadableDurationConverter.INSTANCE, ReadablePeriodConverter.INSTANCE, ReadableIntervalConverter.INSTANCE, StringConverter.INSTANCE, NullConverter.INSTANCE});
        this.iIntervalConverters = new ConverterSet(new Converter[]{ReadableIntervalConverter.INSTANCE, StringConverter.INSTANCE, NullConverter.INSTANCE});
    }

    public PeriodConverter addPeriodConverter(PeriodConverter arg0) throws SecurityException {
        this.checkAlterPeriodConverters();
        if (arg0 == null) {
            return null;
        }
        Converter[] converterArray = new PeriodConverter[1];
        this.iPeriodConverters = this.iPeriodConverters.add(arg0, converterArray);
        return converterArray[0];
    }

    public DurationConverter getDurationConverter(Object arg0) {
        DurationConverter durationConverter = (DurationConverter)this.iDurationConverters.select(arg0 == null ? null : arg0.getClass());
        if (durationConverter != null) {
            return durationConverter;
        }
        throw new IllegalArgumentException("No duration converter found for type: " + (arg0 == null ? "null" : arg0.getClass().getName()));
    }

    public DurationConverter[] getDurationConverters() {
        ConverterSet converterSet = this.iDurationConverters;
        Converter[] converterArray = new DurationConverter[converterSet.size()];
        converterSet.copyInto(converterArray);
        return converterArray;
    }

    public DurationConverter removeDurationConverter(DurationConverter arg0) throws SecurityException {
        this.checkAlterDurationConverters();
        if (arg0 == null) {
            return null;
        }
        Converter[] converterArray = new DurationConverter[1];
        this.iDurationConverters = this.iDurationConverters.remove(arg0, converterArray);
        return converterArray[0];
    }

    public InstantConverter getInstantConverter(Object arg0) {
        InstantConverter instantConverter = (InstantConverter)this.iInstantConverters.select(arg0 == null ? null : arg0.getClass());
        if (instantConverter != null) {
            return instantConverter;
        }
        throw new IllegalArgumentException("No instant converter found for type: " + (arg0 == null ? "null" : arg0.getClass().getName()));
    }

    public InstantConverter[] getInstantConverters() {
        ConverterSet converterSet = this.iInstantConverters;
        Converter[] converterArray = new InstantConverter[converterSet.size()];
        converterSet.copyInto(converterArray);
        return converterArray;
    }

    public IntervalConverter getIntervalConverter(Object arg0) {
        IntervalConverter intervalConverter = (IntervalConverter)this.iIntervalConverters.select(arg0 == null ? null : arg0.getClass());
        if (intervalConverter != null) {
            return intervalConverter;
        }
        throw new IllegalArgumentException("No interval converter found for type: " + (arg0 == null ? "null" : arg0.getClass().getName()));
    }

    private void checkAlterDurationConverters() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new JodaTimePermission("ConverterManager.alterDurationConverters"));
        }
    }

    public PeriodConverter getPeriodConverter(Object arg0) {
        PeriodConverter periodConverter = (PeriodConverter)this.iPeriodConverters.select(arg0 == null ? null : arg0.getClass());
        if (periodConverter != null) {
            return periodConverter;
        }
        throw new IllegalArgumentException("No period converter found for type: " + (arg0 == null ? "null" : arg0.getClass().getName()));
    }

    private void checkAlterInstantConverters() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new JodaTimePermission("ConverterManager.alterInstantConverters"));
        }
    }

    private void checkAlterPeriodConverters() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new JodaTimePermission("ConverterManager.alterPeriodConverters"));
        }
    }

    public PartialConverter getPartialConverter(Object arg0) {
        PartialConverter partialConverter = (PartialConverter)this.iPartialConverters.select(arg0 == null ? null : arg0.getClass());
        if (partialConverter != null) {
            return partialConverter;
        }
        throw new IllegalArgumentException("No partial converter found for type: " + (arg0 == null ? "null" : arg0.getClass().getName()));
    }

    public InstantConverter addInstantConverter(InstantConverter arg0) throws SecurityException {
        this.checkAlterInstantConverters();
        if (arg0 == null) {
            return null;
        }
        Converter[] converterArray = new InstantConverter[1];
        this.iInstantConverters = this.iInstantConverters.add(arg0, converterArray);
        return converterArray[0];
    }

    public PeriodConverter[] getPeriodConverters() {
        ConverterSet converterSet = this.iPeriodConverters;
        Converter[] converterArray = new PeriodConverter[converterSet.size()];
        converterSet.copyInto(converterArray);
        return converterArray;
    }

    public IntervalConverter removeIntervalConverter(IntervalConverter arg0) throws SecurityException {
        this.checkAlterIntervalConverters();
        if (arg0 == null) {
            return null;
        }
        Converter[] converterArray = new IntervalConverter[1];
        this.iIntervalConverters = this.iIntervalConverters.remove(arg0, converterArray);
        return converterArray[0];
    }

    public PartialConverter[] getPartialConverters() {
        ConverterSet converterSet = this.iPartialConverters;
        Converter[] converterArray = new PartialConverter[converterSet.size()];
        converterSet.copyInto(converterArray);
        return converterArray;
    }

    public static ConverterManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ConverterManager();
        }
        return INSTANCE;
    }

    public DurationConverter addDurationConverter(DurationConverter arg0) throws SecurityException {
        this.checkAlterDurationConverters();
        if (arg0 == null) {
            return null;
        }
        Converter[] converterArray = new DurationConverter[1];
        this.iDurationConverters = this.iDurationConverters.add(arg0, converterArray);
        return converterArray[0];
    }

    public String toString() {
        return "ConverterManager[" + this.iInstantConverters.size() + " instant," + this.iPartialConverters.size() + " partial," + this.iDurationConverters.size() + " duration," + this.iPeriodConverters.size() + " period," + this.iIntervalConverters.size() + " interval]";
    }

    public InstantConverter removeInstantConverter(InstantConverter arg0) throws SecurityException {
        this.checkAlterInstantConverters();
        if (arg0 == null) {
            return null;
        }
        Converter[] converterArray = new InstantConverter[1];
        this.iInstantConverters = this.iInstantConverters.remove(arg0, converterArray);
        return converterArray[0];
    }

    public PartialConverter addPartialConverter(PartialConverter arg0) throws SecurityException {
        this.checkAlterPartialConverters();
        if (arg0 == null) {
            return null;
        }
        Converter[] converterArray = new PartialConverter[1];
        this.iPartialConverters = this.iPartialConverters.add(arg0, converterArray);
        return converterArray[0];
    }
}

