/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.chrono.BasicChronology;
import org.joda.time.chrono.BasicMonthOfYearDateTimeField;
import org.joda.time.chrono.BasicSingleEraDateTimeField;
import org.joda.time.chrono.LimitChronology;
import org.joda.time.chrono.ZonedChronology;

public final class IslamicChronology
extends BasicChronology {
    private static final long MILLIS_PER_LONG_YEAR = 30672000000L;
    private static final long MILLIS_PER_MONTH = 2551440384L;
    private static final long MILLIS_PER_CYCLE = 918518400000L;
    private final LeapYearPatternType iLeapYears;
    private static final long serialVersionUID = -3663823829888L;
    public static final LeapYearPatternType LEAP_YEAR_15_BASED;
    private static final DateTimeField ERA_FIELD;
    private static final long MILLIS_YEAR_1 = -42521587200000L;
    private static final int CYCLE = 30;
    private static final long MILLIS_PER_MONTH_PAIR = 5097600000L;
    private static final int LONG_MONTH_LENGTH = 30;
    public static final LeapYearPatternType LEAP_YEAR_INDIAN;
    public static final LeapYearPatternType LEAP_YEAR_16_BASED;
    private static final IslamicChronology INSTANCE_UTC;
    private static final int MONTH_PAIR_LENGTH = 59;
    private static final int SHORT_MONTH_LENGTH = 29;
    private static final ConcurrentHashMap<DateTimeZone, IslamicChronology[]> cCache;
    public static final int AH = 1;
    private static final long MILLIS_PER_SHORT_YEAR = 30585600000L;
    private static final int MIN_YEAR = -292269337;
    private static final long MILLIS_PER_LONG_MONTH = 2592000000L;
    public static final LeapYearPatternType LEAP_YEAR_HABASH_AL_HASIB;
    private static final int MAX_YEAR = 292271022;
    private static final long MILLIS_PER_YEAR = 30617280288L;

    long getTotalMillisByYearMonth(int a2, int a3) {
        if (--a3 % 2 == 1) {
            return (long)(a3 /= 2) * 5097600000L + 2592000000L;
        }
        return (long)(a3 /= 2) * 5097600000L;
    }

    int getDayOfMonth(long a2) {
        IslamicChronology a3;
        int n = a3.getDayOfYear(a2) - 1;
        if (n == 354) {
            return 30;
        }
        return n % 59 % 30 + 1;
    }

    long getAverageMillisPerYear() {
        return 30617280288L;
    }

    boolean isLeapYear(int a2) {
        IslamicChronology a3;
        return a3.iLeapYears.isLeapYear(a2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IslamicChronology getInstance(DateTimeZone arg0, LeapYearPatternType arg1) {
        IslamicChronology islamicChronology;
        IslamicChronology[] islamicChronologyArray;
        IslamicChronology[] islamicChronologyArray2;
        if (arg0 == null) {
            arg0 = DateTimeZone.getDefault();
        }
        if ((islamicChronologyArray2 = cCache.get(arg0)) == null && (islamicChronologyArray = cCache.putIfAbsent(arg0, islamicChronologyArray2 = new IslamicChronology[4])) != null) {
            islamicChronologyArray2 = islamicChronologyArray;
        }
        if ((islamicChronology = islamicChronologyArray2[arg1.index]) != null) return islamicChronology;
        islamicChronologyArray = islamicChronologyArray2;
        synchronized (islamicChronologyArray2) {
            islamicChronology = islamicChronologyArray2[arg1.index];
            if (islamicChronology != null) return islamicChronology;
            if (arg0 == DateTimeZone.UTC) {
                islamicChronology = new IslamicChronology(null, null, arg1);
                DateTime dateTime = new DateTime(1, 1, 1, 0, 0, 0, 0, islamicChronology);
                islamicChronology = new IslamicChronology((Chronology)LimitChronology.getInstance(islamicChronology, dateTime, null), null, arg1);
            } else {
                islamicChronology = IslamicChronology.getInstance(DateTimeZone.UTC, arg1);
                islamicChronology = new IslamicChronology((Chronology)ZonedChronology.getInstance(islamicChronology, arg0), null, arg1);
            }
            islamicChronologyArray2[arg1.index] = islamicChronology;
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return islamicChronology;
        }
    }

    long calculateFirstDayOfYearMillis(int a2) {
        if (a2 > 292271022) {
            throw new ArithmeticException("Year is too large: " + a2 + " > " + 292271022);
        }
        if (a2 < -292269337) {
            throw new ArithmeticException("Year is too small: " + a2 + " < " + -292269337);
        }
        long l2 = --a2 / 30;
        long l3 = -42521587200000L + l2 * 918518400000L;
        int n = a2 % 30 + 1;
        for (int i2 = 1; i2 < n; ++i2) {
            IslamicChronology a3;
            l3 += a3.isLeapYear(i2) ? 30672000000L : 30585600000L;
        }
        return l3;
    }

    int getDaysInYearMonth(int a2, int a3) {
        IslamicChronology a4;
        if (a3 == 12 && a4.isLeapYear(a2)) {
            return 30;
        }
        return --a3 % 2 == 0 ? 30 : 29;
    }

    public static IslamicChronology getInstance() {
        return IslamicChronology.getInstance(DateTimeZone.getDefault(), LEAP_YEAR_16_BASED);
    }

    int getDaysInMonthMax(int a2) {
        if (a2 == 12) {
            return 30;
        }
        return --a2 % 2 == 0 ? 30 : 29;
    }

    static {
        ERA_FIELD = new BasicSingleEraDateTimeField("AH");
        LEAP_YEAR_15_BASED = new LeapYearPatternType(0, 623158436);
        LEAP_YEAR_16_BASED = new LeapYearPatternType(1, 623191204);
        LEAP_YEAR_INDIAN = new LeapYearPatternType(2, 690562340);
        LEAP_YEAR_HABASH_AL_HASIB = new LeapYearPatternType(3, 0x9292925);
        cCache = new ConcurrentHashMap();
        INSTANCE_UTC = IslamicChronology.getInstance(DateTimeZone.UTC);
    }

    int getDaysInYear(int a2) {
        IslamicChronology a3;
        return a3.isLeapYear(a2) ? 355 : 354;
    }

    IslamicChronology(Chronology a2, Object a3, LeapYearPatternType a4) {
        super(a2, a3, 4);
        IslamicChronology a5;
        a5.iLeapYears = a4;
    }

    int getYear(long a2) {
        IslamicChronology a3;
        long l2;
        long l3 = a2 - -42521587200000L;
        long l4 = l3 / 918518400000L;
        int n = (int)(l4 * 30L + 1L);
        long l5 = l2 = a3.isLeapYear(n) ? 30672000000L : 30585600000L;
        for (long i2 = l3 % 918518400000L; i2 >= l2; i2 -= l2) {
            l2 = a3.isLeapYear(++n) ? 30672000000L : 30585600000L;
        }
        return n;
    }

    long getYearDifference(long a2, long a3) {
        IslamicChronology a4;
        int n = a4.getYear(a2);
        int n2 = a4.getYear(a3);
        long l2 = a2 - a4.getYearMillis(n);
        long l3 = a3 - a4.getYearMillis(n2);
        int n3 = n - n2;
        if (l2 < l3) {
            --n3;
        }
        return n3;
    }

    long getAverageMillisPerMonth() {
        return 2551440384L;
    }

    public boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (arg0 instanceof IslamicChronology) {
            IslamicChronology islamicChronology = (IslamicChronology)arg0;
            return this.getLeapYearPatternType().index == islamicChronology.getLeapYearPatternType().index && super.equals(arg0);
        }
        return false;
    }

    private Object readResolve() {
        IslamicChronology a2;
        Chronology chronology = a2.getBase();
        return chronology == null ? IslamicChronology.getInstanceUTC() : IslamicChronology.getInstance(chronology.getZone());
    }

    int getDaysInMonthMax() {
        return 30;
    }

    public LeapYearPatternType getLeapYearPatternType() {
        return this.iLeapYears;
    }

    int getMinYear() {
        return 1;
    }

    public static IslamicChronology getInstanceUTC() {
        return INSTANCE_UTC;
    }

    long getAverageMillisPerYearDividedByTwo() {
        return 15308640144L;
    }

    public static IslamicChronology getInstance(DateTimeZone arg0) {
        return IslamicChronology.getInstance(arg0, LEAP_YEAR_16_BASED);
    }

    protected void assemble(AssembledChronology.Fields arg0) {
        if (this.getBase() == null) {
            super.assemble(arg0);
            arg0.era = ERA_FIELD;
            arg0.monthOfYear = new BasicMonthOfYearDateTimeField(this, 12);
            arg0.months = arg0.monthOfYear.getDurationField();
        }
    }

    int getMaxYear() {
        return 292271022;
    }

    public Chronology withUTC() {
        return INSTANCE_UTC;
    }

    long getApproxMillisAtEpochDividedByTwo() {
        return 21260793600000L;
    }

    public int hashCode() {
        return super.hashCode() * 13 + this.getLeapYearPatternType().hashCode();
    }

    long setYear(long a2, int a3) {
        IslamicChronology a4;
        int n = a4.getYear(a2);
        int n2 = a4.getDayOfYear(a2, n);
        int n3 = a4.getMillisOfDay(a2);
        if (n2 > 354 && !a4.isLeapYear(a3)) {
            --n2;
        }
        a2 = a4.getYearMonthDayMillis(a3, 1, n2);
        return a2 += (long)n3;
    }

    public Chronology withZone(DateTimeZone arg0) {
        if (arg0 == null) {
            arg0 = DateTimeZone.getDefault();
        }
        if (arg0 == this.getZone()) {
            return this;
        }
        return IslamicChronology.getInstance(arg0);
    }

    int getDaysInYearMax() {
        return 355;
    }

    int getMonthOfYear(long a2, int a3) {
        IslamicChronology a4;
        int n = (int)((a2 - a4.getYearMillis(a3)) / 86400000L);
        if (n == 354) {
            return 12;
        }
        return n * 2 / 59 + 1;
    }

    public static class LeapYearPatternType
    implements Serializable {
        final byte index;
        private static final long serialVersionUID = 26581275372698L;
        final int pattern;

        LeapYearPatternType(int a2, int a3) {
            LeapYearPatternType a4;
            a4.index = (byte)a2;
            a4.pattern = a3;
        }

        boolean isLeapYear(int a2) {
            LeapYearPatternType a3;
            int n = 1 << a2 % 30;
            return (a3.pattern & n) > 0;
        }

        private Object readResolve() {
            LeapYearPatternType a2;
            switch (a2.index) {
                case 0: {
                    return LEAP_YEAR_15_BASED;
                }
                case 1: {
                    return LEAP_YEAR_16_BASED;
                }
                case 2: {
                    return LEAP_YEAR_INDIAN;
                }
                case 3: {
                    return LEAP_YEAR_HABASH_AL_HASIB;
                }
            }
            return a2;
        }

        public int hashCode() {
            return this.index;
        }

        public boolean equals(Object arg0) {
            if (arg0 instanceof LeapYearPatternType) {
                return this.index == ((LeapYearPatternType)arg0).index;
            }
            return false;
        }
    }
}

