/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.Locale;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.chrono.BasicChronology;
import org.joda.time.chrono.GJLocaleSymbols;
import org.joda.time.field.BaseDateTimeField;
import org.joda.time.field.FieldUtils;
import org.joda.time.field.UnsupportedDurationField;

final class GJEraDateTimeField
extends BaseDateTimeField {
    private static final long serialVersionUID = 4240986525305515528L;
    private final BasicChronology iChronology;

    public DurationField getDurationField() {
        return UnsupportedDurationField.getInstance(DurationFieldType.eras());
    }

    public boolean isLenient() {
        return false;
    }

    public DurationField getRangeDurationField() {
        return null;
    }

    public long roundCeiling(long arg0) {
        if (this.get(arg0) == 0) {
            return this.iChronology.setYear(0L, 1);
        }
        return Long.MAX_VALUE;
    }

    public long roundHalfEven(long arg0) {
        return this.roundFloor(arg0);
    }

    GJEraDateTimeField(BasicChronology a2) {
        super(DateTimeFieldType.era());
        GJEraDateTimeField a3;
        a3.iChronology = a2;
    }

    public long roundHalfCeiling(long arg0) {
        return this.roundFloor(arg0);
    }

    public int getMinimumValue() {
        return 0;
    }

    public long set(long arg0, int arg1) {
        FieldUtils.verifyValueBounds(this, arg1, 0, 1);
        int n = this.get(arg0);
        if (n != arg1) {
            int n2 = this.iChronology.getYear(arg0);
            return this.iChronology.setYear(arg0, -n2);
        }
        return arg0;
    }

    public long roundHalfFloor(long arg0) {
        return this.roundFloor(arg0);
    }

    private Object readResolve() {
        GJEraDateTimeField a2;
        return a2.iChronology.era();
    }

    public long set(long arg0, String arg1, Locale arg2) {
        return this.set(arg0, GJLocaleSymbols.forLocale(arg2).eraTextToValue(arg1));
    }

    public int getMaximumValue() {
        return 1;
    }

    public int get(long arg0) {
        if (this.iChronology.getYear(arg0) <= 0) {
            return 0;
        }
        return 1;
    }

    public int getMaximumTextLength(Locale arg0) {
        return GJLocaleSymbols.forLocale(arg0).getEraMaxTextLength();
    }

    public String getAsText(int arg0, Locale arg1) {
        return GJLocaleSymbols.forLocale(arg1).eraValueToText(arg0);
    }

    public long roundFloor(long arg0) {
        if (this.get(arg0) == 1) {
            return this.iChronology.setYear(0L, 1);
        }
        return Long.MIN_VALUE;
    }
}

