/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.chrono.BasicFixedMonthChronology;
import org.joda.time.chrono.BasicMonthOfYearDateTimeField;
import org.joda.time.chrono.BasicSingleEraDateTimeField;
import org.joda.time.chrono.LimitChronology;
import org.joda.time.chrono.ZonedChronology;
import org.joda.time.field.SkipDateTimeField;

public final class EthiopicChronology
extends BasicFixedMonthChronology {
    private static final ConcurrentHashMap<DateTimeZone, EthiopicChronology[]> cCache;
    public static final int EE = 1;
    private static final EthiopicChronology INSTANCE_UTC;
    private static final DateTimeField ERA_FIELD;
    private static final int MIN_YEAR = -292269337;
    private static final long serialVersionUID = -5972804258688333942L;
    private static final int MAX_YEAR = 292272984;

    int getMaxYear() {
        return 292272984;
    }

    long calculateFirstDayOfYearMillis(int a2) {
        int n;
        int n2 = a2 - 1963;
        if (n2 <= 0) {
            n = n2 + 3 >> 2;
        } else {
            EthiopicChronology a3;
            n = n2 >> 2;
            if (!a3.isLeapYear(a2)) {
                ++n;
            }
        }
        long l2 = ((long)n2 * 365L + (long)n) * 86400000L;
        return l2 + 21859200000L;
    }

    public static EthiopicChronology getInstanceUTC() {
        return INSTANCE_UTC;
    }

    public Chronology withZone(DateTimeZone arg0) {
        if (arg0 == null) {
            arg0 = DateTimeZone.getDefault();
        }
        if (arg0 == this.getZone()) {
            return this;
        }
        return EthiopicChronology.getInstance(arg0);
    }

    int getMinYear() {
        return -292269337;
    }

    public static EthiopicChronology getInstance() {
        return EthiopicChronology.getInstance(DateTimeZone.getDefault(), 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EthiopicChronology getInstance(DateTimeZone arg0, int arg1) {
        EthiopicChronology ethiopicChronology;
        EthiopicChronology[] ethiopicChronologyArray;
        EthiopicChronology[] ethiopicChronologyArray2;
        if (arg0 == null) {
            arg0 = DateTimeZone.getDefault();
        }
        if ((ethiopicChronologyArray2 = cCache.get(arg0)) == null && (ethiopicChronologyArray = cCache.putIfAbsent(arg0, ethiopicChronologyArray2 = new EthiopicChronology[7])) != null) {
            ethiopicChronologyArray2 = ethiopicChronologyArray;
        }
        try {
            ethiopicChronology = ethiopicChronologyArray2[arg1 - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid min days in first week: " + arg1);
        }
        if (ethiopicChronology != null) return ethiopicChronology;
        ethiopicChronologyArray = ethiopicChronologyArray2;
        synchronized (ethiopicChronologyArray2) {
            ethiopicChronology = ethiopicChronologyArray2[arg1 - 1];
            if (ethiopicChronology != null) return ethiopicChronology;
            if (arg0 == DateTimeZone.UTC) {
                ethiopicChronology = new EthiopicChronology(null, null, arg1);
                DateTime dateTime = new DateTime(1, 1, 1, 0, 0, 0, 0, ethiopicChronology);
                ethiopicChronology = new EthiopicChronology(LimitChronology.getInstance(ethiopicChronology, dateTime, null), null, arg1);
            } else {
                ethiopicChronology = EthiopicChronology.getInstance(DateTimeZone.UTC, arg1);
                ethiopicChronology = new EthiopicChronology(ZonedChronology.getInstance(ethiopicChronology, arg0), null, arg1);
            }
            ethiopicChronologyArray2[arg1 - 1] = ethiopicChronology;
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return ethiopicChronology;
        }
    }

    boolean isLeapDay(long a2) {
        EthiopicChronology a3;
        return a3.dayOfMonth().get(a2) == 6 && a3.monthOfYear().isLeap(a2);
    }

    public static EthiopicChronology getInstance(DateTimeZone arg0) {
        return EthiopicChronology.getInstance(arg0, 4);
    }

    static {
        ERA_FIELD = new BasicSingleEraDateTimeField("EE");
        cCache = new ConcurrentHashMap();
        INSTANCE_UTC = EthiopicChronology.getInstance(DateTimeZone.UTC);
    }

    protected void assemble(AssembledChronology.Fields arg0) {
        if (this.getBase() == null) {
            super.assemble(arg0);
            arg0.year = new SkipDateTimeField(this, arg0.year);
            arg0.weekyear = new SkipDateTimeField(this, arg0.weekyear);
            arg0.era = ERA_FIELD;
            arg0.monthOfYear = new BasicMonthOfYearDateTimeField(this, 13);
            arg0.months = arg0.monthOfYear.getDurationField();
        }
    }

    long getApproxMillisAtEpochDividedByTwo() {
        return 30962844000000L;
    }

    EthiopicChronology(Chronology a2, Object a3, int a4) {
        super(a2, a3, a4);
        EthiopicChronology a5;
    }

    private Object readResolve() {
        EthiopicChronology a2;
        Chronology chronology = a2.getBase();
        return chronology == null ? EthiopicChronology.getInstance(DateTimeZone.UTC, a2.getMinimumDaysInFirstWeek()) : EthiopicChronology.getInstance(chronology.getZone(), a2.getMinimumDaysInFirstWeek());
    }

    public Chronology withUTC() {
        return INSTANCE_UTC;
    }
}

