/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationFieldType;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.chrono.BasicSingleEraDateTimeField;
import org.joda.time.chrono.GJChronology;
import org.joda.time.chrono.LimitChronology;
import org.joda.time.field.DelegatedDateTimeField;
import org.joda.time.field.DividedDateTimeField;
import org.joda.time.field.OffsetDateTimeField;
import org.joda.time.field.RemainderDateTimeField;
import org.joda.time.field.SkipUndoDateTimeField;
import org.joda.time.field.UnsupportedDurationField;

public final class BuddhistChronology
extends AssembledChronology {
    private static final ConcurrentHashMap<DateTimeZone, BuddhistChronology> cCache;
    private static final BuddhistChronology INSTANCE_UTC;
    private static final DateTimeField ERA_FIELD;
    private static final int BUDDHIST_OFFSET = 543;
    public static final int BE = 1;
    private static final long serialVersionUID = -3474595157769370126L;

    public static BuddhistChronology getInstanceUTC() {
        return INSTANCE_UTC;
    }

    public static BuddhistChronology getInstance(DateTimeZone arg0) {
        BuddhistChronology buddhistChronology;
        if (arg0 == null) {
            arg0 = DateTimeZone.getDefault();
        }
        if ((buddhistChronology = cCache.get(arg0)) == null) {
            buddhistChronology = new BuddhistChronology(GJChronology.getInstance(arg0, null), null);
            DateTime dateTime = new DateTime(1, 1, 1, 0, 0, 0, 0, buddhistChronology);
            BuddhistChronology buddhistChronology2 = cCache.putIfAbsent(arg0, buddhistChronology = new BuddhistChronology(LimitChronology.getInstance(buddhistChronology, dateTime, null), ""));
            if (buddhistChronology2 != null) {
                buddhistChronology = buddhistChronology2;
            }
        }
        return buddhistChronology;
    }

    public Chronology withZone(DateTimeZone arg0) {
        if (arg0 == null) {
            arg0 = DateTimeZone.getDefault();
        }
        if (arg0 == this.getZone()) {
            return this;
        }
        return BuddhistChronology.getInstance(arg0);
    }

    protected void assemble(AssembledChronology.Fields arg0) {
        if (this.getParam() == null) {
            arg0.eras = UnsupportedDurationField.getInstance(DurationFieldType.eras());
            DateTimeField dateTimeField = arg0.year;
            arg0.year = new OffsetDateTimeField((DateTimeField)new SkipUndoDateTimeField(this, dateTimeField), 543);
            dateTimeField = arg0.yearOfEra;
            arg0.yearOfEra = new DelegatedDateTimeField(arg0.year, arg0.eras, DateTimeFieldType.yearOfEra());
            dateTimeField = arg0.weekyear;
            arg0.weekyear = new OffsetDateTimeField((DateTimeField)new SkipUndoDateTimeField(this, dateTimeField), 543);
            dateTimeField = new OffsetDateTimeField(arg0.yearOfEra, 99);
            arg0.centuryOfEra = new DividedDateTimeField(dateTimeField, arg0.eras, DateTimeFieldType.centuryOfEra(), 100);
            arg0.centuries = arg0.centuryOfEra.getDurationField();
            dateTimeField = new RemainderDateTimeField((DividedDateTimeField)arg0.centuryOfEra);
            arg0.yearOfCentury = new OffsetDateTimeField(dateTimeField, DateTimeFieldType.yearOfCentury(), 1);
            dateTimeField = new RemainderDateTimeField(arg0.weekyear, arg0.centuries, DateTimeFieldType.weekyearOfCentury(), 100);
            arg0.weekyearOfCentury = new OffsetDateTimeField(dateTimeField, DateTimeFieldType.weekyearOfCentury(), 1);
            arg0.era = ERA_FIELD;
        }
    }

    private BuddhistChronology(Chronology a2, Object a3) {
        super(a2, a3);
        BuddhistChronology a4;
    }

    public String toString() {
        String string = "BuddhistChronology";
        DateTimeZone dateTimeZone = this.getZone();
        if (dateTimeZone != null) {
            string = string + '[' + dateTimeZone.getID() + ']';
        }
        return string;
    }

    static {
        ERA_FIELD = new BasicSingleEraDateTimeField("BE");
        cCache = new ConcurrentHashMap();
        INSTANCE_UTC = BuddhistChronology.getInstance(DateTimeZone.UTC);
    }

    public int hashCode() {
        return "Buddhist".hashCode() * 11 + this.getZone().hashCode();
    }

    public static BuddhistChronology getInstance() {
        return BuddhistChronology.getInstance(DateTimeZone.getDefault());
    }

    public Chronology withUTC() {
        return INSTANCE_UTC;
    }

    private Object readResolve() {
        BuddhistChronology a2;
        Chronology chronology = a2.getBase();
        return chronology == null ? BuddhistChronology.getInstanceUTC() : BuddhistChronology.getInstance(chronology.getZone());
    }

    public boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (arg0 instanceof BuddhistChronology) {
            BuddhistChronology buddhistChronology = (BuddhistChronology)arg0;
            return this.getZone().equals(buddhistChronology.getZone());
        }
        return false;
    }
}

