/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DurationField;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.BasicChronology;
import org.joda.time.field.FieldUtils;
import org.joda.time.field.ImpreciseDateTimeField;

class BasicMonthOfYearDateTimeField
extends ImpreciseDateTimeField {
    private static final long serialVersionUID = -8258715387168736L;
    private final int iLeapMonth;
    private final int iMax;
    private final BasicChronology iChronology;
    private static final int MIN = 1;

    public long roundFloor(long arg0) {
        int n = this.iChronology.getYear(arg0);
        int n2 = this.iChronology.getMonthOfYear(arg0, n);
        return this.iChronology.getYearMonthMillis(n, n2);
    }

    public long add(long arg0, long arg1) {
        int n;
        int n2;
        long l2;
        int n3 = (int)arg1;
        if ((long)n3 == arg1) {
            return this.add(arg0, n3);
        }
        long l3 = this.iChronology.getMillisOfDay(arg0);
        int n4 = this.iChronology.getYear(arg0);
        int n5 = this.iChronology.getMonthOfYear(arg0, n4);
        long l4 = (long)(n5 - 1) + arg1;
        if (l4 >= 0L) {
            l2 = (long)n4 + l4 / (long)this.iMax;
            l4 = l4 % (long)this.iMax + 1L;
        } else {
            l2 = (long)n4 + l4 / (long)this.iMax - 1L;
            n2 = (int)((l4 = Math.abs(l4)) % (long)this.iMax);
            if (n2 == 0) {
                n2 = this.iMax;
            }
            if ((l4 = (long)(this.iMax - n2 + 1)) == 1L) {
                ++l2;
            }
        }
        if (l2 < (long)this.iChronology.getMinYear() || l2 > (long)this.iChronology.getMaxYear()) {
            throw new IllegalArgumentException("Magnitude of add amount is too large: " + arg1);
        }
        n2 = (int)l2;
        int n6 = (int)l4;
        int n7 = this.iChronology.getDayOfMonth(arg0, n4, n5);
        if (n7 > (n = this.iChronology.getDaysInYearMonth(n2, n6))) {
            n7 = n;
        }
        long l5 = this.iChronology.getYearMonthDayMillis(n2, n6, n7);
        return l5 + l3;
    }

    public long addWrapField(long arg0, int arg1) {
        return this.set(arg0, FieldUtils.getWrappedValue(this.get(arg0), arg1, 1, this.iMax));
    }

    public int get(long arg0) {
        return this.iChronology.getMonthOfYear(arg0);
    }

    public long getDifferenceAsLong(long arg0, long arg1) {
        long l2;
        long l3;
        int n;
        if (arg0 < arg1) {
            return -this.getDifference(arg1, arg0);
        }
        int n2 = this.iChronology.getYear(arg0);
        int n3 = this.iChronology.getMonthOfYear(arg0, n2);
        int n4 = this.iChronology.getYear(arg1);
        int n5 = this.iChronology.getMonthOfYear(arg1, n4);
        long l4 = (long)(n2 - n4) * (long)this.iMax + (long)n3 - (long)n5;
        int n6 = this.iChronology.getDayOfMonth(arg0, n2, n3);
        if (n6 == this.iChronology.getDaysInYearMonth(n2, n3) && (n = this.iChronology.getDayOfMonth(arg1, n4, n5)) > n6) {
            arg1 = this.iChronology.dayOfMonth().set(arg1, n6);
        }
        if ((l3 = arg0 - this.iChronology.getYearMonthMillis(n2, n3)) < (l2 = arg1 - this.iChronology.getYearMonthMillis(n4, n5))) {
            --l4;
        }
        return l4;
    }

    public long add(long arg0, int arg1) {
        int n;
        int n2;
        if (arg1 == 0) {
            return arg0;
        }
        long l2 = this.iChronology.getMillisOfDay(arg0);
        int n3 = this.iChronology.getYear(arg0);
        int n4 = this.iChronology.getMonthOfYear(arg0, n3);
        int n5 = n4 - 1 + arg1;
        if (n5 >= 0) {
            n2 = n3 + n5 / this.iMax;
            n5 = n5 % this.iMax + 1;
        } else {
            n2 = n3 + n5 / this.iMax - 1;
            n = (n5 = Math.abs(n5)) % this.iMax;
            if (n == 0) {
                n = this.iMax;
            }
            if ((n5 = this.iMax - n + 1) == 1) {
                ++n2;
            }
        }
        n = this.iChronology.getDayOfMonth(arg0, n3, n4);
        int n6 = this.iChronology.getDaysInYearMonth(n2, n5);
        if (n > n6) {
            n = n6;
        }
        long l3 = this.iChronology.getYearMonthDayMillis(n2, n5, n);
        return l3 + l2;
    }

    public int getMinimumValue() {
        return 1;
    }

    public DurationField getRangeDurationField() {
        return this.iChronology.years();
    }

    public long remainder(long arg0) {
        return arg0 - this.roundFloor(arg0);
    }

    public boolean isLenient() {
        return false;
    }

    public DurationField getLeapDurationField() {
        return this.iChronology.days();
    }

    public int[] add(ReadablePartial arg0, int arg1, int[] arg2, int arg3) {
        if (arg3 == 0) {
            return arg2;
        }
        if (arg0.size() > 0 && arg0.getFieldType(0).equals(DateTimeFieldType.monthOfYear()) && arg1 == 0) {
            int n = arg2[0] - 1;
            int n2 = (n + arg3 % 12 + 12) % 12 + 1;
            return this.set(arg0, 0, arg2, n2);
        }
        if (DateTimeUtils.isContiguous(arg0)) {
            long l2 = 0L;
            int n = arg0.size();
            for (int i2 = 0; i2 < n; ++i2) {
                l2 = arg0.getFieldType(i2).getField(this.iChronology).set(l2, arg2[i2]);
            }
            l2 = this.add(l2, arg3);
            return this.iChronology.get(arg0, l2);
        }
        return super.add(arg0, arg1, arg2, arg3);
    }

    public long set(long arg0, int arg1) {
        FieldUtils.verifyValueBounds(this, arg1, 1, this.iMax);
        int n = this.iChronology.getYear(arg0);
        int n2 = this.iChronology.getDayOfMonth(arg0, n);
        int n3 = this.iChronology.getDaysInYearMonth(n, arg1);
        if (n2 > n3) {
            n2 = n3;
        }
        return this.iChronology.getYearMonthDayMillis(n, arg1, n2) + (long)this.iChronology.getMillisOfDay(arg0);
    }

    private Object readResolve() {
        BasicMonthOfYearDateTimeField a2;
        return a2.iChronology.monthOfYear();
    }

    public int getLeapAmount(long arg0) {
        return this.isLeap(arg0) ? 1 : 0;
    }

    public boolean isLeap(long arg0) {
        int n = this.iChronology.getYear(arg0);
        if (this.iChronology.isLeapYear(n)) {
            return this.iChronology.getMonthOfYear(arg0, n) == this.iLeapMonth;
        }
        return false;
    }

    public int getMaximumValue() {
        return this.iMax;
    }

    BasicMonthOfYearDateTimeField(BasicChronology a2, int a3) {
        super(DateTimeFieldType.monthOfYear(), a2.getAverageMillisPerMonth());
        BasicMonthOfYearDateTimeField a4;
        a4.iChronology = a2;
        a4.iMax = a4.iChronology.getMaxMonth();
        a4.iLeapMonth = a3;
    }
}

