/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.base;

import java.io.Serializable;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.base.AbstractDuration;
import org.joda.time.convert.ConverterManager;
import org.joda.time.convert.DurationConverter;
import org.joda.time.field.FieldUtils;

public abstract class BaseDuration
extends AbstractDuration
implements ReadableDuration,
Serializable {
    private volatile long iMillis;
    private static final long serialVersionUID = 2581698638990L;

    protected BaseDuration(ReadableInstant arg0, ReadableInstant arg1) {
        if (arg0 == arg1) {
            this.iMillis = 0L;
        } else {
            long l2 = DateTimeUtils.getInstantMillis(arg0);
            long l3 = DateTimeUtils.getInstantMillis(arg1);
            this.iMillis = FieldUtils.safeSubtract(l3, l2);
        }
    }

    public Interval toIntervalFrom(ReadableInstant arg0) {
        return new Interval(arg0, this);
    }

    protected void setMillis(long arg0) {
        this.iMillis = arg0;
    }

    public Period toPeriodFrom(ReadableInstant arg0) {
        return new Period(arg0, this);
    }

    public Period toPeriod(Chronology arg0) {
        return new Period(this.getMillis(), arg0);
    }

    public Period toPeriod(PeriodType arg0, Chronology arg1) {
        return new Period(this.getMillis(), arg0, arg1);
    }

    public long getMillis() {
        return this.iMillis;
    }

    protected BaseDuration(long arg0, long arg1) {
        this.iMillis = FieldUtils.safeSubtract(arg1, arg0);
    }

    public Period toPeriodTo(ReadableInstant arg0) {
        return new Period(this, arg0);
    }

    public Period toPeriodFrom(ReadableInstant arg0, PeriodType arg1) {
        return new Period(arg0, this, arg1);
    }

    protected BaseDuration(long arg0) {
        this.iMillis = arg0;
    }

    protected BaseDuration(Object arg0) {
        DurationConverter durationConverter = ConverterManager.getInstance().getDurationConverter(arg0);
        this.iMillis = durationConverter.getDurationMillis(arg0);
    }

    public Period toPeriodTo(ReadableInstant arg0, PeriodType arg1) {
        return new Period(this, arg0, arg1);
    }

    public Interval toIntervalTo(ReadableInstant arg0) {
        return new Interval(this, arg0);
    }

    public Period toPeriod(PeriodType arg0) {
        return new Period(this.getMillis(), arg0);
    }
}

