/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.base;

import java.io.Serializable;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableDateTime;
import org.joda.time.base.AbstractDateTime;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.convert.ConverterManager;
import org.joda.time.convert.InstantConverter;

public abstract class BaseDateTime
extends AbstractDateTime
implements ReadableDateTime,
Serializable {
    private volatile long iMillis;
    private volatile Chronology iChronology;
    private static final long serialVersionUID = -6728882245981L;

    protected void setChronology(Chronology arg0) {
        this.iChronology = this.checkChronology(arg0);
    }

    public BaseDateTime(long arg0) {
        this(arg0, (Chronology)ISOChronology.getInstance());
    }

    public BaseDateTime(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, Chronology arg7) {
        this.iChronology = this.checkChronology(arg7);
        long l2 = this.iChronology.getDateTimeMillis(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
        this.iMillis = this.checkInstant(l2, this.iChronology);
        this.adjustForMinMax();
    }

    public BaseDateTime() {
        this(DateTimeUtils.currentTimeMillis(), (Chronology)ISOChronology.getInstance());
    }

    public long getMillis() {
        return this.iMillis;
    }

    protected Chronology checkChronology(Chronology arg0) {
        return DateTimeUtils.getChronology(arg0);
    }

    public BaseDateTime(DateTimeZone arg0) {
        this(DateTimeUtils.currentTimeMillis(), (Chronology)ISOChronology.getInstance(arg0));
    }

    public BaseDateTime(long arg0, DateTimeZone arg1) {
        this(arg0, (Chronology)ISOChronology.getInstance(arg1));
    }

    public Chronology getChronology() {
        return this.iChronology;
    }

    private void adjustForMinMax() {
        BaseDateTime a2;
        if (a2.iMillis == Long.MIN_VALUE || a2.iMillis == Long.MAX_VALUE) {
            a2.iChronology = a2.iChronology.withUTC();
        }
    }

    public BaseDateTime(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6) {
        this(arg0, arg1, arg2, arg3, arg4, arg5, arg6, ISOChronology.getInstance());
    }

    protected long checkInstant(long arg0, Chronology arg1) {
        return arg0;
    }

    public BaseDateTime(long arg0, Chronology arg1) {
        this.iChronology = this.checkChronology(arg1);
        this.iMillis = this.checkInstant(arg0, this.iChronology);
        this.adjustForMinMax();
    }

    public BaseDateTime(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, DateTimeZone arg7) {
        this(arg0, arg1, arg2, arg3, arg4, arg5, arg6, ISOChronology.getInstance(arg7));
    }

    public BaseDateTime(Chronology arg0) {
        this(DateTimeUtils.currentTimeMillis(), arg0);
    }

    public BaseDateTime(Object arg0, Chronology arg1) {
        InstantConverter instantConverter = ConverterManager.getInstance().getInstantConverter(arg0);
        this.iChronology = this.checkChronology(instantConverter.getChronology(arg0, arg1));
        this.iMillis = this.checkInstant(instantConverter.getInstantMillis(arg0, arg1), this.iChronology);
        this.adjustForMinMax();
    }

    public BaseDateTime(Object arg0, DateTimeZone arg1) {
        Chronology chronology;
        InstantConverter instantConverter = ConverterManager.getInstance().getInstantConverter(arg0);
        this.iChronology = chronology = this.checkChronology(instantConverter.getChronology(arg0, arg1));
        this.iMillis = this.checkInstant(instantConverter.getInstantMillis(arg0, chronology), chronology);
        this.adjustForMinMax();
    }

    protected void setMillis(long arg0) {
        this.iMillis = this.checkInstant(arg0, this.iChronology);
    }
}

