/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.base;

import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.MutableInterval;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public abstract class AbstractInterval
implements ReadableInterval {
    public MutableInterval toMutableInterval() {
        return new MutableInterval(this.getStartMillis(), this.getEndMillis(), this.getChronology());
    }

    protected void checkInterval(long arg0, long arg1) {
        if (arg1 < arg0) {
            throw new IllegalArgumentException("The end instant must be greater the start");
        }
    }

    public int hashCode() {
        long l2 = this.getStartMillis();
        long l3 = this.getEndMillis();
        int n = 97;
        n = 31 * n + (int)(l2 ^ l2 >>> 32);
        n = 31 * n + (int)(l3 ^ l3 >>> 32);
        n = 31 * n + this.getChronology().hashCode();
        return n;
    }

    public boolean isAfterNow() {
        return this.isAfter(DateTimeUtils.currentTimeMillis());
    }

    public boolean containsNow() {
        return this.contains(DateTimeUtils.currentTimeMillis());
    }

    public boolean isBefore(ReadableInstant arg0) {
        if (arg0 == null) {
            return this.isBeforeNow();
        }
        return this.isBefore(arg0.getMillis());
    }

    public Duration toDuration() {
        long l2 = this.toDurationMillis();
        if (l2 == 0L) {
            return Duration.ZERO;
        }
        return new Duration(l2);
    }

    public DateTime getEnd() {
        return new DateTime(this.getEndMillis(), this.getChronology());
    }

    public boolean isEqual(ReadableInterval arg0) {
        return this.getStartMillis() == arg0.getStartMillis() && this.getEndMillis() == arg0.getEndMillis();
    }

    public boolean contains(long arg0) {
        long l2 = this.getStartMillis();
        long l3 = this.getEndMillis();
        return arg0 >= l2 && arg0 < l3;
    }

    public Period toPeriod(PeriodType arg0) {
        return new Period(this.getStartMillis(), this.getEndMillis(), arg0, this.getChronology());
    }

    public boolean overlaps(ReadableInterval arg0) {
        long l2 = this.getStartMillis();
        long l3 = this.getEndMillis();
        if (arg0 == null) {
            long l4 = DateTimeUtils.currentTimeMillis();
            return l2 < l4 && l4 < l3;
        }
        long l5 = arg0.getStartMillis();
        long l6 = arg0.getEndMillis();
        return l2 < l6 && l5 < l3;
    }

    public boolean isAfter(ReadableInstant arg0) {
        if (arg0 == null) {
            return this.isAfterNow();
        }
        return this.isAfter(arg0.getMillis());
    }

    public boolean isBefore(ReadableInterval arg0) {
        if (arg0 == null) {
            return this.isBeforeNow();
        }
        return this.isBefore(arg0.getStartMillis());
    }

    public boolean contains(ReadableInstant arg0) {
        if (arg0 == null) {
            return this.containsNow();
        }
        return this.contains(arg0.getMillis());
    }

    public boolean isAfter(ReadableInterval arg0) {
        long l2 = arg0 == null ? DateTimeUtils.currentTimeMillis() : arg0.getEndMillis();
        return this.getStartMillis() >= l2;
    }

    public Period toPeriod() {
        return new Period(this.getStartMillis(), this.getEndMillis(), this.getChronology());
    }

    public boolean isBeforeNow() {
        return this.isBefore(DateTimeUtils.currentTimeMillis());
    }

    public long toDurationMillis() {
        return FieldUtils.safeSubtract(this.getEndMillis(), this.getStartMillis());
    }

    public boolean contains(ReadableInterval arg0) {
        if (arg0 == null) {
            return this.containsNow();
        }
        long l2 = arg0.getStartMillis();
        long l3 = arg0.getEndMillis();
        long l4 = this.getStartMillis();
        long l5 = this.getEndMillis();
        return l4 <= l2 && l2 < l5 && l3 <= l5;
    }

    public boolean isAfter(long arg0) {
        return this.getStartMillis() > arg0;
    }

    protected AbstractInterval() {
    }

    public DateTime getStart() {
        return new DateTime(this.getStartMillis(), this.getChronology());
    }

    public String toString() {
        DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTime();
        dateTimeFormatter = dateTimeFormatter.withChronology(this.getChronology());
        StringBuffer stringBuffer = new StringBuffer(48);
        dateTimeFormatter.printTo(stringBuffer, this.getStartMillis());
        stringBuffer.append('/');
        dateTimeFormatter.printTo(stringBuffer, this.getEndMillis());
        return stringBuffer.toString();
    }

    public Interval toInterval() {
        return new Interval(this.getStartMillis(), this.getEndMillis(), this.getChronology());
    }

    public boolean isBefore(long arg0) {
        return this.getEndMillis() <= arg0;
    }

    public boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (!(arg0 instanceof ReadableInterval)) {
            return false;
        }
        ReadableInterval readableInterval = (ReadableInterval)arg0;
        return this.getStartMillis() == readableInterval.getStartMillis() && this.getEndMillis() == readableInterval.getEndMillis() && FieldUtils.equals(this.getChronology(), readableInterval.getChronology());
    }
}

