/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationFieldType;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.TimeOfDay;
import org.joda.time.base.BasePartial;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.field.AbstractPartialFieldProperty;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.ISODateTimeFormat;

@Deprecated
public final class YearMonthDay
extends BasePartial
implements ReadablePartial,
Serializable {
    public static final int YEAR = 0;
    private static final DateTimeFieldType[] FIELD_TYPES = new DateTimeFieldType[]{DateTimeFieldType.year(), DateTimeFieldType.monthOfYear(), DateTimeFieldType.dayOfMonth()};
    private static final long serialVersionUID = 797544782896179L;
    public static final int MONTH_OF_YEAR = 1;
    public static final int DAY_OF_MONTH = 2;

    public YearMonthDay plusDays(int arg0) {
        return this.withFieldAdded(DurationFieldType.days(), arg0);
    }

    public YearMonthDay minusMonths(int arg0) {
        return this.withFieldAdded(DurationFieldType.months(), FieldUtils.safeNegate(arg0));
    }

    public DateTime toDateTimeAtMidnight() {
        return this.toDateTimeAtMidnight(null);
    }

    public Interval toInterval() {
        return this.toInterval(null);
    }

    public YearMonthDay withYear(int arg0) {
        int[] nArray = this.getValues();
        nArray = this.getChronology().year().set(this, 0, nArray, arg0);
        return new YearMonthDay(this, nArray);
    }

    public DateTime toDateTimeAtMidnight(DateTimeZone arg0) {
        Chronology chronology = this.getChronology().withZone(arg0);
        return new DateTime(this.getYear(), this.getMonthOfYear(), this.getDayOfMonth(), 0, 0, 0, 0, chronology);
    }

    public YearMonthDay withField(DateTimeFieldType arg0, int arg1) {
        int n = this.indexOfSupported(arg0);
        if (arg1 == this.getValue(n)) {
            return this;
        }
        int[] nArray = this.getValues();
        nArray = this.getField(n).set(this, n, nArray, arg1);
        return new YearMonthDay(this, nArray);
    }

    public DateTime toDateTimeAtCurrentTime() {
        return this.toDateTimeAtCurrentTime(null);
    }

    public YearMonthDay(long arg0, Chronology arg1) {
        super(arg0, arg1);
    }

    public DateTime toDateTime(TimeOfDay arg0, DateTimeZone arg1) {
        Chronology chronology = this.getChronology().withZone(arg1);
        long l2 = DateTimeUtils.currentTimeMillis();
        l2 = chronology.set(this, l2);
        if (arg0 != null) {
            l2 = chronology.set(arg0, l2);
        }
        return new DateTime(l2, chronology);
    }

    public DateMidnight toDateMidnight() {
        return this.toDateMidnight(null);
    }

    public Interval toInterval(DateTimeZone arg0) {
        arg0 = DateTimeUtils.getZone(arg0);
        return this.toDateMidnight(arg0).toInterval();
    }

    public YearMonthDay(Object arg0, Chronology arg1) {
        super(arg0, DateTimeUtils.getChronology(arg1), ISODateTimeFormat.dateOptionalTimeParser());
    }

    public Property property(DateTimeFieldType arg0) {
        return new Property(this, this.indexOfSupported(arg0));
    }

    public DateTime toDateTime(TimeOfDay arg0) {
        return this.toDateTime(arg0, null);
    }

    public int getMonthOfYear() {
        return this.getValue(1);
    }

    public YearMonthDay plusMonths(int arg0) {
        return this.withFieldAdded(DurationFieldType.months(), arg0);
    }

    public Property dayOfMonth() {
        return new Property(this, 2);
    }

    public YearMonthDay(int arg0, int arg1, int arg2) {
        this(arg0, arg1, arg2, null);
    }

    public YearMonthDay minusYears(int arg0) {
        return this.withFieldAdded(DurationFieldType.years(), FieldUtils.safeNegate(arg0));
    }

    public int getDayOfMonth() {
        return this.getValue(2);
    }

    public YearMonthDay withPeriodAdded(ReadablePeriod arg0, int arg1) {
        if (arg0 == null || arg1 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        for (int i2 = 0; i2 < arg0.size(); ++i2) {
            DurationFieldType durationFieldType = arg0.getFieldType(i2);
            int n = this.indexOf(durationFieldType);
            if (n < 0) continue;
            nArray = this.getField(n).add(this, n, nArray, FieldUtils.safeMultiply(arg0.getValue(i2), arg1));
        }
        return new YearMonthDay(this, nArray);
    }

    public YearMonthDay() {
    }

    public LocalDate toLocalDate() {
        return new LocalDate(this.getYear(), this.getMonthOfYear(), this.getDayOfMonth(), this.getChronology());
    }

    public YearMonthDay withChronologyRetainFields(Chronology arg0) {
        arg0 = DateTimeUtils.getChronology(arg0);
        if ((arg0 = arg0.withUTC()) == this.getChronology()) {
            return this;
        }
        YearMonthDay yearMonthDay = new YearMonthDay(this, arg0);
        arg0.validate(yearMonthDay, this.getValues());
        return yearMonthDay;
    }

    public static YearMonthDay fromCalendarFields(Calendar arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("The calendar must not be null");
        }
        return new YearMonthDay(arg0.get(1), arg0.get(2) + 1, arg0.get(5));
    }

    public YearMonthDay minus(ReadablePeriod arg0) {
        return this.withPeriodAdded(arg0, -1);
    }

    public static YearMonthDay fromDateFields(Date arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return new YearMonthDay(arg0.getYear() + 1900, arg0.getMonth() + 1, arg0.getDate());
    }

    public YearMonthDay withMonthOfYear(int arg0) {
        int[] nArray = this.getValues();
        nArray = this.getChronology().monthOfYear().set(this, 1, nArray, arg0);
        return new YearMonthDay(this, nArray);
    }

    public YearMonthDay withFieldAdded(DurationFieldType arg0, int arg1) {
        int n = this.indexOfSupported(arg0);
        if (arg1 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        nArray = this.getField(n).add(this, n, nArray, arg1);
        return new YearMonthDay(this, nArray);
    }

    public YearMonthDay(int arg0, int arg1, int arg2, Chronology arg3) {
        super(new int[]{arg0, arg1, arg2}, arg3);
    }

    public YearMonthDay minusDays(int arg0) {
        return this.withFieldAdded(DurationFieldType.days(), FieldUtils.safeNegate(arg0));
    }

    YearMonthDay(YearMonthDay a2, Chronology a3) {
        super((BasePartial)a2, a3);
        YearMonthDay a4;
    }

    public DateTimeFieldType[] getFieldTypes() {
        return (DateTimeFieldType[])FIELD_TYPES.clone();
    }

    public YearMonthDay(Object arg0) {
        super(arg0, null, ISODateTimeFormat.dateOptionalTimeParser());
    }

    public YearMonthDay(DateTimeZone arg0) {
        super(ISOChronology.getInstance(arg0));
    }

    public DateMidnight toDateMidnight(DateTimeZone arg0) {
        Chronology chronology = this.getChronology().withZone(arg0);
        return new DateMidnight(this.getYear(), this.getMonthOfYear(), this.getDayOfMonth(), chronology);
    }

    public YearMonthDay(Chronology arg0) {
        super(arg0);
    }

    public DateTimeFieldType getFieldType(int arg0) {
        return FIELD_TYPES[arg0];
    }

    public String toString() {
        return ISODateTimeFormat.yearMonthDay().print(this);
    }

    public DateTime toDateTimeAtCurrentTime(DateTimeZone arg0) {
        Chronology chronology = this.getChronology().withZone(arg0);
        long l2 = DateTimeUtils.currentTimeMillis();
        long l3 = chronology.set(this, l2);
        return new DateTime(l3, chronology);
    }

    public YearMonthDay plusYears(int arg0) {
        return this.withFieldAdded(DurationFieldType.years(), arg0);
    }

    public Property monthOfYear() {
        return new Property(this, 1);
    }

    YearMonthDay(YearMonthDay a2, int[] a3) {
        super((BasePartial)a2, a3);
        YearMonthDay a4;
    }

    public YearMonthDay plus(ReadablePeriod arg0) {
        return this.withPeriodAdded(arg0, 1);
    }

    public YearMonthDay withDayOfMonth(int arg0) {
        int[] nArray = this.getValues();
        nArray = this.getChronology().dayOfMonth().set(this, 2, nArray, arg0);
        return new YearMonthDay(this, nArray);
    }

    public int size() {
        return 3;
    }

    public Property year() {
        return new Property(this, 0);
    }

    public YearMonthDay(long arg0) {
        super(arg0);
    }

    public int getYear() {
        return this.getValue(0);
    }

    protected DateTimeField getField(int arg0, Chronology arg1) {
        switch (arg0) {
            case 0: {
                return arg1.year();
            }
            case 1: {
                return arg1.monthOfYear();
            }
            case 2: {
                return arg1.dayOfMonth();
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + arg0);
    }

    @Deprecated
    public static class Property
    extends AbstractPartialFieldProperty
    implements Serializable {
        private final int iFieldIndex;
        private final YearMonthDay iYearMonthDay;
        private static final long serialVersionUID = 5727734012190224363L;

        public YearMonthDay getYearMonthDay() {
            return this.iYearMonthDay;
        }

        public int get() {
            return this.iYearMonthDay.getValue(this.iFieldIndex);
        }

        public YearMonthDay addToCopy(int arg0) {
            int[] nArray = this.iYearMonthDay.getValues();
            nArray = this.getField().add(this.iYearMonthDay, this.iFieldIndex, nArray, arg0);
            return new YearMonthDay(this.iYearMonthDay, nArray);
        }

        public YearMonthDay addWrapFieldToCopy(int arg0) {
            int[] nArray = this.iYearMonthDay.getValues();
            nArray = this.getField().addWrapField(this.iYearMonthDay, this.iFieldIndex, nArray, arg0);
            return new YearMonthDay(this.iYearMonthDay, nArray);
        }

        public YearMonthDay setCopy(int arg0) {
            int[] nArray = this.iYearMonthDay.getValues();
            nArray = this.getField().set(this.iYearMonthDay, this.iFieldIndex, nArray, arg0);
            return new YearMonthDay(this.iYearMonthDay, nArray);
        }

        protected ReadablePartial getReadablePartial() {
            return this.iYearMonthDay;
        }

        Property(YearMonthDay a2, int a3) {
            Property a4;
            a4.iYearMonthDay = a2;
            a4.iFieldIndex = a3;
        }

        public YearMonthDay withMaximumValue() {
            return this.setCopy(this.getMaximumValue());
        }

        public YearMonthDay setCopy(String arg0) {
            return this.setCopy(arg0, null);
        }

        public YearMonthDay withMinimumValue() {
            return this.setCopy(this.getMinimumValue());
        }

        public DateTimeField getField() {
            return this.iYearMonthDay.getField(this.iFieldIndex);
        }

        public YearMonthDay setCopy(String arg0, Locale arg1) {
            int[] nArray = this.iYearMonthDay.getValues();
            nArray = this.getField().set(this.iYearMonthDay, this.iFieldIndex, nArray, arg0, arg1);
            return new YearMonthDay(this.iYearMonthDay, nArray);
        }
    }
}

