/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.joda.convert.FromString;
import org.joda.convert.ToString;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationFieldType;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.base.BasePartial;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.field.AbstractPartialFieldProperty;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class YearMonth
extends BasePartial
implements ReadablePartial,
Serializable {
    public static final int YEAR = 0;
    public static final int MONTH_OF_YEAR = 1;
    private static final long serialVersionUID = 797544782896179L;
    private static final DateTimeFieldType[] FIELD_TYPES = new DateTimeFieldType[]{DateTimeFieldType.year(), DateTimeFieldType.monthOfYear()};

    public YearMonth withMonthOfYear(int arg0) {
        int[] nArray = this.getValues();
        nArray = this.getChronology().monthOfYear().set(this, 1, nArray, arg0);
        return new YearMonth(this, nArray);
    }

    YearMonth(YearMonth a2, Chronology a3) {
        super((BasePartial)a2, a3);
        YearMonth a4;
    }

    public YearMonth withChronologyRetainFields(Chronology arg0) {
        arg0 = DateTimeUtils.getChronology(arg0);
        if ((arg0 = arg0.withUTC()) == this.getChronology()) {
            return this;
        }
        YearMonth yearMonth = new YearMonth(this, arg0);
        arg0.validate(yearMonth, this.getValues());
        return yearMonth;
    }

    public YearMonth minusMonths(int arg0) {
        return this.withFieldAdded(DurationFieldType.months(), FieldUtils.safeNegate(arg0));
    }

    @FromString
    public static YearMonth parse(String arg0) {
        return YearMonth.parse(arg0, ISODateTimeFormat.localDateParser());
    }

    public YearMonth withField(DateTimeFieldType arg0, int arg1) {
        int n = this.indexOfSupported(arg0);
        if (arg1 == this.getValue(n)) {
            return this;
        }
        int[] nArray = this.getValues();
        nArray = this.getField(n).set(this, n, nArray, arg1);
        return new YearMonth(this, nArray);
    }

    public static YearMonth fromDateFields(Date arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return new YearMonth(arg0.getYear() + 1900, arg0.getMonth() + 1);
    }

    public Interval toInterval(DateTimeZone arg0) {
        arg0 = DateTimeUtils.getZone(arg0);
        DateTime dateTime = this.toLocalDate(1).toDateTimeAtStartOfDay(arg0);
        DateTime dateTime2 = this.plusMonths(1).toLocalDate(1).toDateTimeAtStartOfDay(arg0);
        return new Interval((ReadableInstant)dateTime, (ReadableInstant)dateTime2);
    }

    public YearMonth minusYears(int arg0) {
        return this.withFieldAdded(DurationFieldType.years(), FieldUtils.safeNegate(arg0));
    }

    public YearMonth(int arg0, int arg1, Chronology arg2) {
        super(new int[]{arg0, arg1}, arg2);
    }

    public YearMonth(Chronology arg0) {
        super(arg0);
    }

    @ToString
    public String toString() {
        return ISODateTimeFormat.yearMonth().print(this);
    }

    public YearMonth withYear(int arg0) {
        int[] nArray = this.getValues();
        nArray = this.getChronology().year().set(this, 0, nArray, arg0);
        return new YearMonth(this, nArray);
    }

    public Property property(DateTimeFieldType arg0) {
        return new Property(this, this.indexOfSupported(arg0));
    }

    public static YearMonth parse(String arg0, DateTimeFormatter arg1) {
        LocalDate localDate = arg1.parseLocalDate(arg0);
        return new YearMonth(localDate.getYear(), localDate.getMonthOfYear());
    }

    public LocalDate toLocalDate(int arg0) {
        return new LocalDate(this.getYear(), this.getMonthOfYear(), arg0, this.getChronology());
    }

    public String toString(String arg0) {
        if (arg0 == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(arg0).print(this);
    }

    public String toString(String arg0, Locale arg1) throws IllegalArgumentException {
        if (arg0 == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(arg0).withLocale(arg1).print(this);
    }

    private Object readResolve() {
        YearMonth a2;
        if (!DateTimeZone.UTC.equals(a2.getChronology().getZone())) {
            return new YearMonth(a2, a2.getChronology().withUTC());
        }
        return a2;
    }

    public YearMonth(Object arg0) {
        super(arg0, null, ISODateTimeFormat.localDateParser());
    }

    public Interval toInterval() {
        return this.toInterval(null);
    }

    public DateTimeFieldType[] getFieldTypes() {
        return (DateTimeFieldType[])FIELD_TYPES.clone();
    }

    public YearMonth plusMonths(int arg0) {
        return this.withFieldAdded(DurationFieldType.months(), arg0);
    }

    public Property monthOfYear() {
        return new Property(this, 1);
    }

    YearMonth(YearMonth a2, int[] a3) {
        super((BasePartial)a2, a3);
        YearMonth a4;
    }

    public YearMonth plusYears(int arg0) {
        return this.withFieldAdded(DurationFieldType.years(), arg0);
    }

    protected DateTimeField getField(int arg0, Chronology arg1) {
        switch (arg0) {
            case 0: {
                return arg1.year();
            }
            case 1: {
                return arg1.monthOfYear();
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + arg0);
    }

    public static YearMonth now(DateTimeZone arg0) {
        if (arg0 == null) {
            throw new NullPointerException("Zone must not be null");
        }
        return new YearMonth(arg0);
    }

    public YearMonth minus(ReadablePeriod arg0) {
        return this.withPeriodAdded(arg0, -1);
    }

    public YearMonth(Object arg0, Chronology arg1) {
        super(arg0, DateTimeUtils.getChronology(arg1), ISODateTimeFormat.localDateParser());
    }

    public int size() {
        return 2;
    }

    public int getMonthOfYear() {
        return this.getValue(1);
    }

    public YearMonth plus(ReadablePeriod arg0) {
        return this.withPeriodAdded(arg0, 1);
    }

    public int getYear() {
        return this.getValue(0);
    }

    public YearMonth(int arg0, int arg1) {
        this(arg0, arg1, null);
    }

    public Property year() {
        return new Property(this, 0);
    }

    public YearMonth(long arg0) {
        super(arg0);
    }

    public YearMonth() {
    }

    public DateTimeFieldType getFieldType(int arg0) {
        return FIELD_TYPES[arg0];
    }

    public static YearMonth now(Chronology arg0) {
        if (arg0 == null) {
            throw new NullPointerException("Chronology must not be null");
        }
        return new YearMonth(arg0);
    }

    public static YearMonth fromCalendarFields(Calendar arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("The calendar must not be null");
        }
        return new YearMonth(arg0.get(1), arg0.get(2) + 1);
    }

    public YearMonth withFieldAdded(DurationFieldType arg0, int arg1) {
        int n = this.indexOfSupported(arg0);
        if (arg1 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        nArray = this.getField(n).add(this, n, nArray, arg1);
        return new YearMonth(this, nArray);
    }

    public YearMonth withPeriodAdded(ReadablePeriod arg0, int arg1) {
        if (arg0 == null || arg1 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        for (int i2 = 0; i2 < arg0.size(); ++i2) {
            DurationFieldType durationFieldType = arg0.getFieldType(i2);
            int n = this.indexOf(durationFieldType);
            if (n < 0) continue;
            nArray = this.getField(n).add(this, n, nArray, FieldUtils.safeMultiply(arg0.getValue(i2), arg1));
        }
        return new YearMonth(this, nArray);
    }

    public YearMonth(long arg0, Chronology arg1) {
        super(arg0, arg1);
    }

    public static YearMonth now() {
        return new YearMonth();
    }

    public YearMonth(DateTimeZone arg0) {
        super(ISOChronology.getInstance(arg0));
    }

    public static class Property
    extends AbstractPartialFieldProperty
    implements Serializable {
        private final YearMonth iBase;
        private static final long serialVersionUID = 5727734012190224363L;
        private final int iFieldIndex;

        public YearMonth setCopy(String arg0) {
            return this.setCopy(arg0, null);
        }

        public YearMonth addToCopy(int arg0) {
            int[] nArray = this.iBase.getValues();
            nArray = this.getField().add(this.iBase, this.iFieldIndex, nArray, arg0);
            return new YearMonth(this.iBase, nArray);
        }

        public YearMonth setCopy(String arg0, Locale arg1) {
            int[] nArray = this.iBase.getValues();
            nArray = this.getField().set(this.iBase, this.iFieldIndex, nArray, arg0, arg1);
            return new YearMonth(this.iBase, nArray);
        }

        public YearMonth getYearMonth() {
            return this.iBase;
        }

        Property(YearMonth a2, int a3) {
            Property a4;
            a4.iBase = a2;
            a4.iFieldIndex = a3;
        }

        public int get() {
            return this.iBase.getValue(this.iFieldIndex);
        }

        public YearMonth addWrapFieldToCopy(int arg0) {
            int[] nArray = this.iBase.getValues();
            nArray = this.getField().addWrapField(this.iBase, this.iFieldIndex, nArray, arg0);
            return new YearMonth(this.iBase, nArray);
        }

        protected ReadablePartial getReadablePartial() {
            return this.iBase;
        }

        public YearMonth setCopy(int arg0) {
            int[] nArray = this.iBase.getValues();
            nArray = this.getField().set(this.iBase, this.iFieldIndex, nArray, arg0);
            return new YearMonth(this.iBase, nArray);
        }

        public DateTimeField getField() {
            return this.iBase.getField(this.iFieldIndex);
        }
    }
}

