/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import org.joda.convert.FromString;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.Days;
import org.joda.time.Duration;
import org.joda.time.DurationFieldType;
import org.joda.time.Hours;
import org.joda.time.Minutes;
import org.joda.time.PeriodType;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.Seconds;
import org.joda.time.Weeks;
import org.joda.time.base.BasePeriod;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;

public final class Period
extends BasePeriod
implements ReadablePeriod,
Serializable {
    public static final Period ZERO = new Period();
    private static final long serialVersionUID = 741052353876488155L;

    public Period minusMinutes(int arg0) {
        return this.plusMinutes(-arg0);
    }

    public int getWeeks() {
        return this.getPeriodType().getIndexedField(this, PeriodType.WEEK_INDEX);
    }

    public Period minusDays(int arg0) {
        return this.plusDays(-arg0);
    }

    public int getSeconds() {
        return this.getPeriodType().getIndexedField(this, PeriodType.SECOND_INDEX);
    }

    public Period toPeriod() {
        return this;
    }

    public Period(int arg0, int arg1, int arg2, int arg3) {
        super(0, 0, 0, 0, arg0, arg1, arg2, arg3, PeriodType.standard());
    }

    public static Period days(int arg0) {
        return new Period(new int[]{0, 0, 0, arg0, 0, 0, 0, 0}, PeriodType.standard());
    }

    public Period(long arg0, PeriodType arg1, Chronology arg2) {
        super(arg0, arg1, arg2);
    }

    public Period minusSeconds(int arg0) {
        return this.plusSeconds(-arg0);
    }

    public static Period seconds(int arg0) {
        return new Period(new int[]{0, 0, 0, 0, 0, 0, arg0, 0}, PeriodType.standard());
    }

    public Period minusHours(int arg0) {
        return this.plusHours(-arg0);
    }

    public Period(Object arg0, PeriodType arg1) {
        super(arg0, arg1, null);
    }

    public Period withMonths(int arg0) {
        int[] nArray = this.getValues();
        this.getPeriodType().setIndexedField(this, PeriodType.MONTH_INDEX, nArray, arg0);
        return new Period(nArray, this.getPeriodType());
    }

    public Period(Object arg0) {
        super(arg0, null, null);
    }

    public Period(ReadableDuration arg0, ReadableInstant arg1) {
        super(arg0, arg1, null);
    }

    public static Period millis(int arg0) {
        return new Period(new int[]{0, 0, 0, 0, 0, 0, 0, arg0}, PeriodType.standard());
    }

    public Period(ReadableDuration arg0, ReadableInstant arg1, PeriodType arg2) {
        super(arg0, arg1, arg2);
    }

    public Period withDays(int arg0) {
        int[] nArray = this.getValues();
        this.getPeriodType().setIndexedField(this, PeriodType.DAY_INDEX, nArray, arg0);
        return new Period(nArray, this.getPeriodType());
    }

    public Period multipliedBy(int arg0) {
        if (this == ZERO || arg0 == 1) {
            return this;
        }
        int[] nArray = this.getValues();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = FieldUtils.safeMultiply(nArray[i2], arg0);
        }
        return new Period(nArray, this.getPeriodType());
    }

    public Period(ReadableInstant arg0, ReadableInstant arg1) {
        super(arg0, arg1, null);
    }

    public Period(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, PeriodType arg8) {
        super(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    }

    public Period plusMinutes(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        this.getPeriodType().addIndexedField(this, PeriodType.MINUTE_INDEX, nArray, arg0);
        return new Period(nArray, this.getPeriodType());
    }

    public static Period hours(int arg0) {
        return new Period(new int[]{0, 0, 0, 0, arg0, 0, 0, 0}, PeriodType.standard());
    }

    public Days toStandardDays() {
        this.checkYearsAndMonths("Days");
        long l2 = this.getMillis();
        l2 += (long)this.getSeconds() * 1000L;
        l2 += (long)this.getMinutes() * 60000L;
        long l3 = (l2 += (long)this.getHours() * 3600000L) / 86400000L;
        l3 = FieldUtils.safeAdd(l3, (long)this.getDays());
        l3 = FieldUtils.safeAdd(l3, (long)this.getWeeks() * 7L);
        return Days.days(FieldUtils.safeToInt(l3));
    }

    public Period(Object arg0, PeriodType arg1, Chronology arg2) {
        super(arg0, arg1, arg2);
    }

    public Period() {
        super(0L, (PeriodType)null, (Chronology)null);
    }

    public Period withPeriodType(PeriodType arg0) {
        if ((arg0 = DateTimeUtils.getPeriodType(arg0)).equals(this.getPeriodType())) {
            return this;
        }
        return new Period((Object)this, arg0);
    }

    public Period minusWeeks(int arg0) {
        return this.plusWeeks(-arg0);
    }

    public Period(long arg0, long arg1, PeriodType arg2) {
        super(arg0, arg1, arg2, null);
    }

    public static Period minutes(int arg0) {
        return new Period(new int[]{0, 0, 0, 0, 0, arg0, 0, 0}, PeriodType.standard());
    }

    public Period plusMonths(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        this.getPeriodType().addIndexedField(this, PeriodType.MONTH_INDEX, nArray, arg0);
        return new Period(nArray, this.getPeriodType());
    }

    public Period(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7) {
        super(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, PeriodType.standard());
    }

    public Period minusMillis(int arg0) {
        return this.plusMillis(-arg0);
    }

    public int getMillis() {
        return this.getPeriodType().getIndexedField(this, PeriodType.MILLI_INDEX);
    }

    public static Period parse(String arg0, PeriodFormatter arg1) {
        return arg1.parsePeriod(arg0);
    }

    public Period minusMonths(int arg0) {
        return this.plusMonths(-arg0);
    }

    public int getDays() {
        return this.getPeriodType().getIndexedField(this, PeriodType.DAY_INDEX);
    }

    public Seconds toStandardSeconds() {
        this.checkYearsAndMonths("Seconds");
        long l2 = this.getMillis() / 1000;
        l2 = FieldUtils.safeAdd(l2, (long)this.getSeconds());
        l2 = FieldUtils.safeAdd(l2, (long)this.getMinutes() * 60L);
        l2 = FieldUtils.safeAdd(l2, (long)this.getHours() * 3600L);
        l2 = FieldUtils.safeAdd(l2, (long)this.getDays() * 86400L);
        l2 = FieldUtils.safeAdd(l2, (long)this.getWeeks() * 604800L);
        return Seconds.seconds(FieldUtils.safeToInt(l2));
    }

    public Period(long arg0, Chronology arg1) {
        super(arg0, (PeriodType)null, arg1);
    }

    public Period minusYears(int arg0) {
        return this.plusYears(-arg0);
    }

    public Period plusWeeks(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        this.getPeriodType().addIndexedField(this, PeriodType.WEEK_INDEX, nArray, arg0);
        return new Period(nArray, this.getPeriodType());
    }

    public static Period weeks(int arg0) {
        return new Period(new int[]{0, 0, arg0, 0, 0, 0, 0, 0}, PeriodType.standard());
    }

    private void checkYearsAndMonths(String a2) {
        Period a3;
        if (a3.getMonths() != 0) {
            throw new UnsupportedOperationException("Cannot convert to " + a2 + " as this period contains months and months vary in length");
        }
        if (a3.getYears() != 0) {
            throw new UnsupportedOperationException("Cannot convert to " + a2 + " as this period contains years and years vary in length");
        }
    }

    public Period(long arg0, long arg1) {
        super(arg0, arg1, null, null);
    }

    public Hours toStandardHours() {
        this.checkYearsAndMonths("Hours");
        long l2 = this.getMillis();
        l2 += (long)this.getSeconds() * 1000L;
        long l3 = (l2 += (long)this.getMinutes() * 60000L) / 3600000L;
        l3 = FieldUtils.safeAdd(l3, (long)this.getHours());
        l3 = FieldUtils.safeAdd(l3, (long)this.getDays() * 24L);
        l3 = FieldUtils.safeAdd(l3, (long)this.getWeeks() * 168L);
        return Hours.hours(FieldUtils.safeToInt(l3));
    }

    public Period(ReadablePartial arg0, ReadablePartial arg1) {
        super(arg0, arg1, null);
    }

    public Duration toStandardDuration() {
        this.checkYearsAndMonths("Duration");
        long l2 = this.getMillis();
        l2 += (long)this.getSeconds() * 1000L;
        l2 += (long)this.getMinutes() * 60000L;
        l2 += (long)this.getHours() * 3600000L;
        l2 += (long)this.getDays() * 86400000L;
        return new Duration(l2 += (long)this.getWeeks() * 604800000L);
    }

    @FromString
    public static Period parse(String arg0) {
        return Period.parse(arg0, ISOPeriodFormat.standard());
    }

    public static Period years(int arg0) {
        return new Period(new int[]{arg0, 0, 0, 0, 0, 0, 0, 0, 0}, PeriodType.standard());
    }

    public Period(long arg0, long arg1, Chronology arg2) {
        super(arg0, arg1, null, arg2);
    }

    public Period withFieldAdded(DurationFieldType arg0, int arg1) {
        if (arg0 == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        if (arg1 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        super.addFieldInto(nArray, arg0, arg1);
        return new Period(nArray, this.getPeriodType());
    }

    public Period withYears(int arg0) {
        int[] nArray = this.getValues();
        this.getPeriodType().setIndexedField(this, PeriodType.YEAR_INDEX, nArray, arg0);
        return new Period(nArray, this.getPeriodType());
    }

    public Period withHours(int arg0) {
        int[] nArray = this.getValues();
        this.getPeriodType().setIndexedField(this, PeriodType.HOUR_INDEX, nArray, arg0);
        return new Period(nArray, this.getPeriodType());
    }

    public Period plusMillis(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        this.getPeriodType().addIndexedField(this, PeriodType.MILLI_INDEX, nArray, arg0);
        return new Period(nArray, this.getPeriodType());
    }

    public Weeks toStandardWeeks() {
        this.checkYearsAndMonths("Weeks");
        long l2 = this.getMillis();
        l2 += (long)this.getSeconds() * 1000L;
        l2 += (long)this.getMinutes() * 60000L;
        l2 += (long)this.getHours() * 3600000L;
        long l3 = (long)this.getWeeks() + (l2 += (long)this.getDays() * 86400000L) / 604800000L;
        return Weeks.weeks(FieldUtils.safeToInt(l3));
    }

    public Period withFields(ReadablePeriod arg0) {
        if (arg0 == null) {
            return this;
        }
        int[] nArray = this.getValues();
        nArray = super.mergePeriodInto(nArray, arg0);
        return new Period(nArray, this.getPeriodType());
    }

    public Period plusHours(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        this.getPeriodType().addIndexedField(this, PeriodType.HOUR_INDEX, nArray, arg0);
        return new Period(nArray, this.getPeriodType());
    }

    public Period plus(ReadablePeriod arg0) {
        if (arg0 == null) {
            return this;
        }
        int[] nArray = this.getValues();
        this.getPeriodType().addIndexedField(this, PeriodType.YEAR_INDEX, nArray, arg0.get(DurationFieldType.YEARS_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.MONTH_INDEX, nArray, arg0.get(DurationFieldType.MONTHS_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.WEEK_INDEX, nArray, arg0.get(DurationFieldType.WEEKS_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.DAY_INDEX, nArray, arg0.get(DurationFieldType.DAYS_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.HOUR_INDEX, nArray, arg0.get(DurationFieldType.HOURS_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.MINUTE_INDEX, nArray, arg0.get(DurationFieldType.MINUTES_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.SECOND_INDEX, nArray, arg0.get(DurationFieldType.SECONDS_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.MILLI_INDEX, nArray, arg0.get(DurationFieldType.MILLIS_TYPE));
        return new Period(nArray, this.getPeriodType());
    }

    public Period(ReadableInstant arg0, ReadableInstant arg1, PeriodType arg2) {
        super(arg0, arg1, arg2);
    }

    public Period withSeconds(int arg0) {
        int[] nArray = this.getValues();
        this.getPeriodType().setIndexedField(this, PeriodType.SECOND_INDEX, nArray, arg0);
        return new Period(nArray, this.getPeriodType());
    }

    public static Period months(int arg0) {
        return new Period(new int[]{0, arg0, 0, 0, 0, 0, 0, 0}, PeriodType.standard());
    }

    public int getYears() {
        return this.getPeriodType().getIndexedField(this, PeriodType.YEAR_INDEX);
    }

    public Minutes toStandardMinutes() {
        this.checkYearsAndMonths("Minutes");
        long l2 = this.getMillis();
        long l3 = (l2 += (long)this.getSeconds() * 1000L) / 60000L;
        l3 = FieldUtils.safeAdd(l3, (long)this.getMinutes());
        l3 = FieldUtils.safeAdd(l3, (long)this.getHours() * 60L);
        l3 = FieldUtils.safeAdd(l3, (long)this.getDays() * 1440L);
        l3 = FieldUtils.safeAdd(l3, (long)this.getWeeks() * 10080L);
        return Minutes.minutes(FieldUtils.safeToInt(l3));
    }

    public Period(Object arg0, Chronology arg1) {
        super(arg0, null, arg1);
    }

    public Period withWeeks(int arg0) {
        int[] nArray = this.getValues();
        this.getPeriodType().setIndexedField(this, PeriodType.WEEK_INDEX, nArray, arg0);
        return new Period(nArray, this.getPeriodType());
    }

    public Period(ReadableInstant arg0, ReadableDuration arg1) {
        super(arg0, arg1, null);
    }

    public Period normalizedStandard(PeriodType arg0) {
        arg0 = DateTimeUtils.getPeriodType(arg0);
        long l2 = this.getMillis();
        l2 += (long)this.getSeconds() * 1000L;
        l2 += (long)this.getMinutes() * 60000L;
        l2 += (long)this.getHours() * 3600000L;
        l2 += (long)this.getDays() * 86400000L;
        Period period = new Period(l2 += (long)this.getWeeks() * 604800000L, arg0, (Chronology)ISOChronology.getInstanceUTC());
        int n = this.getYears();
        int n2 = this.getMonths();
        if (n != 0 || n2 != 0) {
            int n3;
            long l3 = (long)n * 12L + (long)n2;
            if (arg0.isSupported(DurationFieldType.YEARS_TYPE)) {
                n3 = FieldUtils.safeToInt(l3 / 12L);
                period = period.withYears(n3);
                l3 -= (long)(n3 * 12);
            }
            if (arg0.isSupported(DurationFieldType.MONTHS_TYPE)) {
                n3 = FieldUtils.safeToInt(l3);
                period = period.withMonths(n3);
                l3 -= (long)n3;
            }
            if (l3 != 0L) {
                throw new UnsupportedOperationException("Unable to normalize as PeriodType is missing either years or months but period has a month/year amount: " + this.toString());
            }
        }
        return period;
    }

    public Period withField(DurationFieldType arg0, int arg1) {
        if (arg0 == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        int[] nArray = this.getValues();
        super.setFieldInto(nArray, arg0, arg1);
        return new Period(nArray, this.getPeriodType());
    }

    private Period(int[] a2, PeriodType a3) {
        super(a2, a3);
        Period a4;
    }

    public Period normalizedStandard() {
        return this.normalizedStandard(PeriodType.standard());
    }

    public Period(ReadableInstant arg0, ReadableDuration arg1, PeriodType arg2) {
        super(arg0, arg1, arg2);
    }

    public int getMinutes() {
        return this.getPeriodType().getIndexedField(this, PeriodType.MINUTE_INDEX);
    }

    public Period(long arg0, PeriodType arg1) {
        super(arg0, arg1, (Chronology)null);
    }

    public Period withMinutes(int arg0) {
        int[] nArray = this.getValues();
        this.getPeriodType().setIndexedField(this, PeriodType.MINUTE_INDEX, nArray, arg0);
        return new Period(nArray, this.getPeriodType());
    }

    public int getMonths() {
        return this.getPeriodType().getIndexedField(this, PeriodType.MONTH_INDEX);
    }

    public Period(long arg0, long arg1, PeriodType arg2, Chronology arg3) {
        super(arg0, arg1, arg2, arg3);
    }

    public Period plusYears(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        this.getPeriodType().addIndexedField(this, PeriodType.YEAR_INDEX, nArray, arg0);
        return new Period(nArray, this.getPeriodType());
    }

    public Period withMillis(int arg0) {
        int[] nArray = this.getValues();
        this.getPeriodType().setIndexedField(this, PeriodType.MILLI_INDEX, nArray, arg0);
        return new Period(nArray, this.getPeriodType());
    }

    public Period plusSeconds(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        this.getPeriodType().addIndexedField(this, PeriodType.SECOND_INDEX, nArray, arg0);
        return new Period(nArray, this.getPeriodType());
    }

    public Period minus(ReadablePeriod arg0) {
        if (arg0 == null) {
            return this;
        }
        int[] nArray = this.getValues();
        this.getPeriodType().addIndexedField(this, PeriodType.YEAR_INDEX, nArray, -arg0.get(DurationFieldType.YEARS_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.MONTH_INDEX, nArray, -arg0.get(DurationFieldType.MONTHS_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.WEEK_INDEX, nArray, -arg0.get(DurationFieldType.WEEKS_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.DAY_INDEX, nArray, -arg0.get(DurationFieldType.DAYS_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.HOUR_INDEX, nArray, -arg0.get(DurationFieldType.HOURS_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.MINUTE_INDEX, nArray, -arg0.get(DurationFieldType.MINUTES_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.SECOND_INDEX, nArray, -arg0.get(DurationFieldType.SECONDS_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.MILLI_INDEX, nArray, -arg0.get(DurationFieldType.MILLIS_TYPE));
        return new Period(nArray, this.getPeriodType());
    }

    public Period(long arg0) {
        super(arg0);
    }

    public static Period fieldDifference(ReadablePartial arg0, ReadablePartial arg1) {
        if (arg0 == null || arg1 == null) {
            throw new IllegalArgumentException("ReadablePartial objects must not be null");
        }
        if (arg0.size() != arg1.size()) {
            throw new IllegalArgumentException("ReadablePartial objects must have the same set of fields");
        }
        DurationFieldType[] durationFieldTypeArray = new DurationFieldType[arg0.size()];
        int[] nArray = new int[arg0.size()];
        int n = arg0.size();
        for (int i2 = 0; i2 < n; ++i2) {
            if (arg0.getFieldType(i2) != arg1.getFieldType(i2)) {
                throw new IllegalArgumentException("ReadablePartial objects must have the same set of fields");
            }
            durationFieldTypeArray[i2] = arg0.getFieldType(i2).getDurationType();
            if (i2 > 0 && durationFieldTypeArray[i2 - 1] == durationFieldTypeArray[i2]) {
                throw new IllegalArgumentException("ReadablePartial objects must not have overlapping fields");
            }
            nArray[i2] = arg1.getValue(i2) - arg0.getValue(i2);
        }
        return new Period(nArray, PeriodType.forFields(durationFieldTypeArray));
    }

    public Period plusDays(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        this.getPeriodType().addIndexedField(this, PeriodType.DAY_INDEX, nArray, arg0);
        return new Period(nArray, this.getPeriodType());
    }

    public int getHours() {
        return this.getPeriodType().getIndexedField(this, PeriodType.HOUR_INDEX);
    }

    public Period negated() {
        return this.multipliedBy(-1);
    }

    public Period(ReadablePartial arg0, ReadablePartial arg1, PeriodType arg2) {
        super(arg0, arg1, arg2);
    }
}

